/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.query.HeadResultSet;
import edu.ucsb.nceas.morpho.query.OpenDialogBox;
import edu.ucsb.nceas.morpho.query.Query;
import edu.ucsb.nceas.morpho.query.ResultPanel;
import edu.ucsb.nceas.morpho.query.SearchCommand;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.SortableJTable;
import edu.ucsb.nceas.morpho.util.StateChangeEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Vector;

public class RefreshCommand
implements Command {
    private MorphoFrame morphoFrame = null;
    private OpenDialogBox dialog = null;
    private boolean specifyMorpho = false;
    private boolean specifyOpenDialog = false;

    public RefreshCommand() {
    }

    public RefreshCommand(MorphoFrame box) {
        if (box != null) {
            this.morphoFrame = box;
            this.specifyMorpho = true;
        }
    }

    public RefreshCommand(OpenDialogBox myOpenDialog) {
        if (myOpenDialog != null) {
            this.dialog = myOpenDialog;
            this.specifyOpenDialog = true;
        }
    }

    public void execute(ActionEvent event) {
        ResultPanel resultPane = null;
        if (this.specifyOpenDialog) {
            this.morphoFrame = this.dialog.getParentFrame();
            resultPane = this.dialog.getResultPanel();
        } else if (this.specifyMorpho) {
            resultPane = RefreshCommand.getResultPanelFromMorphoFrame(this.morphoFrame);
            this.morphoFrame.setMessage("");
        } else {
            this.morphoFrame = UIController.getInstance().getCurrentActiveWindow();
            if (this.morphoFrame != null) {
                resultPane = RefreshCommand.getResultPanelFromMorphoFrame(this.morphoFrame);
                this.morphoFrame.setMessage("");
            }
        }
        if (resultPane != null) {
            SortableJTable table = resultPane.getJTable();
            boolean sorted = false;
            int index = -1;
            String order = null;
            if (table != null) {
                sorted = table.getSorted();
                index = table.getIndexOfSortedColumn();
                order = table.getOrderOfSortedColumn();
            }
            Query myQuery = null;
            myQuery = resultPane.getResultSet().getQuery();
            if (myQuery != null) {
                this.doQuery(myQuery, this.specifyOpenDialog, sorted, index, order);
            }
        }
    }

    private void doQuery(Query query, boolean forOpenDialog, boolean sort, int index, String order) {
        if (!forOpenDialog) {
            SearchCommand.doQuery(this.morphoFrame, query, sort, index, order, false);
        } else {
            Morpho morphoInQuery = query.getMorpho();
            Vector vector = new Vector();
            String source = "";
            HeadResultSet results = new HeadResultSet(query, source, vector, morphoInQuery);
            ResultPanel resultDisplayPanel = new ResultPanel(this.dialog, results, null);
            resultDisplayPanel.setVisible(true);
            this.dialog.setResultPanel(resultDisplayPanel);
            StateChangeEvent event = null;
            boolean showSearchNumber = false;
            query.displaySearchResult(this.morphoFrame, resultDisplayPanel, sort, index, order, showSearchNumber, event);
        }
    }

    public static ResultPanel getResultPanelFromMorphoFrame(MorphoFrame frame) {
        if (frame == null) {
            return null;
        }
        Component comp = frame.getContentComponent();
        if (comp == null) {
            return null;
        }
        if (comp instanceof ResultPanel) {
            ResultPanel resultPane = (ResultPanel)comp;
            return resultPane;
        }
        return null;
    }
}

