/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.framework.ButterflyFlapCoordinator;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.SwingWorker;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.query.OpenDialogBox;
import edu.ucsb.nceas.morpho.query.RefreshCommand;
import edu.ucsb.nceas.morpho.query.ResultPanel;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.event.ActionEvent;

public class OpenPackageCommand
implements Command,
ButterflyFlapCoordinator {
    private String doctype = "";
    private ResultPanel resultPanel = null;
    private OpenDialogBox open = null;
    private MorphoFrame frame = null;

    public OpenPackageCommand(OpenDialogBox dialog) {
        this.open = dialog;
    }

    public void execute(ActionEvent event) {
        if (this.open == null) {
            this.frame = UIController.getInstance().getCurrentActiveWindow();
            this.resultPanel = RefreshCommand.getResultPanelFromMorphoFrame(this.frame);
        } else {
            this.frame = this.open.getParentFrame();
            this.resultPanel = this.open.getResultPanel();
        }
        if (this.resultPanel != null) {
            String selectDocId = this.resultPanel.getSelectedId();
            boolean metacatLoc = this.resultPanel.getMetacatLocation();
            boolean localLoc = this.resultPanel.getLocalLocation();
            String location = null;
            if (metacatLoc && localLoc) {
                location = "localmetacat";
            } else if (metacatLoc && !localLoc) {
                location = "metacat";
            } else if (!metacatLoc && localLoc) {
                location = "local";
            }
            this.doctype = this.resultPanel.getDocType();
            if (this.open != null) {
                this.open.setVisible(false);
                this.open.dispose();
                this.open = null;
            }
            this.doOpenPackage(selectDocId, location, this.frame, this);
        }
    }

    private void doOpenPackage(final String docid, final String location, MorphoFrame morphoFrame, final OpenPackageCommand command) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                OpenPackageCommand.this.startFlap();
                try {
                    ServiceController services = ServiceController.getInstance();
                    ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
                    DataPackageInterface dataPackage = (DataPackageInterface)((Object)provider);
                    dataPackage.openDataPackage(location, docid, null, command, OpenPackageCommand.this.doctype);
                }
                catch (ServiceNotHandledException snhe) {
                    Log.debug(6, snhe.getMessage());
                }
                return null;
            }

            public void finished() {
                OpenPackageCommand.this.stopFlap();
            }
        };
        worker.start();
    }

    public String getDocType() {
        return this.doctype;
    }

    public void startFlap() {
        this.frame.setBusy(true);
        this.frame.setEnabled(false);
    }

    public void stopFlap() {
        this.frame.setEnabled(true);
        this.frame.setBusy(false);
    }
}

