/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.ReferencesHandler;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.DataPackageWizardPlugin;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageLibrary;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.PartyPage;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.w3c.dom.Node;

public class Project
extends AbstractUIPage {
    public final String pageID = "PROJECT";
    public final String nextPageID = "USAGE_RIGHTS";
    public final String title = "Research Project Information";
    public final String subtitle = " ";
    public final String pageNumber = "8";
    private JPanel checkBoxPanel;
    private JPanel dataPanel;
    private JPanel noDataPanel;
    private JPanel currentPanel;
    private final String PROJECT_ROOT = "project/";
    private final String XPATH_ROOT = "/eml:eml/dataset[1]/project/";
    private final String TITLE_REL_XPATH = "title[1]";
    private final String FUNDING_REL_XPATH = "funding[1]/para[1]";
    private final String PERSONNEL_REL_XPATH = "personnel";
    private final String DATAPACKAGE_PERSONNEL_GENERIC_NAME = "personnel";
    private String xPathRoot = "project/";
    private final String[] buttonsText = new String[]{"This project is part of a larger umbrella research project."};
    private JLabel titleLabel;
    private JTextField titleField;
    private JLabel fundingLabel;
    private JTextField fundingField;
    private JLabel minRequiredLabel;
    private CustomList partiesList;
    private final String[] colNames = new String[]{"Party", "Role", "Address"};
    private final Object[] editors = null;
    private OrderedMap returnMap = new OrderedMap();

    public Project() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        Box topBox = Box.createVerticalBox();
        JLabel desc = WidgetFactory.makeHTMLLabel("<b>Is your project part of a larger umbrella research project?</b> Data may be collected as part of a large research program with many sub-projects or they may be associated with a single, independent investigation. For example, a large NSF grant may provide funds for several primary investigators to collect data at various locations. ", 4);
        topBox.add(WidgetFactory.makeHalfSpacer());
        topBox.add(desc);
        final Project instance = this;
        ItemListener checkBoxListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Log.debug(45, "got checkBox command: " + e.getStateChange());
                Project.this.onLoadAction();
                if (e.getStateChange() == 2) {
                    instance.remove(Project.this.currentPanel);
                    Project.this.currentPanel = Project.this.noDataPanel;
                    instance.add((Component)Project.this.noDataPanel, "Center");
                } else if (e.getStateChange() == 1) {
                    instance.remove(Project.this.currentPanel);
                    Project.this.currentPanel = Project.this.dataPanel;
                    instance.add((Component)Project.this.dataPanel, "Center");
                }
                instance.validate();
                instance.repaint();
            }
        };
        this.checkBoxPanel = WidgetFactory.makeCheckBoxPanel(this.buttonsText, -1, checkBoxListener);
        this.checkBoxPanel.setBorder(new EmptyBorder(0, 5, 5, 10));
        topBox.add(this.checkBoxPanel);
        topBox.add(WidgetFactory.makeHalfSpacer());
        this.add((Component)topBox, "North");
        this.dataPanel = this.getDataPanel();
        this.currentPanel = this.noDataPanel = this.getNoDataPanel();
    }

    private JPanel getDataPanel() {
        JPanel panel = WidgetFactory.makeVerticalPanel(6);
        WidgetFactory.addTitledBorder(panel, "Enter Project Information");
        JPanel titlePanel = WidgetFactory.makePanel(1);
        JLabel titleDesc = WidgetFactory.makeHTMLLabel("<b>Enter the title of the project.</b> ", 1);
        panel.add(titleDesc);
        this.titleLabel = WidgetFactory.makeLabel(" Title", true);
        titlePanel.add(this.titleLabel);
        this.titleField = WidgetFactory.makeOneLineTextField();
        titlePanel.add(this.titleField);
        titlePanel.setBorder(new EmptyBorder(0, 0, 0, 25));
        panel.add(titlePanel);
        panel.add(WidgetFactory.makeHalfSpacer());
        JPanel fundingPanel = WidgetFactory.makePanel(1);
        JLabel fundingDesc = WidgetFactory.makeHTMLLabel("<b>Enter the funding sources that support this project.</b> This may include agency names and grant or contract numbers.", 2);
        panel.add(fundingDesc);
        this.fundingLabel = WidgetFactory.makeLabel(" Funding Source", false);
        fundingPanel.add(this.fundingLabel);
        this.fundingField = WidgetFactory.makeOneLineTextField();
        fundingPanel.add(this.fundingField);
        fundingPanel.setBorder(new EmptyBorder(0, 0, 0, 25));
        panel.add(fundingPanel);
        panel.add(WidgetFactory.makeHalfSpacer());
        JLabel desc = WidgetFactory.makeHTMLLabel("<b>Enter the personnel information</b>. The full name of the people or organizations responsible for the project.", 2);
        panel.add(desc);
        JPanel vPanel = WidgetFactory.makeVerticalPanel(9);
        this.minRequiredLabel = WidgetFactory.makeLabel(" One or more Personnel must be defined:", true, WizardSettings.WIZARD_CONTENT_TEXTFIELD_DIMS);
        vPanel.add(this.minRequiredLabel);
        this.partiesList = WidgetFactory.makeList(this.colNames, this.editors, 6, true, true, false, true, true, true);
        this.partiesList.setBorder(new EmptyBorder(0, 5, 5, 15));
        vPanel.add(this.partiesList);
        panel.add(vPanel);
        panel.add(Box.createGlue());
        this.initActions();
        return panel;
    }

    private JPanel getNoDataPanel() {
        JPanel panel = WidgetFactory.makeVerticalPanel(7);
        return panel;
    }

    private void initActions() {
        this.partiesList.setCustomAddAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nResearchProjInfo: CustomAddAction called");
                Project.this.showNewPartyDialog();
            }
        });
        this.partiesList.setCustomEditAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nResearchProjInfo: CustomEditAction called");
                Project.this.showEditPartyDialog();
            }
        });
        this.partiesList.setCustomDeleteAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nResearchProjInfo: CustomDeleteAction called");
                Project.this.deleteParty((CustomList)e.getSource());
            }
        });
    }

    private void showNewPartyDialog() {
        PartyPage partyPage = (PartyPage)WizardPageLibrary.getPage("PARTY_PERSONNEL");
        ModalDialog wpd = new ModalDialog(partyPage, WizardContainerFrame.getDialogParent(), 770, 570);
        if (wpd.USER_RESPONSE == 10) {
            List newRow = partyPage.getSurrogate();
            newRow.add(partyPage);
            this.partiesList.addRow(newRow);
            if (partyPage.editingOriginalRef) {
                this.updateOriginalRefPartyPage(partyPage);
            }
            DataPackageWizardPlugin.updateDOMFromPartiesList(this.partiesList, "personnel", "personnel", "PARTY_PERSONNEL");
        }
        WidgetFactory.unhiliteComponent(this.minRequiredLabel);
    }

    private void updateOriginalRefPartyPage(PartyPage partyPage) {
        String originalRefID = partyPage.getReferencesNodeIDString();
        AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (adp == null) {
            Log.debug(15, "\npackage from UIController is null");
            Log.debug(5, "ERROR: cannot update!");
            return;
        }
        List nextRowList2 = null;
        PartyPage nextPage = null;
        for (List nextRowList2 : this.partiesList.getListOfRowLists()) {
            if (nextRowList2.size() < 4 || (nextPage = (PartyPage)nextRowList2.get(3)) == partyPage || nextPage == null || !nextPage.getRefID().equals(originalRefID)) continue;
            Node root = adp.getSubtreeAtReference(originalRefID);
            OrderedMap map = XMLUtilities.getDOMTreeAsXPathMap((Node)root);
            Log.debug(45, "updateOriginalRefPartyPage() got a match with ID: " + originalRefID + "; map = " + map);
            if (map == null || map.isEmpty()) {
                return;
            }
            boolean checkParty = nextPage.setPageData(map, "/personnel");
        }
    }

    private void showEditPartyDialog() {
        List selRowList = this.partiesList.getSelectedRowList();
        if (selRowList == null || selRowList.size() < 4) {
            return;
        }
        Object dialogObj = selRowList.get(3);
        if (dialogObj == null || !(dialogObj instanceof PartyPage)) {
            return;
        }
        PartyPage editPartyPage = (PartyPage)dialogObj;
        ModalDialog wpd = new ModalDialog(editPartyPage, WizardContainerFrame.getDialogParent(), 770, 570, false);
        wpd.resetBounds();
        wpd.setVisible(true);
        if (wpd.USER_RESPONSE == 10) {
            List newRow = editPartyPage.getSurrogate();
            newRow.add(editPartyPage);
            this.partiesList.replaceSelectedRow(newRow);
            if (editPartyPage.editingOriginalRef) {
                this.updateOriginalRefPartyPage(editPartyPage);
            }
            DataPackageWizardPlugin.updateDOMFromPartiesList(this.partiesList, "personnel", "personnel", "PARTY_PERSONNEL");
        }
    }

    private void deleteParty(CustomList list) {
        if (list == null) {
            Log.debug(15, "**ERROR: deleteParty() received NULL CustomList");
            return;
        }
        AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (adp == null) {
            Log.debug(15, "\npackage from UIController is null");
            Log.debug(5, "ERROR: cannot delete!");
            return;
        }
        Log.debug(45, "BEFORE: adp=" + adp);
        List[] deletedRows = list.getSelectedRows();
        int userObjIdx = deletedRows[0].size() - 1;
        for (int i = 0; i < deletedRows.length; ++i) {
            PartyPage page = (PartyPage)deletedRows[i].get(userObjIdx);
            Node retval = ReferencesHandler.deleteOriginalReferenceSubtree(adp, page.getRefID());
            if (retval != null) continue;
            this.partiesList.removeRow(this.partiesList.getSelectedRowIndex());
            DataPackageWizardPlugin.updateDOMFromPartiesList(this.partiesList, "personnel", "personnel", "PARTY_PERSONNEL");
        }
        Log.debug(45, "AFTER: adp=" + adp);
        DataPackageWizardPlugin.updatePartiesListFromDOM(this.partiesList, "personnel", "personnel", "PARTY_PERSONNEL");
    }

    public void onLoadAction() {
        DataPackageWizardPlugin.updatePartiesListFromDOM(this.partiesList, "personnel", "personnel", "PARTY_PERSONNEL");
        WidgetFactory.unhiliteComponent(this.titleLabel);
        WidgetFactory.unhiliteComponent(this.minRequiredLabel);
    }

    public void onRewindAction() {
        DataPackageWizardPlugin.updateDOMFromPartiesList(this.partiesList, "personnel", "personnel", "PARTY_PERSONNEL");
    }

    public boolean onAdvanceAction() {
        if (this.currentPanel == this.dataPanel) {
            if (this.titleField.getText().trim().equals("")) {
                WidgetFactory.hiliteComponent(this.titleLabel);
                this.titleField.requestFocus();
                return false;
            }
            WidgetFactory.unhiliteComponent(this.titleLabel);
            if (this.partiesList.getRowCount() < 1) {
                WidgetFactory.hiliteComponent(this.minRequiredLabel);
                return false;
            }
            WidgetFactory.unhiliteComponent(this.minRequiredLabel);
        }
        DataPackageWizardPlugin.updateDOMFromPartiesList(this.partiesList, "personnel", "personnel", "PARTY_PERSONNEL");
        return true;
    }

    public OrderedMap getPageData(String rootXPath) {
        if (rootXPath == null) {
            rootXPath = "/eml:eml/dataset[1]/project/";
        }
        if ((rootXPath = rootXPath.trim()).length() < 1) {
            rootXPath = "/eml:eml/dataset[1]/project/";
        }
        if (!rootXPath.endsWith("/")) {
            rootXPath = rootXPath + "/";
        }
        this.returnMap.clear();
        if (this.currentPanel == this.dataPanel) {
            this.returnMap.put((Object)(rootXPath + "title[1]"), (Object)this.titleField.getText().trim());
            int index = 1;
            Object nextRowObj2 = null;
            List nextRowList = null;
            Object nextUserObject = null;
            OrderedMap nextNVPMap = null;
            PartyPage nextPartyPage = null;
            List rowLists = this.partiesList.getListOfRowLists();
            if (rowLists != null && rowLists.isEmpty()) {
                return null;
            }
            for (Object nextRowObj2 : rowLists) {
                if (nextRowObj2 == null || (nextRowList = (List)nextRowObj2).size() < 4 || (nextUserObject = nextRowList.get(3)) == null) continue;
                nextPartyPage = nextUserObject;
                nextNVPMap = nextPartyPage.getPageData(rootXPath + "personnel" + "[" + index++ + "]");
                this.returnMap.putAll((Map)nextNVPMap);
            }
            if (!this.fundingField.getText().trim().equals("")) {
                this.returnMap.put((Object)(rootXPath + "funding[1]/para[1]"), (Object)this.fundingField.getText().trim());
            }
        }
        return this.returnMap;
    }

    public OrderedMap getPageData() {
        return this.getPageData("/eml:eml/dataset[1]/project/");
    }

    public String getPageID() {
        return "PROJECT";
    }

    public String getTitle() {
        return "Research Project Information";
    }

    public String getSubtitle() {
        return " ";
    }

    public String getNextPageID() {
        return "USAGE_RIGHTS";
    }

    public String getPageNumber() {
        return "8";
    }

    public boolean setPageData(OrderedMap map, String _xPathRoot) {
        if (_xPathRoot != null && _xPathRoot.trim().length() > 0) {
            this.xPathRoot = _xPathRoot;
        }
        JCheckBox checkBox = (JCheckBox)this.checkBoxPanel.getComponent(0);
        checkBox.setSelected(true);
        if (map == null || map.isEmpty()) {
            this.resetBlankData();
            return true;
        }
        ArrayList toDeleteList = new ArrayList();
        Object nextXPathObj = null;
        String nextXPath = null;
        Object nextValObj = null;
        String nextVal = null;
        Iterator keyIt = map.keySet().iterator();
        ArrayList personnelList = new ArrayList();
        while (keyIt.hasNext()) {
            nextXPathObj = keyIt.next();
            if (nextXPathObj == null) continue;
            nextXPath = (String)nextXPathObj;
            nextValObj = map.get(nextXPathObj);
            nextVal = nextValObj == null ? "" : ((String)nextValObj).trim();
            nextXPath = nextXPath.substring(nextXPath.lastIndexOf(this.xPathRoot) + this.xPathRoot.length());
            Log.debug(45, "Project: TRIMMED nextXPath   = " + nextXPath);
            if (nextXPath.startsWith("title[1]")) {
                this.titleField.setText(nextVal);
                toDeleteList.add(nextXPathObj);
                continue;
            }
            if (nextXPath.startsWith("funding[1]/para[1]")) {
                this.fundingField.setText(nextVal);
                toDeleteList.add(nextXPathObj);
                continue;
            }
            if (nextXPath.startsWith("personnel[")) {
                Log.debug(45, ">>>>>>>>>> adding to personnelList: nextXPathObj=" + nextXPathObj + "; nextValObj=" + nextValObj);
                this.addToPersonnel(nextXPathObj, nextValObj, personnelList);
                toDeleteList.add(nextXPathObj);
                continue;
            }
            if (!nextXPath.startsWith("@scope")) continue;
            toDeleteList.add(nextXPathObj);
        }
        boolean partyRetVal = DataPackageWizardPlugin.populatePartiesList(this.partiesList, personnelList, this.xPathRoot + "personnel", "PARTY_PERSONNEL");
        if (!partyRetVal) {
            Log.debug(20, "Project.setPageData - Party sub-class returned FALSE");
        }
        Iterator dlIt = toDeleteList.iterator();
        while (dlIt.hasNext()) {
            map.remove(dlIt.next());
        }
        boolean returnVal = map.isEmpty();
        if (!returnVal) {
            Log.debug(20, "Project.setPageData returning FALSE! Map still contains:" + map);
        }
        return returnVal && partyRetVal;
    }

    private void resetBlankData() {
        this.titleField.setText("");
        this.fundingField.setText("");
        this.partiesList.removeAllRows();
    }

    private int getFirstPredicate(String xpath, String firstSegment) {
        String tempXPath = xpath.substring(xpath.indexOf(firstSegment) + firstSegment.length());
        return Integer.parseInt(tempXPath.substring(0, tempXPath.indexOf("]")));
    }

    private void addToPersonnel(Object nextPersonnelXPathObj, Object nextPersonnelVal, List personnelList) {
        if (nextPersonnelXPathObj == null) {
            return;
        }
        String nextPersonnelXPath = (String)nextPersonnelXPathObj;
        int predicate = this.getFirstPredicate(nextPersonnelXPath, "personnel[");
        if (predicate >= personnelList.size()) {
            for (int i = personnelList.size(); i <= predicate; ++i) {
                personnelList.add(new OrderedMap());
            }
        }
        if (predicate < personnelList.size()) {
            Object nextMapObj = personnelList.get(predicate);
            OrderedMap nextMap = (OrderedMap)nextMapObj;
            nextMap.put(nextPersonnelXPathObj, nextPersonnelVal);
        } else {
            Log.debug(15, "**** ERROR - Project.addToPersonnel() - predicate > personnelList.size()");
        }
    }
}

