/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageLibrary;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageSubPanelAPI;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.UnitTypesListItem;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.transform.TransformerException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IntervalRatioPanel
extends JPanel
implements WizardPageSubPanelAPI {
    private JLabel unitsPickListLabel;
    private JLabel precisionLabel;
    private JLabel numberTypeLabel;
    private JLabel boundsLabel;
    private UnitsPickList unitsPickList;
    private UnitTypesListItem[] unitTypesListItems;
    private JTextField precisionField;
    private JComboBox numberTypePickList;
    private CustomList boundsList;
    private AbstractUIPage customPage = null;
    private List customPages = new ArrayList();
    private String[] numberTypesDisplayVals = new String[]{"NATURAL (non-zero counting numbers: 1, 2, 3..)", "WHOLE  (counting numbers & zero: 0, 1, 2, 3..)", "INTEGER (+/- counting nums & zero: -2, -1, 0, 1..)", "REAL  (+/- fractions & non-fractions: -1/2, 3.14..)"};
    private String[] numberEMLVals = new String[]{"natural", "whole", "integer", "real"};
    private String[] boundsPickListValues = new String[]{"<", "<="};
    private JButton addButton;
    private JButton delButton;
    private AbstractUIPage parentPage;
    private String numericDomainID = "";
    private OrderedMap returnMap = new OrderedMap();

    public IntervalRatioPanel(AbstractUIPage page) {
        this.parentPage = page;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        int width = WizardSettings.WIZARD_CONTENT_SINGLE_LINE_DIMS.width;
        int height = 7 * WizardSettings.WIZARD_CONTENT_SINGLE_LINE_DIMS.height;
        Dimension dims = new Dimension(width, height);
        this.setPreferredSize(dims);
        this.unitsPickListLabel = WidgetFactory.makeLabel("Standard Unit:", true, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.unitsPickList = new UnitsPickList(this.parentPage, this.unitsPickListLabel);
        this.add(Box.createGlue());
        this.add(this.unitsPickList);
        JPanel precisionPanel = WidgetFactory.makePanel();
        this.precisionLabel = WidgetFactory.makeLabel("Precision:", true, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        precisionPanel.add(this.precisionLabel);
        this.precisionField = WidgetFactory.makeOneLineTextField();
        precisionPanel.add(this.precisionField);
        JPanel precisionGrid = new JPanel(new GridLayout(1, 2));
        precisionGrid.add(precisionPanel);
        precisionGrid.add(this.getLabel("<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\"><font style=\"font-size: 9px;\" color=\"#666666\">e.g: for an attribute with unit \"meter\", a precision of \"0.1\" would be interpreted as precise to the nearest 1/10th of a meter</font></html>"));
        this.add(Box.createGlue());
        this.add(precisionGrid);
        ItemListener listener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String value = e.getItem().toString();
                Log.debug(45, "numberTypePickList state changed: " + value);
            }
        };
        this.numberTypePickList = WidgetFactory.makePickList(this.numberTypesDisplayVals, false, 0, listener);
        this.numberTypePickList.setPreferredSize(new Dimension(200, 10));
        JPanel numberTypePanel = WidgetFactory.makePanel();
        this.numberTypeLabel = WidgetFactory.makeLabel("Number Type:", true, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        numberTypePanel.add(this.numberTypeLabel);
        numberTypePanel.add(this.numberTypePickList);
        JPanel numericDomainGrid = new JPanel(new GridLayout(1, 2));
        numericDomainGrid.add(numberTypePanel);
        numericDomainGrid.add(this.getLabel(""));
        this.add(Box.createGlue());
        this.add(numericDomainGrid);
        JPanel boundsGrid = new JPanel(new GridLayout(1, 2));
        JPanel boundsPanel = WidgetFactory.makePanel(3);
        this.boundsLabel = WidgetFactory.makeLabel("Bounds:", false, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        boundsPanel.add(this.boundsLabel);
        String[] colNames = new String[]{"Min.", "", "", "", "Max."};
        JLabel valueLabel = new JLabel("value", null, 0);
        JComboBox combobox1 = WidgetFactory.makePickList(this.boundsPickListValues, false, 0, null);
        JComboBox combobox2 = WidgetFactory.makePickList(this.boundsPickListValues, false, 0, null);
        Object[] colTemplates = new Object[]{new JTextField(), combobox1, valueLabel, combobox2, new JTextField()};
        this.boundsList = WidgetFactory.makeList(colNames, colTemplates, 2, false, false, false, false, false, false);
        boundsPanel.add(this.boundsList);
        boundsGrid.add(boundsPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        this.addButton = new JButton("Add");
        this.addButton.setPreferredSize(WizardSettings.LIST_BUTTON_DIMS_SMALL);
        this.addButton.setMaximumSize(WizardSettings.LIST_BUTTON_DIMS_SMALL);
        this.addButton.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        this.delButton = new JButton("Delete");
        this.delButton.setPreferredSize(WizardSettings.LIST_BUTTON_DIMS_SMALL);
        this.delButton.setMaximumSize(WizardSettings.LIST_BUTTON_DIMS_SMALL);
        this.delButton.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        this.delButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                IntervalRatioPanel.this.boundsList.fireAddAction();
                if (IntervalRatioPanel.this.boundsList.getRowCount() > 0) {
                    IntervalRatioPanel.this.delButton.setEnabled(true);
                }
            }
        });
        this.delButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                IntervalRatioPanel.this.boundsList.fireDeleteAction();
                if (IntervalRatioPanel.this.boundsList.getRowCount() == 0) {
                    IntervalRatioPanel.this.delButton.setEnabled(false);
                }
            }
        });
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.delButton);
        buttonPanel.add(Box.createVerticalGlue());
        JPanel outerButtonPanel = new JPanel();
        outerButtonPanel.setLayout(new BoxLayout(outerButtonPanel, 0));
        outerButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        outerButtonPanel.add(buttonPanel);
        boundsGrid.add(outerButtonPanel);
        this.add(Box.createVerticalGlue());
        this.add(Box.createGlue());
        this.add(boundsGrid);
    }

    private JLabel getLabel(String text) {
        if (text == null) {
            text = "";
        }
        JLabel label = new JLabel(text);
        label.setAlignmentX(1.0f);
        label.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        label.setBorder(BorderFactory.createMatteBorder(1, 10, 1, 3, (Color)null));
        return label;
    }

    public void onLoadAction() {
        WidgetFactory.unhiliteComponent(this.unitsPickListLabel);
        WidgetFactory.unhiliteComponent(this.precisionLabel);
        WidgetFactory.unhiliteComponent(this.numberTypeLabel);
        this.unhiliteBoundsLabel();
        this.precisionField.requestFocus();
    }

    public boolean validateUserInput() {
        this.boundsList.deleteEmptyRows((short)61, new short[]{10, 30, 30, 30, 10});
        if (this.unitsPickList.getSelectedUnit().trim().equals("")) {
            WidgetFactory.hiliteComponent(this.unitsPickListLabel);
            return false;
        }
        WidgetFactory.unhiliteComponent(this.unitsPickListLabel);
        String precision = this.precisionField.getText().trim();
        if (precision.equals("") || !WizardSettings.isFloat(precision)) {
            WidgetFactory.hiliteComponent(this.precisionLabel);
            this.precisionField.requestFocus();
            return false;
        }
        WidgetFactory.unhiliteComponent(this.precisionLabel);
        if (this.numberTypePickList.getSelectedItem().toString().trim().equals("")) {
            WidgetFactory.hiliteComponent(this.numberTypeLabel);
            return false;
        }
        WidgetFactory.unhiliteComponent(this.numberTypeLabel);
        if (!this.containsOnlyNumericValues(this.boundsList, 0, 4)) {
            WidgetFactory.hiliteComponent(this.boundsLabel);
            return false;
        }
        this.unhiliteBoundsLabel();
        return true;
    }

    private void unhiliteBoundsLabel() {
        WidgetFactory.unhiliteComponent(this.boundsLabel);
        this.boundsLabel.setForeground(WizardSettings.WIZARD_CONTENT_TEXT_COLOR);
    }

    private boolean containsOnlyNumericValues(CustomList list, int idxColA, int idxColB) {
        boolean returnVal = true;
        List rowLists = list.getListOfRowLists();
        String nextColAStr = null;
        String nextColBStr = null;
        for (Object nextRowObj : rowLists) {
            boolean nextColBIsNull;
            List nextRow;
            if (nextRowObj == null || (nextRow = (List)nextRowObj).size() < 1) continue;
            boolean nextColAIsNull = nextRow.get(idxColA) == null;
            boolean bl = nextColBIsNull = nextRow.get(idxColB) == null;
            if (nextColAIsNull && nextColBIsNull) continue;
            if (!(nextColAIsNull || (nextColAStr = (String)nextRow.get(idxColA)).trim().equals("") || WizardSettings.isFloat(nextColAStr))) {
                returnVal = false;
            }
            if (nextColBIsNull || (nextColBStr = (String)nextRow.get(idxColB)).trim().equals("") || WizardSettings.isFloat(nextColBStr)) continue;
            returnVal = false;
        }
        return returnVal;
    }

    public OrderedMap getPanelData(String xPathRoot) {
        this.returnMap.clear();
        String type = this.unitsPickList.getSelectedType().trim();
        String unit = this.unitsPickList.getSelectedUnit().trim();
        if (WizardSettings.isCustomUnit(type, unit)) {
            this.returnMap.put((Object)(xPathRoot + "/unit/customUnit"), (Object)unit);
        } else {
            this.returnMap.put((Object)(xPathRoot + "/unit/standardUnit"), (Object)unit);
        }
        this.returnMap.put((Object)(xPathRoot + "/precision"), (Object)this.precisionField.getText().trim());
        String id = this.numericDomainID.trim();
        if (id != null && !id.equals("")) {
            this.returnMap.put((Object)(xPathRoot + "/numericDomain/@id"), (Object)id);
        }
        String numberType = this.numberTypePickList.getSelectedItem().toString().trim();
        String emlNumberType = null;
        if (numberType.equals(this.numberTypesDisplayVals[0])) {
            emlNumberType = this.numberEMLVals[0];
        } else if (numberType.equals(this.numberTypesDisplayVals[1])) {
            emlNumberType = this.numberEMLVals[1];
        } else if (numberType.equals(this.numberTypesDisplayVals[2])) {
            emlNumberType = this.numberEMLVals[2];
        } else if (numberType.equals(this.numberTypesDisplayVals[3])) {
            emlNumberType = this.numberEMLVals[3];
        }
        this.returnMap.put((Object)(xPathRoot + "/numericDomain/numberType"), (Object)emlNumberType);
        xPathRoot = xPathRoot + "/numericDomain/bounds[";
        int index = 0;
        this.boundsList.fireEditingStopped();
        List rowLists = this.boundsList.getListOfRowLists();
        String nextMin = null;
        String nextMax = null;
        Object nextExcl = null;
        for (Object nextRowObj : rowLists) {
            List nextRow;
            if (nextRowObj == null || (nextRow = (List)nextRowObj).size() < 1) continue;
            ++index;
            if (nextRow.get(0) != null && !(nextMin = (String)nextRow.get(0)).trim().equals("")) {
                this.returnMap.put((Object)(xPathRoot + index + "]/minimum"), (Object)nextMin);
                nextExcl = nextRow.get(1);
                if (nextExcl != null && ((String)nextExcl).equals("<")) {
                    this.returnMap.put((Object)(xPathRoot + index + "]/minimum/@exclusive"), (Object)"true");
                } else {
                    this.returnMap.put((Object)(xPathRoot + index + "]/minimum/@exclusive"), (Object)"false");
                }
            }
            if (nextRow.get(4) == null || (nextMax = (String)nextRow.get(4)).trim().equals("")) continue;
            this.returnMap.put((Object)(xPathRoot + index + "]/maximum"), (Object)nextMax);
            nextExcl = nextRow.get(3);
            if (nextExcl != null && ((String)nextExcl).equals("<")) {
                this.returnMap.put((Object)(xPathRoot + index + "]/maximum/@exclusive"), (Object)"true");
                continue;
            }
            this.returnMap.put((Object)(xPathRoot + index + "]/maximum/@exclusive"), (Object)"false");
        }
        return this.returnMap;
    }

    public void setPanelData(String xPathRoot, OrderedMap map) {
        String type;
        String precision;
        String unit;
        String id = (String)map.get((Object)(xPathRoot + "/numericDomain/@id"));
        if (id != null) {
            this.numericDomainID = id.toString();
            map.remove((Object)(xPathRoot + "/numericDomain/@id"));
        }
        if ((unit = (String)map.get((Object)(xPathRoot + "/unit/standardUnit"))) != null) {
            map.remove((Object)(xPathRoot + "/unit/standardUnit"));
        } else {
            unit = (String)map.get((Object)(xPathRoot + "/unit/customUnit"));
            if (unit != null) {
                map.remove((Object)(xPathRoot + "/unit/customUnit"));
            }
        }
        if (unit != null && !unit.equals("")) {
            int totUnitTypes = this.unitTypesListItems.length;
            String[] unitsOfThisType = null;
            for (int i = 1; i < totUnitTypes; ++i) {
                unitsOfThisType = this.unitTypesListItems[i].getUnitsOfThisType();
                int pos = -1;
                pos = this.isPresentInList(unit, unitsOfThisType);
                if (pos < 0) continue;
                this.unitsPickList.setSelectedUnit(i, pos);
                break;
            }
        }
        if ((precision = (String)map.get((Object)(xPathRoot + "/precision"))) != null) {
            this.precisionField.setText(precision);
            map.remove((Object)(xPathRoot + "/precision"));
        }
        if ((type = (String)map.get((Object)(xPathRoot + "/numericDomain/numberType"))) != null) {
            this.numberTypePickList.setSelectedItem(type);
            map.remove((Object)(xPathRoot + "/numericDomain/numberType"));
        }
        int index = 1;
        while (true) {
            ArrayList<String> row = new ArrayList<String>();
            Object min = map.get((Object)(xPathRoot + "/numericDomain/bounds[" + index + "]/minimum"));
            if (min != null) {
                map.remove((Object)(xPathRoot + "/numericDomain/bounds[" + index + "]/minimum"));
            }
            if (index == 1 && min == null) {
                min = map.get((Object)(xPathRoot + "/numericDomain/bounds/minimum"));
            }
            if (min != null) {
                row.add((String)min);
                map.remove((Object)(xPathRoot + "/numericDomain/bounds/minimum"));
                Object excl = map.get((Object)(xPathRoot + "/numericDomain/bounds[" + index + "]/minimum/@exclusive"));
                if (excl != null) {
                    map.remove((Object)(xPathRoot + "/numericDomain/bounds[" + index + "]/minimum/@exclusive"));
                }
                if (index == 1 && excl == null) {
                    excl = map.get((Object)(xPathRoot + "/numericDomain/bounds/minimum/@exclusive"));
                }
                if (excl != null) {
                    map.remove((Object)(xPathRoot + "/numericDomain/bounds/minimum/@exclusive"));
                    if (((String)excl).equals("true")) {
                        row.add("<");
                    } else {
                        row.add("<=");
                    }
                }
            } else {
                row.add("");
                row.add("<");
            }
            row.add("value");
            Object max = (String)map.get((Object)(xPathRoot + "/numericDomain/bounds[" + index + "]/maximum"));
            if (max != null) {
                map.remove((Object)(xPathRoot + "/numericDomain/bounds[" + index + "]/maximum"));
            }
            if (index == 1 && max == null) {
                max = map.get((Object)(xPathRoot + "/numericDomain/bounds/maximum"));
            }
            if (max != null) {
                Object excl = map.get((Object)(xPathRoot + "/numericDomain/bounds[" + index + "]/maximum/@exclusive"));
                if (excl != null) {
                    map.remove((Object)(xPathRoot + "/numericDomain/bounds[" + index + "]/maximum/@exclusive"));
                }
                if (index == 1 && excl == null) {
                    excl = map.get((Object)(xPathRoot + "/numericDomain/bounds/maximum/@exclusive"));
                }
                if (excl != null) {
                    map.remove((Object)(xPathRoot + "/numericDomain/bounds/maximum/@exclusive"));
                    if (((String)excl).equals("true")) {
                        row.add("<");
                    } else {
                        row.add("<=");
                    }
                }
                row.add((String)max);
                map.remove((Object)(xPathRoot + "/numericDomain/bounds/maximum"));
            } else {
                row.add("<");
                row.add("");
            }
            if (min == null && max == null) break;
            this.boundsList.addRow(row);
            ++index;
        }
        this.boundsList.fireEditingStopped();
    }

    private int isPresentInList(String unitType, String[] unitsOfThisType) {
        return Arrays.binarySearch(unitsOfThisType, unitType);
    }

    static /* synthetic */ UnitTypesListItem[] access$202(IntervalRatioPanel x0, UnitTypesListItem[] x1) {
        x0.unitTypesListItems = x1;
        return x1;
    }

    class UnitsPickList
    extends JPanel {
        private final JComboBox unitTypesList = new JComboBox();
        private final JComboBox unitsList = new JComboBox();
        private final String UNITLIST_DEFAULT = "- Select a Unit Type -";
        private JButton newUnit;
        private JLabel unitTypeLabel;
        private JPanel parentPanel;
        private JDialog customUnitDialog = null;
        public static final int CUSTOM_UNIT_PANEL_WIDTH = 700;
        public static final int CUSTOM_UNIT_PANEL_HEIGHT = 450;

        public UnitsPickList(JPanel parent, JLabel unitTypeLabel) {
            this.parentPanel = parent;
            this.unitTypeLabel = unitTypeLabel;
            this.init();
        }

        private void init() {
            IntervalRatioPanel.access$202(IntervalRatioPanel.this, this.getUnitTypesArray());
            this.unitTypesList.setModel(new DefaultComboBoxModel<UnitTypesListItem>(IntervalRatioPanel.this.unitTypesListItems));
            this.unitTypesList.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    String value = e.getItem().toString();
                    Log.debug(45, "unitTypesList state changed: " + value);
                    if (UnitsPickList.this.unitTypesList.getSelectedIndex() == 0) {
                        UnitsPickList.this.unitsList.setEnabled(false);
                    } else {
                        UnitsPickList.this.unitsList.setEnabled(true);
                    }
                    UnitsPickList.this.unitsList.setModel(((UnitTypesListItem)e.getItem()).getComboBoxModel());
                    String utype = ((UnitTypesListItem)UnitsPickList.this.unitTypesList.getSelectedItem()).getOriginalUnitType();
                    String preftype = WizardSettings.getPreferredType(utype);
                    if (preftype != null) {
                        UnitsPickList.this.unitsList.setSelectedItem(preftype);
                    } else {
                        UnitsPickList.this.unitsList.setSelectedIndex(0);
                    }
                    if (UnitsPickList.this.unitsList.isShowing()) {
                        UnitsPickList.this.unitsList.showPopup();
                    }
                }
            });
            this.setUI(this.unitTypesList);
            this.unitTypesList.setSelectedIndex(0);
            JPanel unitTypesPanel = WidgetFactory.makePanel();
            unitTypesPanel.add(this.unitTypeLabel);
            unitTypesPanel.add(this.unitTypesList);
            this.unitsList.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    String value = e.getItem().toString();
                    Log.debug(45, "unitsList state changed: " + value);
                }
            });
            this.setUI(this.unitsList);
            this.newUnit = new JButton("Define new unit");
            this.newUnit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    IntervalRatioPanel.this.customPage = WizardPageLibrary.getPage("CUSTOM_UNIT_PAGE");
                    int dwd = 740;
                    int dht = 540;
                    ActionListener okAction = new ActionListener(){

                        public void actionPerformed(ActionEvent ae) {
                            UnitsPickList.this.customUnitOKAction();
                        }
                    };
                    ActionListener cancelAction = new ActionListener(){

                        public void actionPerformed(ActionEvent ae) {
                            UnitsPickList.this.customUnitDialog.setVisible(false);
                        }
                    };
                    UnitsPickList.this.customUnitDialog = WidgetFactory.makeContainerDialogNoParent(IntervalRatioPanel.this.customPage, okAction, cancelAction);
                    UnitsPickList.this.customUnitDialog.setTitle("New Unit Definition");
                    Point loc = UnitsPickList.this.parentPanel.getLocationOnScreen();
                    int wd = UnitsPickList.this.parentPanel.getWidth();
                    int ht = UnitsPickList.this.parentPanel.getHeight();
                    UnitsPickList.this.customUnitDialog.setLocation((int)loc.getX() + wd / 2 - dwd / 2, (int)loc.getY() + ht / 2 - dht / 2);
                    UnitsPickList.this.customUnitDialog.setSize(dwd, dht);
                    UnitsPickList.this.customUnitDialog.setVisible(true);
                }
            });
            JPanel unitsPanel = WidgetFactory.makePanel();
            unitsPanel.add(this.unitsList);
            unitsPanel.add(WidgetFactory.makeDefaultSpacer());
            unitsPanel.add(this.newUnit);
            unitsPanel.add(WidgetFactory.makeDefaultSpacer());
            unitsPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            this.setLayout(new GridLayout(1, 2));
            this.setPreferredSize(WizardSettings.WIZARD_CONTENT_SINGLE_LINE_DIMS);
            this.setMaximumSize(WizardSettings.WIZARD_CONTENT_SINGLE_LINE_DIMS);
            this.add(unitTypesPanel);
            this.add(unitsPanel);
            this.unitsList.setEnabled(false);
        }

        private void customUnitOKAction() {
            UnitTypesListItem item;
            if (IntervalRatioPanel.this.customPage == null) {
                return;
            }
            if (!IntervalRatioPanel.this.customPage.onAdvanceAction()) {
                return;
            }
            this.customUnitDialog.setVisible(false);
            IntervalRatioPanel.this.customPages.add(IntervalRatioPanel.this.customPage);
            String xPath = "/additionalMetadata";
            OrderedMap map = IntervalRatioPanel.this.customPage.getPageData(xPath);
            String type = this.getUnitTypeOfNewUnit(map, xPath);
            String newUnit = this.getNewUnit(map, xPath);
            String SIUnit = this.getSIUnit(map, xPath);
            String stdType = WizardSettings.getStandardFormOfUnitType(type);
            int idx = this.getIndexOfStandardType(WizardSettings.getDisplayFormOfUnitType(type));
            if (idx < 0) {
                item = new UnitTypesListItem(stdType, newUnit);
                Object[] newArray = new UnitTypesListItem[IntervalRatioPanel.this.unitTypesListItems.length + 1];
                WizardSettings.insertObjectIntoArray(IntervalRatioPanel.this.unitTypesListItems, item, newArray);
                IntervalRatioPanel.access$202(IntervalRatioPanel.this, (UnitTypesListItem[])newArray);
                this.unitTypesList.setModel(new DefaultComboBoxModel<UnitTypesListItem>(IntervalRatioPanel.this.unitTypesListItems));
                this.unitTypesList.setSelectedItem(item);
                this.unitsList.setSelectedItem(newUnit);
                this.unitsList.hidePopup();
            } else if (idx >= 0 && idx < IntervalRatioPanel.this.unitTypesListItems.length) {
                item = IntervalRatioPanel.this.unitTypesListItems[idx];
                item.addUnit(newUnit);
                this.unitTypesList.setSelectedItem(item);
                this.unitsList.setModel(item.getComboBoxModel());
                this.unitsList.setSelectedItem(newUnit);
                this.unitsList.hidePopup();
            }
            AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
            if (adp == null) {
                Log.debug(7, "Error obtaining the datapackage while trying to add a custom unit!!");
            } else {
                adp.addNewUnit(stdType, newUnit);
                this.insertIntoDOMTree(adp, map);
            }
        }

        private void insertIntoDOMTree(AbstractDataPackage adp, OrderedMap map) {
            DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
            Document doc = impl.createDocument("", "additionalMetadata", null);
            Element metadataRoot = doc.getDocumentElement();
            try {
                XMLUtilities.getXPathMapAsDOMTree((Map)map, (Node)metadataRoot);
            }
            catch (TransformerException w) {
                Log.debug(5, "Unable to add addtmetadata details to package!");
                Log.debug(15, "TransformerException (" + w + ") calling " + "XMLUtilities.getXPathMapAsDOMTree(map, metadataRoot) with \n" + "map = " + map + " and methodRoot = " + metadataRoot);
                w.printStackTrace();
                return;
            }
            Node check1 = adp.appendAdditionalMetadata(metadataRoot);
            if (check1 != null) {
                Log.debug(45, "added new addt metadata details to package...");
            } else {
                Log.debug(45, "cldnt added new metadata details to package...");
            }
        }

        private String getUnitTypeOfNewUnit(OrderedMap map, String xPath) {
            String t = (String)map.get((Object)(xPath + "/unitList/unit[1]/@unitType"));
            return t;
        }

        private String getNewUnit(OrderedMap map, String xPath) {
            String unit = (String)map.get((Object)(xPath + "/unitList/unit[1]/@name"));
            return unit;
        }

        private String getSIUnit(OrderedMap map, String xPath) {
            return (String)map.get((Object)(xPath + "/unitList/unit[1]/@parentSI"));
        }

        private int getIndexOfStandardType(String unitType) {
            for (int i = 0; i < IntervalRatioPanel.this.unitTypesListItems.length; ++i) {
                String type = IntervalRatioPanel.this.unitTypesListItems[i].toString();
                if (!type.equals(unitType)) continue;
                return i;
            }
            return -1;
        }

        private boolean isNewType(OrderedMap map, String xPath) {
            String t = (String)map.get((Object)(xPath + "/unitList/unitType[1]/@name"));
            return t != null;
        }

        public String getSelectedUnit() {
            Object selItem = this.unitsList.getSelectedItem();
            if (selItem == null) {
                return "";
            }
            return selItem.toString();
        }

        public String getSelectedType() {
            Object selItem = this.unitTypesList.getSelectedItem();
            if (selItem == null) {
                return "";
            }
            return selItem.toString();
        }

        public String getSelectedSIUnit() {
            Object selItem = this.unitTypesList.getSelectedItem();
            if (selItem == null) {
                return "";
            }
            return WizardSettings.getPreferredType(((UnitTypesListItem)selItem).getOriginalUnitType());
        }

        public void setSelectedUnit(int typePos, int unitPos) {
            this.unitTypesList.setSelectedIndex(typePos);
            this.unitsList.setEnabled(true);
            this.unitsList.setSelectedIndex(unitPos);
        }

        private UnitTypesListItem[] getUnitTypesArray() {
            Object[] unitTypesArray;
            Object[] totTypesArray = unitTypesArray = WizardSettings.getUnitDictionaryUnitTypes();
            Object[] customTypesArray = new String[]{};
            AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
            if (adp != null && (customTypesArray = adp.getUnitDictionaryCustomUnitTypes()) != null && customTypesArray.length > 0) {
                ArrayList<String> totUnits = new ArrayList<String>();
                int k = 0;
                for (k = 0; k < unitTypesArray.length; ++k) {
                    totUnits.add(unitTypesArray[k]);
                }
                for (int l = 0; l < customTypesArray.length; ++l) {
                    if (Arrays.binarySearch(unitTypesArray, customTypesArray[l]) >= 0) continue;
                    totUnits.add(customTypesArray[l]);
                }
                Object[] newArr = new String[totUnits.size()];
                newArr = totUnits.toArray(newArr);
                Arrays.sort(newArr);
                totTypesArray = newArr;
            }
            int totUnitTypes = totTypesArray.length;
            UnitTypesListItem[] listItemsArray = new UnitTypesListItem[totUnitTypes + 1];
            Object[] unitsOfThisType = null;
            String[] customUnitsOfThisType = null;
            listItemsArray[0] = new UnitTypesListItem("- Select a Unit Type -", new String[]{""});
            String prevType = "";
            for (int i = 0; i < totUnitTypes; ++i) {
                Object type = totTypesArray[i];
                if (Arrays.binarySearch(unitTypesArray, type) >= 0) {
                    unitsOfThisType = WizardSettings.getUnitDictionaryUnitsOfType((String)totTypesArray[i]);
                    if (Arrays.binarySearch(customTypesArray, totTypesArray[i]) >= 0) {
                        customUnitsOfThisType = adp.getUnitDictionaryUnitsOfType((String)totTypesArray[i]);
                        Object[] newArr = new String[unitsOfThisType.length + customUnitsOfThisType.length];
                        int k = 0;
                        for (k = 0; k < unitsOfThisType.length; ++k) {
                            newArr[k] = unitsOfThisType[k];
                        }
                        for (int l = 0; l < customUnitsOfThisType.length; ++l) {
                            newArr[k++] = customUnitsOfThisType[l];
                        }
                        Arrays.sort(newArr);
                        unitsOfThisType = newArr;
                    }
                    listItemsArray[i + 1] = new UnitTypesListItem((String)totTypesArray[i], (String[])unitsOfThisType);
                    continue;
                }
                unitsOfThisType = adp.getUnitDictionaryUnitsOfType((String)totTypesArray[i]);
                listItemsArray[i + 1] = new UnitTypesListItem((String)totTypesArray[i], (String[])unitsOfThisType);
            }
            return listItemsArray;
        }

        private void setUI(JComboBox list) {
            list.setFont(WizardSettings.WIZARD_CONTENT_FONT);
            list.setForeground(WizardSettings.WIZARD_CONTENT_TEXT_COLOR);
            list.setEditable(false);
        }

        public void setData(int unitTypeIndex, int unitIndex) {
            UnitTypesListItem[] listItemsArray = this.getUnitTypesArray();
            if (listItemsArray == null) {
                return;
            }
            int length = listItemsArray.length;
            if (length < unitTypeIndex) {
                return;
            }
            this.unitTypesList.setSelectedIndex(unitTypeIndex);
            this.unitsList.setModel(listItemsArray[unitTypeIndex].getComboBoxModel());
            this.unitsList.setEnabled(true);
            this.unitsList.setSelectedIndex(unitIndex);
            this.unitsList.setPopupVisible(false);
        }

        public void getData(int[] indicesArray) {
            indicesArray[0] = this.unitTypesList.getSelectedIndex();
            indicesArray[1] = this.unitsList.getSelectedIndex();
        }
    }
}

