/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.plugins.TextImportListener;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.TextImportWizardEml2;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.DataLocation;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.io.File;

public class ImportWizard
extends AbstractUIPage
implements TextImportListener {
    public final String pageID = "TEXT_IMPORT_WIZARD";
    public String nextPageID = "SUMMARY";
    public final String pageNumber = "";
    public final String title = "Data Package Wizard";
    public final String subtitle = "Import Data/Information";
    private WizardContainerFrame mainWizFrame;
    private OrderedMap resultsMap;
    private boolean importCompletedOK = false;
    private TextImportWizardEml2 importWizFrame;

    public ImportWizard(WizardContainerFrame mainWizFrame) {
        this.mainWizFrame = mainWizFrame;
        this.init();
    }

    private void init() {
    }

    public void onLoadAction() {
        if (!this.importCompletedOK) {
            AbstractUIPage locationPage = this.mainWizFrame.getPreviousPage();
            File dataFileObj = ((DataLocation)locationPage).getDataFile();
            this.importWizFrame = new TextImportWizardEml2(dataFileObj, this, this.mainWizFrame);
            this.importWizFrame.setBounds(this.mainWizFrame.getX(), this.mainWizFrame.getY(), this.mainWizFrame.getWidth(), this.mainWizFrame.getHeight());
            if (this.importWizFrame.startImport()) {
                this.importWizFrame.setVisible(true);
                this.mainWizFrame.setVisible(false);
            } else {
                this.importCanceled();
            }
        } else {
            this.importCanceled();
        }
    }

    public void importComplete(OrderedMap om) {
        this.resultsMap = om;
        this.cleanUp();
        this.mainWizFrame.nextAction();
        this.importCompletedOK = true;
    }

    public void importCanceled() {
        this.cleanUp();
        this.importCompletedOK = false;
        this.mainWizFrame.cancelAction();
    }

    private void cleanUp() {
        if (this.importWizFrame != null) {
            this.mainWizFrame.setBounds(this.importWizFrame.getX(), this.importWizFrame.getY(), this.importWizFrame.getWidth(), this.importWizFrame.getHeight());
        }
        this.mainWizFrame.setVisible(true);
        if (this.importWizFrame != null) {
            this.importWizFrame.setVisible(false);
            this.importWizFrame.dispose();
            this.importWizFrame = null;
        }
    }

    public void onRewindAction() {
    }

    public boolean onAdvanceAction() {
        return true;
    }

    public OrderedMap getPageData() {
        return this.resultsMap;
    }

    public OrderedMap getPageData(String rootXPath) {
        throw new UnsupportedOperationException("getPageData(String rootXPath) Method Not Implemented");
    }

    public String getPageID() {
        return "TEXT_IMPORT_WIZARD";
    }

    public String getTitle() {
        return "Data Package Wizard";
    }

    public String getSubtitle() {
        return "Import Data/Information";
    }

    public String getNextPageID() {
        return this.nextPageID;
    }

    public String getPageNumber() {
        return "";
    }

    public boolean setPageData(OrderedMap data, String xPathRoot) {
        return false;
    }
}

