/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class CustomUnitPage
extends AbstractUIPage {
    private final String pageID = "CUSTOM_UNIT_PAGE";
    private final String nextPageID = "";
    private final String pageNumber = "";
    private final String title = "Custom Unit Definition";
    private final String subtitle = "";
    private static final String TOP_LABEL_STRING = "Enter a name and an optional description for your custom unit.";
    private static final String CATEGORY_HEAD_LABEL = "What category does the new unit belong to?";
    private final String[] categoryLabels = new String[]{"One of the existing unit types", "A new custom unit type"};
    private final Color disabledBackgroundColor = new Color(192, 192, 192);
    private JLabel typeNameLabel;
    private JComboBox typeNameComboBox;
    private static final String UNIT_TYPE_LABEL = "Select the unit type that the new unit belongs to";
    private JLabel existingTypeDefnLabel;
    private CustomList existingTypeDefnList;
    private static final String EXISTING_TYPE_DEFN_LABEL = "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Definition for the selected unit category. It is represented as a product of the basic unit types and an exponential (power) factor.<br></font></html>";
    private JLabel newTypeNameLabel;
    private JTextField newTypeNameField;
    private static final String NEW_TYPE_NAME_HEADER_LABEL = "Enter the name of the new unit type";
    private JLabel newTypeDefnLabel;
    private CustomList newTypeDefnList;
    private static final String NEW_TYPE_DEFN_HEADER_LABEL = "Provide a definition for this custom unit, in terms of the basic unit types shown, and an exponential (power) factor";
    private static final String NEW_TYPE_DEFN_EXPL_LABEL = "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\"><font style=\"font-size: 9px;\" color=\"#666666\">e.g:&nbsp; for a unit type like 'velocity', which is given by meterPerSecond, the definition would be - <br>Unit = Length &nbsp;&nbsp;&nbsp; Power = 1 <br>Unit = Time &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Power = -1</font></html>";
    private JLabel unitNameLabel;
    private JTextField unitNameField;
    private static final String UNIT_NAME_LABEL = "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Specify the name of the unit. <font style=\"font-size: 9px;\" color=\"#666666\">e.g:&nbsp; meterPerSecond</font></html>";
    private JLabel unitDescLabel;
    private JTextArea unitDescField;
    private static final String UNIT_DEFN_LABEL = "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Provide a description of the unit. <font style=\"font-size: 9px;\" color=\"#666666\">e.g:&nbsp; SI unit of velocity</font></html>";
    private JLabel existingSIunitNameLabel;
    private JTextField existingSIunitNameField;
    private static final String EXISTING_SI_UNIT_NAME_LABEL = "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">SI unit for the selected unit category. </html>";
    private JLabel newSIunitNameLabel;
    private JComboBox newSIunitNameBox;
    private static final String NEW_SI_UNIT_HEADER_LABEL = "Choose the SI unit for this unit type and optionally define the multiplier to convert the new unit to the chosen SI unit";
    private static final String SI_UNIT_NAME_LABEL = "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Specify the SI unit for this Unit Type. <font style=\"font-size: 9px;\" color=\"#666666\">e.g:&nbsp; meter</font></html>";
    private JLabel existingUnitFactorLabel;
    private JTextField existingUnitFactorField;
    private JLabel newUnitFactorLabel;
    private JTextField newUnitFactorField;
    private static final String UNIT_FACTOR_LABEL = "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\"><font style=\"font-size: 9px;\" color=\"#666666\">e.g:&nbsp; 0.001</font></html>";
    private String[] unitTypes;
    private String[] basicUnitTypes;
    private String currentUnitTypeSelected = "";
    private int currentCategorySelection = -1;
    private JPanel existingTypePanel;
    private JPanel newTypePanel = new JPanel();
    private JPanel categoryRadioPanel;
    private JLabel categoryLabel;
    private JPanel centerPanel = new JPanel();
    private JPanel middleExistingTypePanel;

    public CustomUnitPage() {
        this.init();
    }

    private void init() {
        int i;
        String[] tempUnitTypes = WizardSettings.getUnitDictionaryUnitTypes();
        String[] customTypes = new String[]{};
        AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (adp != null) {
            customTypes = adp.getUnitDictionaryCustomUnitTypes();
        }
        this.basicUnitTypes = WizardSettings.getUnitDictionaryBasicUnitTypes();
        this.createDisplayString(this.basicUnitTypes);
        String[] SIUnits = WizardSettings.getSIUnits();
        ArrayList<String> unitTypeList = new ArrayList<String>();
        unitTypeList.add("");
        for (i = 0; i < tempUnitTypes.length; ++i) {
            unitTypeList.add(WizardSettings.getDisplayFormOfUnitType(tempUnitTypes[i]));
        }
        for (i = 0; i < customTypes.length; ++i) {
            if (unitTypeList.contains(customTypes[i])) continue;
            unitTypeList.add(WizardSettings.getDisplayFormOfUnitType(customTypes[i]));
        }
        this.unitTypes = new String[unitTypeList.size()];
        this.unitTypes = unitTypeList.toArray(this.unitTypes);
        tempUnitTypes = null;
        this.setLayout(new BorderLayout());
        JPanel topPanel = WidgetFactory.makeVerticalPanel(-1);
        this.add((Component)topPanel, "North");
        JLabel topLabel = this.getLabel(TOP_LABEL_STRING, false);
        topPanel.add(topLabel);
        topPanel.add(WidgetFactory.makeDefaultSpacer());
        this.unitNameLabel = WidgetFactory.makeLabel("Unit Name:", true);
        this.unitNameField = WidgetFactory.makeOneLineTextField();
        JPanel unitNamePanel = WidgetFactory.makePanel();
        unitNamePanel.add(this.unitNameLabel);
        JPanel unitNameGrid = new JPanel(new GridLayout(1, 2));
        unitNameGrid.add(this.unitNameField);
        unitNameGrid.add(this.getLabel(UNIT_NAME_LABEL));
        unitNamePanel.add(unitNameGrid);
        topPanel.add(unitNamePanel);
        topPanel.add(WidgetFactory.makeDefaultSpacer());
        this.unitDescLabel = WidgetFactory.makeLabel("Description:", false);
        this.unitDescField = WidgetFactory.makeTextArea("", 3, true);
        JPanel unitDescPanel = WidgetFactory.makePanel();
        unitDescPanel.add(this.unitDescLabel);
        JPanel unitDescGrid = new JPanel(new GridLayout(1, 2));
        unitDescGrid.add(new JScrollPane(this.unitDescField));
        unitDescGrid.add(this.getLabel(UNIT_DEFN_LABEL));
        unitDescPanel.add(unitDescGrid);
        topPanel.add(unitDescPanel);
        topPanel.add(WidgetFactory.makeDefaultSpacer());
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        this.add((Component)this.centerPanel, "Center");
        JPanel categoryPanel = WidgetFactory.makeVerticalPanel(-1);
        this.categoryLabel = this.getLabel(CATEGORY_HEAD_LABEL, true);
        ActionListener categoryListener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (ae.getActionCommand().equals(CustomUnitPage.this.categoryLabels[0])) {
                    if (CustomUnitPage.this.currentCategorySelection == 0) {
                        return;
                    }
                    if (CustomUnitPage.this.currentCategorySelection == 1) {
                        CustomUnitPage.this.centerPanel.remove(CustomUnitPage.this.newTypePanel);
                    }
                    CustomUnitPage.this.centerPanel.add(CustomUnitPage.this.existingTypePanel);
                    CustomUnitPage.this.centerPanel.setMaximumSize(CustomUnitPage.this.centerPanel.getPreferredSize());
                    CustomUnitPage.this.centerPanel.setMinimumSize(CustomUnitPage.this.centerPanel.getPreferredSize());
                    CustomUnitPage.this.currentCategorySelection = 0;
                    CustomUnitPage.this.refreshUI();
                } else {
                    if (CustomUnitPage.this.currentCategorySelection == 1) {
                        return;
                    }
                    if (CustomUnitPage.this.currentCategorySelection == 0) {
                        CustomUnitPage.this.centerPanel.remove(CustomUnitPage.this.existingTypePanel);
                    }
                    CustomUnitPage.this.centerPanel.add(CustomUnitPage.this.newTypePanel);
                    CustomUnitPage.this.centerPanel.setMaximumSize(CustomUnitPage.this.centerPanel.getPreferredSize());
                    CustomUnitPage.this.centerPanel.setMinimumSize(CustomUnitPage.this.centerPanel.getPreferredSize());
                    CustomUnitPage.this.currentCategorySelection = 1;
                    CustomUnitPage.this.refreshUI();
                }
            }
        };
        this.categoryRadioPanel = WidgetFactory.makeRadioPanel(this.categoryLabels, -1, categoryListener);
        categoryPanel.add(this.categoryLabel);
        categoryPanel.add(this.categoryRadioPanel);
        categoryPanel.setMaximumSize(categoryPanel.getPreferredSize());
        categoryPanel.setMinimumSize(categoryPanel.getPreferredSize());
        this.centerPanel.add(categoryPanel);
        this.existingTypePanel = WidgetFactory.makeVerticalPanel(-1);
        JLabel unitTypeLabel = this.getLabel(UNIT_TYPE_LABEL, true);
        this.existingTypePanel.add(WidgetFactory.makeDefaultSpacer());
        this.existingTypePanel.add(unitTypeLabel);
        this.typeNameLabel = WidgetFactory.makeLabel("Unit Type:", true);
        this.typeNameComboBox = new JComboBox<String>(this.unitTypes);
        this.typeNameComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                String selItem = (String)ie.getItem();
                if (CustomUnitPage.this.currentUnitTypeSelected.equals(selItem)) {
                    return;
                }
                if (CustomUnitPage.this.currentUnitTypeSelected.trim().length() == 0) {
                    CustomUnitPage.this.existingTypePanel.add(CustomUnitPage.this.middleExistingTypePanel);
                    CustomUnitPage.this.existingTypePanel.add(Box.createGlue());
                    CustomUnitPage.this.existingTypePanel.setMaximumSize(CustomUnitPage.this.existingTypePanel.getPreferredSize());
                    CustomUnitPage.this.existingTypePanel.setMinimumSize(CustomUnitPage.this.existingTypePanel.getPreferredSize());
                    CustomUnitPage.this.refreshUI();
                } else if (selItem.length() == 0) {
                    CustomUnitPage.this.existingTypePanel.remove(CustomUnitPage.this.middleExistingTypePanel);
                    CustomUnitPage.this.existingTypePanel.setMaximumSize(CustomUnitPage.this.existingTypePanel.getPreferredSize());
                    CustomUnitPage.this.existingTypePanel.setMinimumSize(CustomUnitPage.this.existingTypePanel.getPreferredSize());
                    CustomUnitPage.this.refreshUI();
                }
                if (selItem.length() > 0) {
                    CustomUnitPage.this.existingTypeNameChanged(selItem);
                }
                CustomUnitPage.this.currentUnitTypeSelected = selItem;
            }
        });
        JPanel typeNamePanel = WidgetFactory.makePanel();
        typeNamePanel.add(this.typeNameLabel);
        JPanel typeNameGrid = new JPanel(new GridLayout(1, 2));
        typeNameGrid.add(this.typeNameComboBox);
        typeNameGrid.add(this.getLabel(""));
        typeNamePanel.add(typeNameGrid);
        this.existingTypePanel.add(typeNamePanel);
        this.existingTypePanel.add(WidgetFactory.makeDefaultSpacer());
        this.existingTypePanel.setMaximumSize(this.existingTypePanel.getPreferredSize());
        this.existingTypePanel.setMinimumSize(this.existingTypePanel.getPreferredSize());
        this.middleExistingTypePanel = WidgetFactory.makeVerticalPanel(-1);
        String[] colHeaders = new String[]{"Unit", "Power"};
        double[] colWidths = new double[]{75.0, 25.0};
        Object[] existingColObjects = new Object[2];
        JTextField text1 = new JTextField();
        JTextField text2 = new JTextField();
        text1.setBackground(this.disabledBackgroundColor);
        text2.setBackground(this.disabledBackgroundColor);
        text1.setEditable(false);
        text2.setEditable(false);
        existingColObjects[0] = text1;
        existingColObjects[1] = text2;
        this.existingTypeDefnList = new CustomList(colHeaders, existingColObjects, -1, false, false, false, false, false, false);
        this.existingTypeDefnList.setColumnWidthPercentages(colWidths);
        this.existingTypeDefnList.setListButtonDimensions(WizardSettings.LIST_BUTTON_DIMS_SMALL);
        this.existingTypeDefnList.setEnabled(false);
        this.existingTypeDefnList.setBackground(this.disabledBackgroundColor);
        this.existingTypeDefnList.setMaximumSize(WidgetFactory.getDimForNumberOfLines(4));
        this.existingTypeDefnList.setPreferredSize(WidgetFactory.getDimForNumberOfLines(4));
        JPanel typeDefnPanel = WidgetFactory.makePanel();
        this.existingTypeDefnLabel = WidgetFactory.makeLabel("Unit Type Defintion:", false);
        typeDefnPanel.add(this.existingTypeDefnLabel);
        JPanel typeDefnGrid = new JPanel(new GridLayout(1, 2));
        typeDefnGrid.add(this.existingTypeDefnList);
        typeDefnGrid.add(this.getLabel(EXISTING_TYPE_DEFN_LABEL));
        typeDefnPanel.add(typeDefnGrid);
        this.middleExistingTypePanel.add(typeDefnPanel);
        this.middleExistingTypePanel.add(WidgetFactory.makeDefaultSpacer());
        this.middleExistingTypePanel.add(Box.createGlue());
        JPanel SIunitNamePanel = WidgetFactory.makePanel();
        this.existingSIunitNameLabel = WidgetFactory.makeLabel("SI Unit:", false);
        this.existingSIunitNameField = WidgetFactory.makeOneLineTextField();
        this.existingSIunitNameField.setEditable(false);
        this.existingSIunitNameField.setBackground(this.disabledBackgroundColor);
        SIunitNamePanel.add(this.existingSIunitNameLabel);
        JPanel SIunitNameGrid = new JPanel(new GridLayout(1, 2));
        SIunitNameGrid.add(this.existingSIunitNameField);
        SIunitNameGrid.add(this.getLabel(EXISTING_SI_UNIT_NAME_LABEL));
        SIunitNamePanel.add(SIunitNameGrid);
        this.middleExistingTypePanel.add(SIunitNamePanel);
        this.middleExistingTypePanel.add(WidgetFactory.makeDefaultSpacer());
        this.middleExistingTypePanel.add(Box.createGlue());
        JPanel unitFactorPanel = WidgetFactory.makePanel();
        this.existingUnitFactorLabel = WidgetFactory.makeLabel("Multiplier:", false);
        this.existingUnitFactorField = WidgetFactory.makeOneLineTextField();
        unitFactorPanel.add(this.existingUnitFactorLabel);
        JPanel unitFactorGrid = new JPanel(new GridLayout(1, 2));
        unitFactorGrid.add(this.existingUnitFactorField);
        unitFactorGrid.add(this.getLabel(UNIT_FACTOR_LABEL));
        unitFactorPanel.add(unitFactorGrid);
        this.middleExistingTypePanel.add(unitFactorPanel);
        this.middleExistingTypePanel.add(WidgetFactory.makeDefaultSpacer());
        this.middleExistingTypePanel.add(Box.createGlue());
        this.newTypePanel = WidgetFactory.makeVerticalPanel(-1);
        JLabel newUnitTypeLabel = this.getLabel(NEW_TYPE_NAME_HEADER_LABEL, true);
        this.newTypePanel.add(WidgetFactory.makeDefaultSpacer());
        this.newTypePanel.add(newUnitTypeLabel);
        this.newTypePanel.add(WidgetFactory.makeHalfSpacer());
        this.newTypePanel.add(Box.createGlue());
        this.newTypeNameLabel = WidgetFactory.makeLabel("Unit Type:", true);
        this.newTypeNameField = WidgetFactory.makeOneLineTextField();
        JPanel newTypeNamePanel = WidgetFactory.makePanel();
        newTypeNamePanel.add(this.newTypeNameLabel);
        JPanel newTypeNameGrid = new JPanel(new GridLayout(1, 2));
        newTypeNameGrid.add(this.newTypeNameField);
        newTypeNameGrid.add(this.getLabel(""));
        newTypeNamePanel.add(newTypeNameGrid);
        this.newTypePanel.add(newTypeNamePanel);
        this.newTypePanel.add(WidgetFactory.makeHalfSpacer());
        this.newTypePanel.add(Box.createGlue());
        Object[] newColObjects = new Object[2];
        JComboBox<String> basicTypeCombobox = new JComboBox<String>(this.basicUnitTypes);
        basicTypeCombobox.setEditable(false);
        JTextField jtf = new JTextField("1");
        newColObjects[0] = basicTypeCombobox;
        newColObjects[1] = jtf;
        this.newTypeDefnList = new CustomList(colHeaders, newColObjects, -1, true, false, false, true, false, false);
        this.newTypeDefnList.setColumnWidthPercentages(colWidths);
        this.newTypeDefnList.setListButtonDimensions(WizardSettings.LIST_BUTTON_DIMS_SMALL);
        this.newTypeDefnList.setMaximumSize(WidgetFactory.getDimForNumberOfLines(4));
        this.newTypeDefnList.setPreferredSize(WidgetFactory.getDimForNumberOfLines(4));
        this.newTypeDefnList.fireAddAction();
        JPanel newTypeDefnTopPanel = WidgetFactory.makeVerticalPanel(-1);
        JLabel newUnitDefnTopLabel = this.getLabel(NEW_TYPE_DEFN_HEADER_LABEL, true);
        newTypeDefnTopPanel.add(newUnitDefnTopLabel);
        newTypeDefnTopPanel.add(WidgetFactory.makeHalfSpacer());
        JPanel newTypeDefnPanel = WidgetFactory.makePanel();
        this.newTypeDefnLabel = WidgetFactory.makeLabel("Unit Type Defintion:", true);
        newTypeDefnPanel.add(this.newTypeDefnLabel);
        JPanel newTypeDefnGrid = new JPanel(new GridLayout(1, 2));
        newTypeDefnGrid.add(this.newTypeDefnList);
        newTypeDefnGrid.add(this.getLabel(NEW_TYPE_DEFN_EXPL_LABEL));
        newTypeDefnPanel.add(newTypeDefnGrid);
        newTypeDefnTopPanel.add(newTypeDefnPanel);
        this.newTypePanel.add(newTypeDefnTopPanel);
        this.newTypePanel.add(WidgetFactory.makeHalfSpacer());
        this.newTypePanel.add(Box.createGlue());
        JPanel newSIunitNameTopPanel = WidgetFactory.makeVerticalPanel(-1);
        JLabel newSIUnitNameTopLabel = this.getLabel(NEW_SI_UNIT_HEADER_LABEL, true);
        newSIunitNameTopPanel.add(newSIUnitNameTopLabel);
        newSIunitNameTopPanel.add(WidgetFactory.makeHalfSpacer());
        JPanel newSIunitNamePanel = WidgetFactory.makePanel();
        this.newSIunitNameLabel = WidgetFactory.makeLabel("SI Unit:", true);
        this.newSIunitNameBox = new JComboBox<String>(SIUnits);
        newSIunitNamePanel.add(this.newSIunitNameLabel);
        JPanel newSIunitNameGrid = new JPanel(new GridLayout(1, 2));
        newSIunitNameGrid.add(this.newSIunitNameBox);
        newSIunitNameGrid.add(this.getLabel(EXISTING_SI_UNIT_NAME_LABEL));
        newSIunitNamePanel.add(newSIunitNameGrid);
        newSIunitNameTopPanel.add(newSIunitNamePanel);
        this.newTypePanel.add(newSIunitNameTopPanel);
        this.newTypePanel.add(WidgetFactory.makeHalfSpacer());
        this.newTypePanel.add(Box.createGlue());
        JPanel newUnitFactorPanel = WidgetFactory.makePanel();
        this.newUnitFactorLabel = WidgetFactory.makeLabel("Multiplier:", false);
        this.newUnitFactorField = WidgetFactory.makeOneLineTextField();
        newUnitFactorPanel.add(this.newUnitFactorLabel);
        JPanel newUnitFactorGrid = new JPanel(new GridLayout(1, 2));
        newUnitFactorGrid.add(this.newUnitFactorField);
        newUnitFactorGrid.add(this.getLabel(UNIT_FACTOR_LABEL));
        newUnitFactorPanel.add(newUnitFactorGrid);
        this.newTypePanel.add(newUnitFactorPanel);
        this.newTypePanel.add(WidgetFactory.makeHalfSpacer());
        this.newTypePanel.add(Box.createGlue());
        this.add((Component)this.centerPanel, "Center");
    }

    private void refreshUI() {
        this.centerPanel.validate();
        this.centerPanel.repaint();
    }

    private void existingTypeNameChanged(String selItem) {
        this.setDefnListValue(selItem);
    }

    private void setDefnListValue(String unitType) {
        if (unitType.trim().equals("")) {
            return;
        }
        this.existingTypeDefnList.removeAllRows();
        this.existingSIunitNameField.setText(WizardSettings.getPreferredType(WizardSettings.getStandardFormOfUnitType(unitType)));
        List<String> bTypes = Arrays.asList(this.basicUnitTypes);
        if (bTypes.contains(unitType)) {
            return;
        }
        List<String> types = Arrays.asList(this.unitTypes);
        if (types.contains(unitType)) {
            List defns = WizardSettings.getDefinitionsForUnitType(unitType);
            if (defns == null || defns.size() == 0) {
                Log.debug(12, " Got defn = " + defns);
                return;
            }
            Log.debug(12, " Got defn = " + defns.size());
            for (List row : defns) {
                this.existingTypeDefnList.addRow(row);
            }
        }
        this.existingTypeDefnList.scrollToRow(0);
        this.existingTypeDefnList.setSelectedRows(new int[0]);
    }

    private void createDisplayString(String[] unitTypes) {
        for (int i = 0; i < unitTypes.length; ++i) {
            StringBuffer buff = new StringBuffer(unitTypes[i]);
            buff.setCharAt(0, Character.toUpperCase(buff.charAt(0)));
            unitTypes[i] = buff.toString();
        }
    }

    private JLabel getLabel(String text) {
        if (text == null) {
            text = "";
        }
        JLabel label = new JLabel(text);
        label.setAlignmentX(1.0f);
        label.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        label.setBorder(BorderFactory.createMatteBorder(1, 10, 1, 3, (Color)null));
        return label;
    }

    private JLabel getLabel(String text, boolean hilite) {
        text = "<html><table width=\"100%\"><tr><td valign=\"top\" width=\"100%\"><font style=\"font-size: 9px;\" face=\"Sans-Serif\">" + text + "</font></td></tr></table></html>";
        JLabel label = new JLabel(text);
        label.setAlignmentX(1.0f);
        label.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        Dimension dim = WidgetFactory.getDimForNumberOfLines(1);
        label.setMaximumSize(dim);
        label.setMinimumSize(dim);
        label.setPreferredSize(dim);
        label.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 1, (Color)null));
        if (hilite) {
            label.setForeground(WizardSettings.WIZARD_CONTENT_REQD_TEXT_COLOR);
        } else {
            label.setForeground(WizardSettings.WIZARD_CONTENT_TEXT_COLOR);
        }
        return label;
    }

    public void onRewindAction() {
    }

    public void onLoadAction() {
    }

    public String getPageID() {
        return this.pageID;
    }

    public String getTitle() {
        return "Custom Unit Definition";
    }

    public String getSubtitle() {
        return "";
    }

    public String getNextPageID() {
        this.getClass();
        return "";
    }

    public String getPageNumber() {
        return "";
    }

    private int getSelectedRadioIndex(JPanel radioPanel) {
        Container c = (Container)radioPanel.getComponent(1);
        int cnt = c.getComponentCount();
        for (int i = 0; i < cnt; ++i) {
            JRadioButton jrb = (JRadioButton)c.getComponent(i);
            if (!jrb.isSelected()) continue;
            return i;
        }
        return -1;
    }

    public boolean onAdvanceAction() {
        String unitName = this.unitNameField.getText();
        if (unitName.trim().equals("")) {
            WidgetFactory.hiliteComponent(this.unitNameLabel);
            this.unitNameField.requestFocus();
            return false;
        }
        WidgetFactory.unhiliteComponent(this.unitNameLabel);
        int category = this.getSelectedRadioIndex(this.categoryRadioPanel);
        if (category == -1) {
            WidgetFactory.hiliteComponent(this.categoryLabel);
            return false;
        }
        WidgetFactory.unhiliteComponent(this.categoryLabel);
        if (category == 0) {
            String type = (String)this.typeNameComboBox.getSelectedItem();
            if (type.trim().equals("")) {
                WidgetFactory.hiliteComponent(this.typeNameLabel);
                return false;
            }
            WidgetFactory.unhiliteComponent(this.typeNameLabel);
            return true;
        }
        String unitType = this.newTypeNameField.getText();
        if (unitType.trim().equals("")) {
            WidgetFactory.hiliteComponent(this.newTypeNameLabel);
            this.newTypeNameField.requestFocus();
            return false;
        }
        WidgetFactory.unhiliteComponent(this.newTypeNameLabel);
        List rows = this.newTypeDefnList.getListOfRowLists();
        if (rows == null || rows.size() == 0) {
            WidgetFactory.hiliteComponent(this.newTypeDefnLabel);
            return false;
        }
        int cnt = -1;
        Iterator it = rows.iterator();
        while (it.hasNext()) {
            ++cnt;
            List row = (List)it.next();
            String power = (String)row.get(1);
            try {
                Double.parseDouble(power);
            }
            catch (Exception e) {
                if (power.trim().length() > 0) {
                    JOptionPane.showMessageDialog(this, "Power of a unit in the definition list has to be a number", "Error", 0);
                }
                WidgetFactory.hiliteComponent(this.newTypeDefnLabel);
                this.newTypeDefnList.editCellAt(cnt, 1);
                return false;
            }
        }
        WidgetFactory.unhiliteComponent(this.newTypeDefnLabel);
        return true;
    }

    public OrderedMap getPageData() {
        throw new UnsupportedOperationException("getPageData(String rootXPath) Method Not Implemented in Custom Unit Page");
    }

    public OrderedMap getPageData(String xPathRoot) {
        OrderedMap map = new OrderedMap();
        String unit = this.unitNameField.getText();
        String desc = this.unitDescField.getText();
        if (desc.trim().equals("")) {
            desc = unit;
        }
        xPathRoot = xPathRoot + "/unitList";
        int category = this.getSelectedRadioIndex(this.categoryRadioPanel);
        if (category == 0) {
            map.put((Object)(xPathRoot + "/unit[1]/@id"), (Object)unit);
            map.put((Object)(xPathRoot + "/unit[1]/@name"), (Object)unit);
            map.put((Object)(xPathRoot + "/unit[1]/description"), (Object)desc);
            String type = (String)this.typeNameComboBox.getSelectedItem();
            type = WizardSettings.getStandardFormOfUnitType(type);
            String multiplier = this.existingUnitFactorField.getText();
            String SIUnit = this.existingSIunitNameField.getText();
            if (multiplier.trim().equals("")) {
                multiplier = "";
            }
            map.put((Object)(xPathRoot + "/unit[1]/@unitType"), (Object)type);
            map.put((Object)(xPathRoot + "/unit[1]/@parentSI"), (Object)SIUnit);
            map.put((Object)(xPathRoot + "/unit[1]/@multiplierToSI"), (Object)multiplier);
        } else {
            String type = this.newTypeNameField.getText();
            type = WizardSettings.getStandardFormOfUnitType(type);
            map.put((Object)(xPathRoot + "/unitType[1]/@id"), (Object)type);
            map.put((Object)(xPathRoot + "/unitType[1]/@name"), (Object)type);
            List defns = this.newTypeDefnList.getListOfRowLists();
            Iterator it = defns.iterator();
            int cnt = 1;
            while (it.hasNext()) {
                List row = (List)it.next();
                String name = (String)row.get(0);
                String power = (String)row.get(1);
                map.put((Object)(xPathRoot + "/unitType[1]/dimension[" + cnt + "]/@name"), (Object)name);
                if (!power.equals("1")) {
                    map.put((Object)(xPathRoot + "/unitType[1]/dimension[" + cnt + "]/@power"), (Object)power);
                }
                ++cnt;
            }
            map.put((Object)(xPathRoot + "/unit[1]/@id"), (Object)unit);
            map.put((Object)(xPathRoot + "/unit[1]/@name"), (Object)unit);
            map.put((Object)(xPathRoot + "/unit[1]/description"), (Object)desc);
            String multiplier = this.newUnitFactorField.getText();
            String SIUnit = (String)this.newSIunitNameBox.getSelectedItem();
            if (multiplier.trim().equals("")) {
                multiplier = "";
            }
            map.put((Object)(xPathRoot + "/unit[1]/@unitType"), (Object)type);
            map.put((Object)(xPathRoot + "/unit[1]/@parentSI"), (Object)SIUnit);
            map.put((Object)(xPathRoot + "/unit[1]/@multiplierToSI"), (Object)multiplier);
        }
        return map;
    }

    public boolean setPageData(OrderedMap data, String rootXPath) {
        return true;
    }
}

