/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.framework;

import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.SwingWorker;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.UISettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.URL;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HTMLBrowser {
    private static final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    private static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    private static final Cursor handCursor = Cursor.getPredefinedCursor(12);
    private boolean loadingPage = false;
    private Stack pageList;
    private MorphoFrame frame;
    private JToolBar toolBar;
    private JEditorPane HTMLPane = new JEditorPane();
    private Action backAction;
    private JTextField urlTextField = new JTextField();
    private Action loadAction;

    public HTMLBrowser() {
        this(UIController.getInstance().addWindow("Browser"), true);
    }

    public HTMLBrowser(String sTitle) {
        this(UIController.getInstance().addWindow(sTitle), true);
        this.frame.setTitle(sTitle);
    }

    public HTMLBrowser(MorphoFrame frame, boolean showLocationBar) {
        this.frame = frame;
        JPanel mainPanel = new JPanel();
        JScrollPane JScrollPane1 = new JScrollPane();
        frame.setTitle("");
        mainPanel.setLayout(new BorderLayout(0, 0));
        frame.setMainContentPane(mainPanel);
        JScrollPane1.setOpaque(true);
        JScrollPane1.getViewport().setBackground(Color.white);
        JScrollPane1.getViewport().add(this.HTMLPane);
        mainPanel.add("Center", JScrollPane1);
        this.HTMLPane.setEditable(false);
        this.toolBar = frame.getJToolBar();
        this.toolBar.removeAll();
        this.backAction = new GUIAction("  < Back  ", null, new Command(){

            public void execute(ActionEvent e) {
                if (HTMLBrowser.this.pageList.size() < 2) {
                    return;
                }
                HTMLBrowser.this.pageList.pop();
                Object url = HTMLBrowser.this.pageList.pop();
                HTMLBrowser.this.loadNewPage(url);
            }
        });
        this.loadAction = new GUIAction("  Go  ", null, new Command(){

            public void execute(ActionEvent e) {
                String url = HTMLBrowser.this.urlTextField.getText();
                HTMLBrowser.this.pageList.push(url);
                try {
                    HTMLBrowser.this.loadNewPage(url);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Log.debug(1, "Cannot open page: " + url);
                }
            }
        });
        this.backAction.setEnabled(false);
        this.toolBar.add(this.backAction);
        if (showLocationBar) {
            this.toolBar.addSeparator();
            this.toolBar.add(this.urlTextField);
            this.toolBar.addSeparator();
            this.toolBar.add(this.loadAction);
            this.urlTextField.setText("");
            this.setTextFieldDims();
            this.urlTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HTMLBrowser.this.loadAction.actionPerformed(e);
                }
            });
        }
        this.pageList = new Stack();
        this.HTMLPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (HTMLBrowser.this.loadingPage) {
                    return;
                }
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JEditorPane sp = (JEditorPane)evt.getSource();
                    if (evt instanceof HTMLFrameHyperlinkEvent) {
                        HTMLDocument doc = (HTMLDocument)sp.getDocument();
                        doc.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)evt);
                    } else {
                        HTMLBrowser.this.loadNewPage(evt.getURL());
                    }
                } else if (evt.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    HTMLBrowser.this.HTMLPane.setCursor(handCursor);
                } else if (evt.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    HTMLBrowser.this.HTMLPane.setCursor(defaultCursor);
                }
            }
        });
        this.enableActions();
        frame.setSize((int)UISettings.DEFAULT_WINDOW_WIDTH, (int)UISettings.DEFAULT_WINDOW_HEIGHT);
        if (showLocationBar) {
            frame.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    HTMLBrowser.this.setTextFieldDims();
                }
            });
        }
    }

    private void enableActions() {
        this.backAction.setEnabled(this.pageList.size() > 1);
    }

    private void setTextFieldDims() {
        Dimension toolBarDims = this.frame.getJToolBarDims();
        int toolBarWidth = toolBarDims.width;
        int toolBarHeight = toolBarDims.height;
        int backButtonWidth = this.toolBar.getComponent(0).getWidth();
        int dividerWidth = this.toolBar.getComponent(1).getWidth();
        int goButtonWidth = this.toolBar.getComponent(4).getWidth();
        int textFieldWidth = toolBarWidth - backButtonWidth - 2 * dividerWidth - goButtonWidth - 10;
        Dimension textFieldDims = new Dimension(textFieldWidth, toolBarHeight);
        this.urlTextField.setPreferredSize(textFieldDims);
        this.urlTextField.setMaximumSize(textFieldDims);
        this.urlTextField.invalidate();
        this.frame.validate();
        this.frame.repaint();
    }

    public void loadNewPage(final Object page) {
        final MorphoFrame finalFrame = this.frame;
        SwingWorker worker = new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                finalFrame.setBusy(true);
                finalFrame.setEnabled(false);
                HTMLBrowser.this.HTMLPane.setCursor(waitCursor);
                URL url = null;
                try {
                    url = page instanceof URL ? (URL)page : new URL((String)page);
                    if (url == null) {
                        throw new IllegalArgumentException("URL IS NULL!");
                    }
                    HTMLBrowser.this.pageList.push(url);
                    HTMLBrowser.this.HTMLPane.setPage(url);
                    HTMLBrowser.this.urlTextField.setText(url.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.debug(1, "Cannot open page: " + url);
                }
                finally {
                    HTMLBrowser.this.HTMLPane.setCursor(defaultCursor);
                    HTMLBrowser.this.enableActions();
                    this.finished();
                }
                return null;
            }

            public void finished() {
                finalFrame.setBusy(false);
                finalFrame.setEnabled(true);
                UIController.getInstance().setCurrentActiveWindow(finalFrame);
                finalFrame.toFront();
            }
        };
        worker.start();
    }

    public void setVisible(boolean visible) {
        this.frame.setVisible(visible);
    }

    public static void main(String[] args) {
        try {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            new HTMLBrowser().setVisible(true);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

