/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.framework;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;

public class FileUtils {
    public static final String DELIMITER = "@";

    public static void copy(File inputFile, File outputFile) throws IOException {
        int len;
        FileReader in = new FileReader(inputFile);
        FileWriter out = new FileWriter(outputFile);
        char[] buffer = new char[512];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static void copy(String src, String dest) throws IOException {
        File inputFile = new File(src);
        File outputFile = new File(dest);
        FileUtils.copy(inputFile, outputFile);
    }

    public static void copy(File inputFile, File outputFile, Hashtable tokens) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(inputFile));
        BufferedWriter out = new BufferedWriter(new FileWriter(outputFile));
        String newline = null;
        String line = in.readLine();
        while (line != null) {
            if (line.length() != 0) {
                newline = FileUtils.replace(line, tokens);
                out.write(newline);
            }
            out.newLine();
            line = in.readLine();
        }
        out.close();
        in.close();
    }

    public static void copy(String src, String dest, Hashtable tokens) throws IOException {
        File inputFile = new File(src);
        File outputFile = new File(dest);
        FileUtils.copy(inputFile, outputFile, tokens);
    }

    private static String replace(String line, Hashtable tokenList) {
        int tokenBegPos = line.indexOf(DELIMITER);
        if (tokenBegPos > -1) {
            try {
                int tokenEndPos;
                String token = null;
                String value = null;
                StringBuffer newLine = new StringBuffer();
                int pos = 0;
                while ((tokenBegPos = line.indexOf(DELIMITER, pos)) > -1 && (tokenEndPos = line.indexOf(DELIMITER, tokenBegPos + DELIMITER.length() + 1)) != -1) {
                    token = line.substring(tokenBegPos + DELIMITER.length(), tokenEndPos);
                    newLine.append(line.substring(pos, tokenBegPos));
                    if (tokenList.containsKey(token)) {
                        value = (String)tokenList.get(token);
                        newLine.append(value);
                        pos = tokenBegPos + DELIMITER.length() + token.length() + DELIMITER.length();
                        continue;
                    }
                    newLine.append(DELIMITER);
                    pos = tokenBegPos + DELIMITER.length();
                }
                newLine.append(line.substring(pos));
                return newLine.toString();
            }
            catch (StringIndexOutOfBoundsException sioobe) {
                return line;
            }
        }
        return line;
    }
}

