/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.editor;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.editor.DocFrame;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.EditingCompleteListener;
import edu.ucsb.nceas.morpho.framework.EditorInterface;
import edu.ucsb.nceas.morpho.plugins.PluginInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceExistsException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;

public class EditorPlugin
implements PluginInterface,
ServiceProvider,
EditorInterface {
    protected Morpho morpho = null;
    protected ConfigXML config = null;
    protected Vector editingCompleteRegistry = null;
    protected Hashtable docframes = new Hashtable();
    protected String id = null;
    protected String location = null;
    protected Object clipboardObject = null;

    public EditorPlugin() {
        this.initializeActions();
    }

    public void initialize(Morpho morpho) {
        this.morpho = morpho;
        this.config = morpho.getConfiguration();
        this.loadConfigurationParameters();
        this.editingCompleteRegistry = new Vector();
        try {
            ServiceController services = ServiceController.getInstance();
            services.addService(EditorInterface.class, this);
            Log.debug(20, "Service added: EditorInterface.");
        }
        catch (ServiceExistsException see) {
            Log.debug(6, "Service registration failed: EditorInterface.");
            Log.debug(6, see.toString());
        }
    }

    private void initializeActions() {
        AbstractAction openItemAction = new AbstractAction("Open Editor"){

            public void actionPerformed(ActionEvent e) {
            }
        };
        openItemAction.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Edit16.gif")));
        openItemAction.putValue("ShortDescription", "Open Editor");
        openItemAction.putValue("menuPosition", new Integer(0));
    }

    private void loadConfigurationParameters() {
    }

    public void fireEditingCompleteEvent(DocFrame doc, String xmlString) {
        if (this.docframes.containsKey(doc)) {
            this.location = doc.getLocationString();
            this.id = doc.getIdString();
            EditingCompleteListener list = (EditingCompleteListener)this.docframes.get(doc);
            this.docframes.remove(doc);
            list.editingCompleted(xmlString, this.id, this.location);
        }
    }

    public void fireEditingCanceledEvent(DocFrame doc, String xmlString) {
        if (this.docframes.containsKey(doc)) {
            this.location = doc.getLocationString();
            this.id = doc.getIdString();
            EditingCompleteListener list = (EditingCompleteListener)this.docframes.get(doc);
            this.docframes.remove(doc);
            list.editingCanceled(xmlString, this.id, this.location);
        }
    }

    public void openEditor(String xmlText) {
        DocFrame editorframe = new DocFrame(this.morpho, "Working...", xmlText, false);
        editorframe.setController(this);
        editorframe.initDoc(this.morpho, xmlText);
    }

    public void openEditor(String xmlText, String id, String location, EditingCompleteListener listener) {
        DocFrame editorframe = new DocFrame(this.morpho, "Working...", xmlText, id, location);
        editorframe.setController(this);
        editorframe.initDoc(this.morpho, xmlText);
        this.id = id;
        this.location = location;
        this.docframes.put(editorframe, listener);
    }

    public void openEditor(Document doc, String id, String location, EditingCompleteListener listener, String nodeName, int cnt) {
        DocFrame editorframe = new DocFrame();
        editorframe.setController(this);
        editorframe.setVisible(true);
        editorframe.initDoc(this.morpho, doc, id, location, nodeName, cnt);
        this.id = id;
        this.location = location;
        this.docframes.put(editorframe, listener);
    }

    public void openEditor(String xmlText, String id, String location, EditingCompleteListener listener, boolean template) {
        DocFrame editorframe = new DocFrame(this.morpho, "Working...", xmlText, id, location, template);
        editorframe.setController(this);
        editorframe.initDoc(this.morpho, xmlText);
        this.id = id;
        this.location = location;
        this.docframes.put(editorframe, listener);
    }

    public void openEditor(String xmlText, EditingCompleteListener listener) {
        this.openEditor(xmlText, null, null, listener);
    }

    public void openEditor(String xmlText, String id, String location, String nodeName, String nodeValue, EditingCompleteListener listener) {
        DocFrame editorframe = new DocFrame(this.morpho, "Working...", xmlText, id, location, nodeName, nodeValue);
        editorframe.setController(this);
        editorframe.initDoc(this.morpho, xmlText);
        this.id = id;
        this.location = location;
        this.docframes.put(editorframe, listener);
    }

    public Object getClipboardObject() {
        return this.clipboardObject;
    }

    public void setClipboardObject(Object node) {
        this.clipboardObject = node;
    }
}

