/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.editor;

import edu.ucsb.nceas.morpho.editor.NodeInfo;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMTree
extends JTree {
    public DOMTree() {
        this((Document)null);
    }

    public DOMTree(Document document) {
        super(new Model());
        this.setRootVisible(false);
        this.setDocument(document);
    }

    public void setDocument(Document document) {
        ((Model)this.getModel()).setDocument(document);
        this.expandRow(0);
    }

    public Document getDocument() {
        return ((Model)this.getModel()).getDocument();
    }

    public Node getNode(Object treeNode) {
        return ((Model)this.getModel()).getNode(treeNode);
    }

    static class Model
    extends DefaultTreeModel
    implements Serializable {
        private Document document;
        private Hashtable nodeMap = new Hashtable();
        private Hashtable invNodeMap = new Hashtable();

        public Model() {
            this((Document)null);
        }

        public Model(Document document) {
            super(new DefaultMutableTreeNode(new NodeInfo("")));
            this.setDocument(document);
        }

        public synchronized void setDocument(Document document) {
            this.document = document;
            ((DefaultMutableTreeNode)this.getRoot()).removeAllChildren();
            this.nodeMap.clear();
            this.invNodeMap.clear();
            this.buildTree();
            this.fireTreeStructureChanged(this, new Object[]{this.getRoot()}, new int[0], new Object[0]);
        }

        public Document getDocument() {
            return this.document;
        }

        public Node getNode(Object treeNode) {
            return (Node)this.nodeMap.get(treeNode);
        }

        public Object getInvNode(Node node) {
            return this.invNodeMap.get(node);
        }

        private void buildTree() {
            if (this.document == null) {
                return;
            }
            Element rnode = this.document.getDocumentElement();
            NodeList nodes = rnode.getChildNodes();
            int len = nodes != null ? nodes.getLength() : 0;
            MutableTreeNode root = (MutableTreeNode)this.getRoot();
            MutableTreeNode rt = this.buildRootNode(rnode, root);
            this.setRoot(rt);
            block4: for (int i = 0; i < len; ++i) {
                Node node = nodes.item(i);
                switch (node.getNodeType()) {
                    case 9: {
                        root = this.insertDocumentNode(node, rt);
                        continue block4;
                    }
                    case 1: {
                        this.insertElementNode(node, rt);
                        continue block4;
                    }
                }
            }
        }

        private MutableTreeNode insertNode(String what, MutableTreeNode where, Hashtable ht) {
            NodeInfo ni = new NodeInfo(what);
            if (ht != null) {
                ni.attr = ht;
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(ni);
            this.insertNodeInto(node, where, where.getChildCount());
            return node;
        }

        private MutableTreeNode insertTNode(String what, MutableTreeNode where) {
            NodeInfo ni = new NodeInfo("#PCDATA");
            ni.setPCValue(what);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(ni);
            this.insertNodeInto(node, where, where.getChildCount());
            return node;
        }

        private MutableTreeNode insertDocumentNode(Node what, MutableTreeNode where) {
            MutableTreeNode treeNode = this.insertNode("<" + what.getNodeName() + '>', where, null);
            this.nodeMap.put(treeNode, what);
            this.invNodeMap.put(what, treeNode);
            return treeNode;
        }

        private MutableTreeNode insertElementNode(Node what, MutableTreeNode where) {
            StringBuffer name = new StringBuffer();
            name.append(what.getNodeName());
            NamedNodeMap attrs = what.getAttributes();
            Hashtable<String, String> ht = new Hashtable<String, String>();
            int attrCount = attrs != null ? attrs.getLength() : 0;
            for (int i = 0; i < attrCount; ++i) {
                Node attr = attrs.item(i);
                ht.put(attr.getNodeName(), attr.getNodeValue());
            }
            MutableTreeNode element = this.insertNode(name.toString(), where, ht);
            this.nodeMap.put(element, what);
            this.invNodeMap.put(what, element);
            NodeList children = what.getChildNodes();
            int len = children != null ? children.getLength() : 0;
            block6: for (int i = 0; i < len; ++i) {
                Node node = children.item(i);
                switch (node.getNodeType()) {
                    case 4: {
                        this.insertCDataSectionNode(node, element);
                        continue block6;
                    }
                    case 3: {
                        this.insertTextNode(node, element);
                        continue block6;
                    }
                    case 1: {
                        this.insertElementNode(node, element);
                    }
                }
            }
            return element;
        }

        private MutableTreeNode buildRootNode(Node what, MutableTreeNode where) {
            StringBuffer name = new StringBuffer();
            name.append(what.getLocalName());
            NamedNodeMap attrs = what.getAttributes();
            Hashtable<String, String> ht = new Hashtable<String, String>();
            int attrCount = attrs != null ? attrs.getLength() : 0;
            for (int i = 0; i < attrCount; ++i) {
                Node attr = attrs.item(i);
                ht.put(attr.getNodeName(), attr.getNodeValue());
            }
            this.nodeMap.put(where, what);
            this.invNodeMap.put(what, where);
            NodeInfo ni = new NodeInfo(name.toString());
            if (ht != null) {
                ni.attr = ht;
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(ni);
            return node;
        }

        private MutableTreeNode insertTextNode(Node what, MutableTreeNode where) {
            String value = what.getNodeValue().trim();
            if (value.length() > 0) {
                MutableTreeNode treeNode = this.insertTNode(value, where);
                this.nodeMap.put(treeNode, what);
                this.invNodeMap.put(what, treeNode);
                return treeNode;
            }
            return null;
        }

        private MutableTreeNode insertCDataSectionNode(Node what, MutableTreeNode where) {
            StringBuffer CSectionBfr = new StringBuffer();
            CSectionBfr.append(what.getNodeValue());
            if (CSectionBfr.length() > 0) {
                MutableTreeNode treeNode = this.insertNode(CSectionBfr.toString(), where, null);
                this.nodeMap.put(treeNode, what);
                this.invNodeMap.put(what, treeNode);
                return treeNode;
            }
            return null;
        }
    }
}

