/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.DisplayFrame;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.DocumentNotFoundException;
import edu.ucsb.nceas.morpho.util.IOUtil;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.XMLTransformer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JFrame;
import org.w3c.dom.Document;

public class ViewDocumentationCommand
implements Command {
    private ConfigXML config = Morpho.getConfiguration();
    private final String CONFIG_KEY_CSS_LOCATION = "emlCSSLocation";
    private final String CONFIG_KEY_MCONFJAR_LOC = "morphoConfigJarLocation";

    public void execute(ActionEvent ae) {
        AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (adp == null) {
            Log.debug(16, " Abstract Data Package is null in View Documentation");
            return;
        }
        XMLTransformer transformer = XMLTransformer.getInstance();
        transformer.addTransformerProperty("displaymodule", "printall");
        transformer.addTransformerProperty("stylePath", this.getFullStylePath());
        Reader xmlReader = null;
        Reader resultReader = null;
        String htmlDoc = "<html><head><h2>Error displaying the requested Document</h2></head></html>";
        String ID = "";
        try {
            ID = adp.getPackageId();
            if (ID == null || ID.equals("")) {
                ID = "tempid";
            }
            resultReader = null;
            Document doc = adp.openAsDom(ID);
            if (doc == null) {
                xmlReader = adp.openAsReader(ID);
                resultReader = transformer.transform(xmlReader);
            } else {
                resultReader = transformer.transform(doc);
            }
            StringBuffer sb = IOUtil.getAsStringBuffer(resultReader, true);
            htmlDoc = sb.toString();
        }
        catch (DocumentNotFoundException dnfe) {
            Log.debug(12, "DocumentNotFoundException getting Reader for ID: " + ID + "; " + dnfe.getMessage());
        }
        catch (IOException io) {
            Log.debug(12, "IOException while getting the string for ID:" + ID + "; " + io);
        }
        catch (Exception e) {
            Log.debug(12, "Exception during Transformation in ViewDocumentationCommand - " + e);
        }
        htmlDoc = this.processHTMLString(htmlDoc);
        MorphoFrame parent = UIController.getInstance().getCurrentActiveWindow();
        DisplayFrame frame = new DisplayFrame(htmlDoc, "text/html", new Dimension(770, 570));
        this.resetBounds(frame, parent);
    }

    private static String stripHTMLMetaTags(String html) {
        boolean META_END = false;
        int META_START = html.indexOf("<META");
        if (META_START >= 0) {
            char[] htmlChars = html.toCharArray();
            int charIndex = META_START;
            int nextChar = 32;
            do {
                nextChar = htmlChars[charIndex];
                htmlChars[charIndex] = 32;
            } while (nextChar != 62 && ++charIndex < htmlChars.length);
            html = String.valueOf(htmlChars);
            return ViewDocumentationCommand.stripHTMLMetaTags(html);
        }
        return html;
    }

    private static String stripComments(String html) {
        int prev = 0;
        String res = "";
        int pos = html.indexOf("<!--");
        if (pos < 0) {
            return html;
        }
        while (pos >= 0) {
            res = res + html.substring(prev, pos);
            html = html.substring(pos);
            int next = html.indexOf("-->");
            prev = 0;
            html = html.substring(next + 3);
            pos = html.indexOf("<!--");
        }
        res = res + html;
        return res;
    }

    private String addTitleTag(String html) {
        int pos = html.indexOf("<title>");
        if (pos != -1) {
            return html;
        }
        pos = html.indexOf("</head>");
        String init = "";
        if (pos != -1) {
            init = html.substring(0, pos);
            init = init + "<title></title>";
            init = init + html.substring(pos);
        } else {
            pos = html.indexOf("<body>");
            init = html.substring(0, pos);
            init = init + "<head><title></title></head>";
            init = init + html.substring(pos);
        }
        return init;
    }

    private String processHTMLString(String displayString) {
        displayString = ViewDocumentationCommand.stripHTMLMetaTags(displayString);
        displayString = ViewDocumentationCommand.stripComments(displayString);
        displayString = this.addTitleTag(displayString);
        return displayString;
    }

    private void resetBounds(JFrame frame, JFrame parent) {
        int xcoord;
        int ycoord;
        if (parent == null) {
            ycoord = 50;
            xcoord = 50;
        } else {
            xcoord = parent.getX() + parent.getWidth() / 2 - frame.getWidth() / 2;
            ycoord = parent.getY() + parent.getHeight() / 2 - frame.getHeight() / 2;
        }
        frame.setBounds(xcoord, ycoord, frame.getWidth(), frame.getHeight());
    }

    private String getFullStylePath() {
        StringBuffer pathBuff = new StringBuffer();
        pathBuff.append("jar:file:");
        pathBuff.append(new File("").getAbsolutePath());
        pathBuff.append("/");
        pathBuff.append(this.config.get("morphoConfigJarLocation", 0));
        pathBuff.append("!/");
        pathBuff.append(this.config.get("emlCSSLocation", 0));
        Log.debug(50, "ViewDocumentationCommand.getFullStylePath() returning: " + pathBuff.toString());
        return pathBuff.toString();
    }
}

