/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import com.arbortext.catalog.CatalogEntityResolver;
import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.PackageUtil;
import edu.ucsb.nceas.morpho.datapackage.Triple;
import edu.ucsb.nceas.morpho.datapackage.TripleParser;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.util.Log;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TripleCollection {
    private Vector triples = new Vector();
    private Morpho morpho = null;

    public TripleCollection() {
    }

    public TripleCollection(File triplesFile, Morpho morpho) {
        Document doc;
        this.morpho = morpho;
        try {
            ConfigXML config = morpho.getConfiguration();
            String catalogPath = config.get("local_catalog_path", 0);
            doc = PackageUtil.getDoc(triplesFile, catalogPath);
        }
        catch (Exception e) {
            Log.debug(0, "error parsing " + triplesFile.getPath() + " : " + e.getMessage());
            e.printStackTrace();
            return;
        }
        String triplePath = "//triple";
        NodeList tripleList = null;
        try {
            tripleList = XPathAPI.selectNodeList((Node)doc, (String)triplePath);
        }
        catch (Exception e) {
            Log.debug(0, "Error parsing triples in TripleCollection.TripleCollection: " + e.getMessage());
            e.printStackTrace();
        }
        for (int i = 0; i < tripleList.getLength(); ++i) {
            Node triple = tripleList.item(i);
            NodeList children = triple.getChildNodes();
            String sub = null;
            String rel = null;
            String obj = null;
            if (children.getLength() <= 2) continue;
            for (int j = 0; j < children.getLength(); ++j) {
                Node childNode = children.item(j);
                String nodename = childNode.getNodeName().trim().toUpperCase();
                if (nodename.equals("SUBJECT")) {
                    sub = childNode.getFirstChild().getNodeValue();
                    continue;
                }
                if (nodename.equals("OBJECT")) {
                    obj = childNode.getFirstChild().getNodeValue();
                    continue;
                }
                if (!nodename.equals("RELATIONSHIP")) continue;
                rel = childNode.getFirstChild().getNodeValue();
            }
            Triple t = new Triple(sub, rel, obj);
            this.triples.addElement(t);
        }
    }

    public TripleCollection(TripleCollection tc) {
        this.triples = tc.getCollection();
    }

    public TripleCollection(Reader xml) {
        TripleParser tp = new TripleParser(xml);
        this.triples = tp.getTriples().getCollection();
    }

    public TripleCollection(Reader xml, CatalogEntityResolver cer) {
        TripleParser tp = new TripleParser(xml, cer);
        this.triples = tp.getTriples().getCollection();
    }

    public TripleCollection(Vector triples) {
        this.triples = (Vector)triples.clone();
    }

    public void addTriple(Triple triple) {
        this.triples.addElement(triple);
    }

    public boolean containsTriple(Triple triple) {
        return this.triples.removeElement(triple);
    }

    public Triple removeTriple(Triple triple) {
        boolean removed = this.triples.removeElement(triple);
        if (removed) {
            return triple;
        }
        return null;
    }

    public Vector getCollectionBySubject(String subject) {
        Vector<Triple> trips = new Vector<Triple>();
        for (int i = 0; i < this.triples.size(); ++i) {
            Triple trip = new Triple((Triple)this.triples.elementAt(i));
            if (!trip.getSubject().equals(subject)) continue;
            trips.addElement(trip);
        }
        return trips;
    }

    public Vector getCollectionByRelationship(String relationship) {
        Vector<Triple> trips = new Vector<Triple>();
        for (int i = 0; i < this.triples.size(); ++i) {
            Triple trip = new Triple((Triple)this.triples.elementAt(i));
            if (!trip.getRelationship().equals(relationship)) continue;
            trips.addElement(trip);
        }
        return trips;
    }

    public Vector getCollectionByObject(String object) {
        Vector<Triple> trips = new Vector<Triple>();
        for (int i = 0; i < this.triples.size(); ++i) {
            Triple trip = new Triple((Triple)this.triples.elementAt(i));
            if (!trip.getObject().equals(object)) continue;
            trips.addElement(trip);
        }
        return trips;
    }

    public Vector getCollection() {
        return this.triples;
    }

    public String toXML() {
        return this.toXML(null);
    }

    public String toXML(String root) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"?>");
        if (root != null) {
            sb.append("<" + root + ">");
        }
        for (int i = 0; i < this.triples.size(); ++i) {
            sb.append(((Triple)this.triples.elementAt(i)).toXML());
        }
        if (root != null) {
            sb.append("</" + root + ">");
        }
        return sb.toString();
    }

    public NodeList getNodeList() {
        DocumentBuilder parser = Morpho.createDomParser();
        InputSource in = new InputSource(new StringReader(this.toXML("triples")));
        Document doc = null;
        try {
            doc = parser.parse(in);
        }
        catch (Exception e1) {
            System.err.println("triples: parse threw: " + e1.toString());
        }
        return doc.getElementsByTagName("triple");
    }

    public String toFormatedXML() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.triples.size(); ++i) {
            sb.append(((Triple)this.triples.elementAt(i)).toFormatedXML());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < this.triples.size(); ++i) {
            Triple t = new Triple((Triple)this.triples.elementAt(i));
            sb.append(t.toString());
            if (i == this.triples.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("usage: TripleCollection <xml_file>");
            return;
        }
        String filename = args[0];
        try {
            FileReader xml = new FileReader(new File(filename));
            TripleCollection tc = new TripleCollection(xml);
            System.out.println("Triples are:");
            System.out.println(tc.toString());
            Vector v = tc.getCollectionBySubject("1.s");
            System.out.println(v.toString());
            v = tc.getCollectionByObject("2.o");
            System.out.println(v.toString());
            v = tc.getCollectionByRelationship("1.r");
            System.out.println(v.toString());
            Triple t = new Triple("3.s", "3.r", "3.o");
            tc.addTriple(t);
            System.out.println(tc.toString());
            Triple u = tc.removeTriple(t);
            System.out.println(u.toString());
            System.out.println(tc.toString());
            Triple x = new Triple();
            u = tc.removeTriple(x);
            if (u != null) {
                System.out.println(u.toString());
            } else {
                System.out.println("u == null");
            }
            System.out.println(tc.toString());
            tc.addTriple(t);
            if (tc.containsTriple(t)) {
                System.out.println("it's there");
            } else {
                System.out.println("it's not");
            }
            tc.removeTriple(t);
            if (tc.containsTriple(t)) {
                System.out.println("it's there");
            } else {
                System.out.println("it's not");
            }
            tc.addTriple(t);
            System.out.println(tc.toXML());
            System.out.println(tc.toFormatedXML());
        }
        catch (Exception e) {
            System.out.println("error in main");
            e.printStackTrace(System.out);
        }
        System.out.println("Done with " + args[0]);
    }
}

