/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.datapackage.DataViewer;
import edu.ucsb.nceas.morpho.datapackage.PersistentTableModel;
import edu.ucsb.nceas.morpho.datapackage.PersistentVector;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.event.ActionEvent;
import javax.swing.JTable;

public class SortDataTableCommand
implements Command {
    private MorphoFrame morphoFrame = null;

    public void execute(ActionEvent event) {
        DataViewer dataView;
        DataViewContainerPanel resultPane = null;
        this.morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        if (this.morphoFrame != null) {
            resultPane = this.morphoFrame.getDataViewContainerPanel();
        }
        if (resultPane != null && (dataView = resultPane.getCurrentDataViewer()) != null) {
            JTable jtable = dataView.getDataTable();
            PersistentTableModel ptmodel = (PersistentTableModel)jtable.getModel();
            PersistentVector vector = dataView.getPV();
            int direction = dataView.getSortDirection();
            this.sort(this.morphoFrame, dataView, jtable, ptmodel, vector, direction);
        }
    }

    private void sort(MorphoFrame frame, DataViewer viewer, JTable table, PersistentTableModel ptm, PersistentVector pv, int sortdirection) {
        frame.setBusy(true);
        int colsel = table.getSelectedColumn();
        int rowsel = table.getSelectedRow();
        if (colsel > -1) {
            ptm.sort(colsel, sortdirection);
            pv = ptm.getPersistentVector();
            viewer.setPV(pv);
            sortdirection = -1 * sortdirection;
            viewer.setSortDirection(sortdirection);
            table.setColumnSelectionInterval(colsel, colsel);
            table.setRowSelectionInterval(rowsel, rowsel);
        } else {
            Log.debug(45, "No selection!");
        }
        frame.setBusy(false);
    }
}

