/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.PersistentVector;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Stack;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class PersistentTableModel
extends AbstractTableModel {
    PersistentVector pv;
    Vector colNames = null;
    String delimiter = "\t";
    String field_delimiter = "#x09";
    int firstRow = 0;
    Stack changeLogStack;
    boolean logFlag = false;
    boolean changeFlag = false;

    public PersistentTableModel(PersistentVector perV) {
        this.pv = perV;
        this.changeLogStack = new Stack();
        this.changeFlag = false;
    }

    public PersistentTableModel(PersistentVector perV, Vector colNames) {
        this.pv = perV;
        this.colNames = colNames;
        this.changeLogStack = new Stack();
        this.changeFlag = false;
    }

    public PersistentVector getPersistentVector() {
        return this.pv;
    }

    public void setPersistentVector(PersistentVector pv) {
        this.pv = pv;
    }

    public boolean getChangeFlag() {
        return this.changeFlag;
    }

    public void setChangeFlag(boolean cflag) {
        this.changeFlag = cflag;
    }

    public void setFieldDelimiter(String s) {
        this.field_delimiter = s.trim();
    }

    public void saveAsFile(String fileName) {
        this.pv.writeObjects(fileName);
    }

    public String getColumnName(int col) {
        String colName = (String)this.colNames.elementAt(col);
        return colName;
    }

    public boolean isCellEditable(int rowindex, int colindex) {
        int rlast = this.getRowCount() - 1;
        int clast = this.getColumnCount() - 1;
        if (rowindex == rlast) {
            Vector<String> vec = new Vector<String>();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                vec.addElement("");
            }
            this.addRow(vec);
        }
        return true;
    }

    public int getColumnCount() {
        int numCols = 0;
        if (this.colNames != null) {
            numCols = this.colNames.size();
        } else {
            String[] firstRecord = (String[])this.pv.elementAt(this.firstRow);
            numCols = firstRecord.length;
        }
        return numCols;
    }

    public int getRowCount() {
        return this.pv.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object obj = this.pv.elementAt(rowIndex);
        String[] record = (String[])obj;
        String ocell = record.length > columnIndex ? record[columnIndex] : "";
        return " " + ocell;
    }

    private Vector columnValuesAsVector(String[] str) {
        Vector<String> res = new Vector<String>();
        int imax = str.length;
        for (int i = 0; i < imax; ++i) {
            res.addElement(str[i]);
        }
        return res;
    }

    private String[] columnValuesAsArray(Vector vec) {
        String[] res = new String[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            res[i] = (String)vec.elementAt(i);
        }
        return res;
    }

    private boolean inDelimiterList(String token, String delim) {
        boolean result = false;
        int test = delim.indexOf(token);
        result = test > -1;
        return result;
    }

    private String getDelimiterString() {
        String str = "";
        String temp = this.field_delimiter;
        if (temp.startsWith("#x")) {
            if ((temp = temp.substring(2)).equals("0A")) {
                str = "\n";
            }
            if (temp.equals("09")) {
                str = "\t";
            }
            if (temp.equals("20")) {
                str = " ";
            }
        } else {
            str = temp;
        }
        return str;
    }

    public void sort(int colnum, int sortdir) {
        final int cn = colnum;
        final int sdir = sortdir;
        long start = System.currentTimeMillis();
        Collections.sort(this.pv.objectList, new Comparator(){
            String[] o1Str;
            String[] o2Str;
            String token1;
            String token2;

            public int compare(Object o1, Object o2) {
                int res = 0;
                try {
                    this.o1Str = Long.class.isInstance(o1) ? (String[])PersistentTableModel.this.pv.obj.readObject((Long)o1) : (String[])o1;
                    this.token1 = this.o1Str[cn];
                    this.o2Str = Long.class.isInstance(o2) ? (String[])PersistentTableModel.this.pv.obj.readObject((Long)o2) : (String[])o2;
                    this.token2 = this.o2Str[cn];
                    res = this.token1.compareTo(this.token2);
                    res = sdir * res;
                }
                catch (Exception w) {
                    // empty catch block
                }
                return res;
            }
        });
        long stop = System.currentTimeMillis();
        int time = (int)(stop - start);
        System.out.println("Time = " + time);
        this.changeFlag = true;
        this.fireTableStructureChanged();
    }

    public void setValueAt(Object obj, int row, int col) {
        String[] rowA = (String[])this.pv.elementAt(row);
        String currentValue = rowA[col];
        rowA[col] = ((String)obj).trim();
        this.pv.setElementAt((Serializable)rowA, row);
        this.pushLogValues(row, col, currentValue, rowA[col], "new cell entry", "");
    }

    public Stack getLogStack() {
        return this.changeLogStack;
    }

    public void setLogStack(Stack st) {
        this.changeLogStack = st;
    }

    public void clearLogStack() {
        this.changeLogStack = new Stack();
    }

    public void setLogFlag(boolean bol) {
        this.logFlag = bol;
    }

    private void pushLogValues(int row, int col, String oldVal, String newVal, String desc, String annotation) {
        this.changeFlag = true;
        if (this.logFlag) {
            String[] log = new String[]{new Integer(row).toString(), new Integer(col).toString(), oldVal, newVal, desc, annotation};
            this.changeLogStack.push(log);
        }
    }

    public void addRow(Vector vec) {
        while (vec.size() < this.getColumnCount()) {
            vec.addElement(" ");
        }
        String[] record = new String[this.getColumnCount()];
        for (int i = 0; i < this.getColumnCount(); ++i) {
            record[i] = (String)vec.elementAt(i);
        }
        this.pv.addElement((Serializable)record);
        this.pushLogValues(this.getRowCount(), -1, "N/A", "N/A", "added new row at end of data", "");
        this.fireTableRowsInserted(this.pv.size(), this.pv.size());
    }

    public void insertRow(int row, Vector vec) {
        while (vec.size() < this.getColumnCount()) {
            vec.addElement(" ");
        }
        String[] record = new String[this.getColumnCount()];
        for (int i = 0; i < this.getColumnCount(); ++i) {
            record[i] = (String)vec.elementAt(i);
        }
        this.pv.insertElementAt((Serializable)record, row);
        this.pushLogValues(row, -1, "N/A", "N/A", "added new row at" + row, "");
        this.fireTableRowsInserted(row, row);
    }

    public void deleteRow(int row) {
        this.pv.removeElementAt(row);
        this.pushLogValues(row, -1, "N/A", "N/A", "deleted row at" + row, "");
        this.fireTableRowsDeleted(row, row);
    }

    public void addColumn() {
        PersistentVector newpv = new PersistentVector();
        for (int i = this.firstRow; i < this.getRowCount(); ++i) {
            Object obj = this.pv.elementAt(i);
            String[] record = (String[])obj;
            Vector vals = this.columnValuesAsVector(record);
            vals.addElement("");
            String[] newRecord = this.columnValuesAsArray(vals);
            newpv.addElement((Serializable)newRecord);
        }
        String oldFieldDelimiter = this.pv.getFieldDelimiter();
        int oldFirstRow = this.pv.getFirstRow();
        Vector oldHeaderLinesVector = this.pv.getHeaderLinesVector();
        this.pv.delete();
        this.pv = newpv;
        this.pv.setFieldDelimiter(oldFieldDelimiter);
        this.pv.setFirstRow(oldFirstRow);
        this.pv.setHeaderLinesVector(oldHeaderLinesVector);
        this.pushLogValues(-1, this.getColumnCount(), "N/A", "N/A", "added column at end", "");
        this.fireTableStructureChanged();
    }

    public void insertColumn(int colnum) {
        PersistentVector newpv = new PersistentVector();
        for (int i = this.firstRow; i < this.getRowCount(); ++i) {
            Object obj = this.pv.elementAt(i);
            String[] record = (String[])obj;
            Vector vals = this.columnValuesAsVector(record);
            vals.insertElementAt("", colnum);
            String[] newRecord = this.columnValuesAsArray(vals);
            newpv.addElement((Serializable)newRecord);
        }
        String oldFieldDelimiter = this.pv.getFieldDelimiter();
        int oldFirstRow = this.pv.getFirstRow();
        Vector oldHeaderLinesVector = this.pv.getHeaderLinesVector();
        this.pv.delete();
        this.pv = newpv;
        this.pv.setFieldDelimiter(oldFieldDelimiter);
        this.pv.setFirstRow(oldFirstRow);
        this.pv.setHeaderLinesVector(oldHeaderLinesVector);
        this.fireTableStructureChanged();
        this.pushLogValues(-1, colnum, "N/A", "N/A", "added column at " + colnum, "");
    }

    public void deleteColumn(int col) {
        PersistentVector newpv = new PersistentVector();
        for (int i = this.firstRow; i < this.getRowCount(); ++i) {
            Object obj = this.pv.elementAt(i);
            String[] record = (String[])obj;
            Vector vals = this.columnValuesAsVector(record);
            vals.removeElementAt(col);
            String[] newRecord = this.columnValuesAsArray(vals);
            newpv.addElement((Serializable)newRecord);
        }
        String oldFieldDelimiter = this.pv.getFieldDelimiter();
        int oldFirstRow = this.pv.getFirstRow();
        Vector oldHeaderLinesVector = this.pv.getHeaderLinesVector();
        this.pv.delete();
        this.pv = newpv;
        this.pv.setFieldDelimiter(oldFieldDelimiter);
        this.pv.setFirstRow(oldFirstRow);
        this.pv.setHeaderLinesVector(oldHeaderLinesVector);
        this.pushLogValues(-1, col, "N/A", "N/A", "deleted column", "");
        this.fireTableStructureChanged();
    }
}

