/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public class MyURIResolver
implements URIResolver {
    static String baseDefault = "./";
    static String dataDefault = "";

    public static void setDataDefault(String s) {
        dataDefault = s;
    }

    public Source resolve(String href, String base) throws TransformerException {
        URL u = null;
        URL uDefault = null;
        try {
            int c;
            if (base != null && this.isXMLXSL(href)) {
                Log.debug(20, "base: " + base + " --href: " + href);
                URL context = new URL(base);
                baseDefault = base;
                u = new URL(context, href);
            } else if (this.isXMLXSL(href)) {
                Log.debug(20, "baseDefault: " + baseDefault + " --href: " + href);
                uDefault = new URL(baseDefault);
                u = new URL(uDefault, href);
            } else {
                Log.debug(20, "dataDefault: " + dataDefault + " --href: " + href);
                uDefault = new URL(dataDefault);
                u = new URL(uDefault, href);
            }
            Log.debug(20, "----URL:" + u.toString());
            InputStream is = u.openStream();
            InputStreamReader isr = new InputStreamReader(is);
            StringWriter sw = new StringWriter();
            while ((c = isr.read()) != -1) {
                sw.write(c);
            }
            sw.flush();
            is.close();
            sw.close();
            String sws = sw.toString();
            String outStr = this.removeDOCTYPE(sws);
            StringReader newStr = new StringReader(outStr);
            StreamSource stSrc = new StreamSource(newStr);
            return stSrc;
        }
        catch (Exception e) {
            Log.debug(20, "-----Exception triggered in MyURIResolver-----");
            return null;
        }
    }

    private String removeDOCTYPE(String in) {
        String ret = "";
        int startpos = in.indexOf("<!DOCTYPE");
        if (startpos <= -1) {
            return in;
        }
        int stoppos = in.indexOf(">", startpos + 10);
        ret = in.substring(0, startpos) + in.substring(stoppos + 1, in.length());
        return ret;
    }

    private boolean isXMLXSL(String str) {
        boolean ret = false;
        if (str.indexOf(".xsl") > -1 || str.indexOf(".XSL") > -1) {
            ret = true;
        }
        if (str.indexOf(".xml") > -1 || str.indexOf(".XML") > -1) {
            ret = true;
        }
        return ret;
    }
}

