/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.Attribute;
import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.datapackage.DataViewer;
import edu.ucsb.nceas.morpho.datapackage.PersistentTableModel;
import edu.ucsb.nceas.morpho.datapackage.PersistentVector;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardListener;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.StateChangeEvent;
import edu.ucsb.nceas.morpho.util.StateChangeMonitor;
import edu.ucsb.nceas.morpho.util.UISettings;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JTable;
import org.w3c.dom.Node;

public class EditColumnMetaDataCommand
implements Command {
    private MorphoFrame morphoFrame = null;
    private AbstractDataPackage adp = null;
    private DataViewer dataView = null;
    private int attrIndex = -1;
    private int entityIndex = -1;
    private JTable table = null;
    private OrderedMap map = null;
    private String columnName;
    private String mScale;
    private String xPath = "/attribute";

    public void execute(ActionEvent event) {
        DataViewContainerPanel resultPane = null;
        Node[] attributes = null;
        this.morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        if (this.morphoFrame != null) {
            resultPane = this.morphoFrame.getDataViewContainerPanel();
        }
        if (resultPane != null) {
            this.adp = resultPane.getAbstractDataPackage();
        }
        if (this.adp == null) {
            Log.debug(16, " Abstract Data Package is null in the EditColumnMetaDataCommand");
            return;
        }
        if (resultPane != null) {
            this.dataView = resultPane.getCurrentDataViewer();
            if (this.dataView != null) {
                String entityId = this.dataView.getEntityFileId();
                this.table = this.dataView.getDataTable();
                this.attrIndex = this.table.getSelectedColumn();
                this.entityIndex = this.dataView.getEntityIndex();
                attributes = this.adp.getAttributeArray(this.entityIndex);
            }
        }
        if (attributes == null || this.attrIndex == -1) {
            Log.debug(16, " Couldnt get the attributes in\tEditColumnMetaDataCommand for attrIndex = " + this.attrIndex);
            return;
        }
        void currentAttr = attributes[this.attrIndex];
        this.map = XMLUtilities.getDOMTreeAsXPathMap((Node)currentAttr, (String)"/eml:eml/dataset/dataTable/attributeList");
        DataPackageWizardInterface dpwPlugin = null;
        try {
            ServiceController sc = ServiceController.getInstance();
            dpwPlugin = (DataPackageWizardInterface)((Object)sc.getServiceProvider(DataPackageWizardInterface.class));
        }
        catch (ServiceNotHandledException se) {
            Log.debug(6, se.getMessage());
        }
        if (dpwPlugin == null) {
            return;
        }
        AbstractUIPage attributePage = dpwPlugin.getPage("ATTRIBUTE_PAGE");
        boolean canHandleAllData = attributePage.setPageData(this.map, "");
        if (canHandleAllData) {
            ModalDialog wpd = new ModalDialog(attributePage, UIController.getInstance().getCurrentActiveWindow(), 770, 570, false);
            wpd.setSize(770, 600);
            wpd.validate();
            wpd.setVisible(true);
            if (wpd.USER_RESPONSE == 10) {
                this.adp.setLocation("");
                resultPane.saveDataChanges();
                this.map = attributePage.getPageData(this.xPath);
                if (this.entityIndex == -1) {
                    Log.debug(10, "Unable to get the Index of the current Entity, in EditColumnMetaData.");
                    return;
                }
                this.columnName = this.getColumnName(this.map, this.xPath);
                this.mScale = this.getMeasurementScale(this.map, this.xPath);
                boolean toImport = this.isImportNeeded(this.map, this.xPath, this.mScale);
                if (toImport) {
                    String entityName = this.adp.getEntityName(this.entityIndex);
                    this.adp.addAttributeForImport(entityName, this.columnName, this.mScale, this.map, "/attribute", false);
                    DataPackageWizardListener dpwListener = new DataPackageWizardListener(){

                        public void wizardComplete(Node newDOM) {
                            EditColumnMetaDataCommand.this.modifyAttribute();
                            try {
                                ServiceController services = ServiceController.getInstance();
                                ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
                                DataPackageInterface dataPackageInt = (DataPackageInterface)((Object)provider);
                                dataPackageInt.openNewDataPackage(EditColumnMetaDataCommand.this.adp, null);
                            }
                            catch (ServiceNotHandledException snhe) {
                                Log.debug(6, snhe.getMessage());
                            }
                            UIController controller = UIController.getInstance();
                            EditColumnMetaDataCommand.this.morphoFrame.setVisible(false);
                            controller.removeWindow(EditColumnMetaDataCommand.this.morphoFrame);
                            EditColumnMetaDataCommand.this.morphoFrame.dispose();
                        }

                        public void wizardCanceled() {
                        }
                    };
                    dpwPlugin.startCodeDefImportWizard(dpwListener);
                } else {
                    this.modifyAttribute();
                }
            }
        } else {
            if (this.entityIndex < 0) {
                this.entityIndex = 0;
            }
            if (this.attrIndex < 0) {
                this.attrIndex = 0;
            }
            UIController.getInstance().launchEditorAtSubtreeForCurrentFrame("dataTable[" + this.entityIndex + "]/attribute-", this.attrIndex);
        }
    }

    private boolean isImportNeeded(OrderedMap map, String xPath, String mScale) {
        if (!(mScale = mScale.toLowerCase()).equals("nominal") && !mScale.equals("ordinal")) {
            return false;
        }
        String path = xPath + "/measurementScale/" + mScale + "/nonNumericDomain/enumeratedDomain[1]/entityCodeList/entityReference";
        boolean present = map.containsKey((Object)path);
        if (!present) {
            return false;
        }
        String o = (String)map.get((Object)path);
        return o == null || o.trim().equals("");
    }

    private void modifyAttribute() {
        String oldID = this.adp.getAttributeID(this.entityIndex, this.attrIndex);
        if (oldID == null || oldID.trim().equals("")) {
            oldID = UISettings.getUniqueID();
        }
        this.map.put((Object)"/attribute/@id", (Object)oldID);
        Attribute attr = new Attribute(this.map);
        this.adp.insertAttribute(this.entityIndex, attr, this.attrIndex);
        this.adp.deleteAttribute(this.entityIndex, this.attrIndex + 1);
        String unit = this.getUnit(this.map, this.xPath);
        String sType = (String)this.map.get((Object)(this.xPath + "/storageType"));
        if (sType == null) {
            sType = this.mScale;
        }
        String newHeader = "<html><font face=\"Courier\"><center><small>" + sType + "</small><br><small>" + unit + "</small><br><b>" + this.columnName + "</b></center></font></html>";
        if (this.dataView != null) {
            Vector colLabels = this.dataView.getColumnLabels();
            colLabels.set(this.attrIndex, newHeader);
            PersistentVector pv = this.dataView.getPV();
            PersistentTableModel ptm = new PersistentTableModel(pv, colLabels);
            this.table.setModel(ptm);
            this.table.setColumnSelectionInterval(this.attrIndex, this.attrIndex);
            StateChangeEvent stateEvent = new StateChangeEvent(this.table, StateChangeEvent.SELECT_DATATABLE_COLUMN);
            StateChangeMonitor stateMonitor = StateChangeMonitor.getInstance();
            stateMonitor.notifyStateChange(stateEvent);
        }
    }

    private String getColumnName(OrderedMap map, String xPath) {
        Object o1 = map.get((Object)(xPath + "/attributeName"));
        if (o1 == null) {
            return "";
        }
        return (String)o1;
    }

    private String getMeasurementScale(OrderedMap map, String xPath) {
        Object o1 = map.get((Object)(xPath + "/measurementScale/nominal/nonNumericDomain/enumeratedDomain[1]/codeDefinition[1]/code"));
        if (o1 != null) {
            return "Nominal";
        }
        boolean b1 = map.containsKey((Object)(xPath + "/measurementScale/nominal/nonNumericDomain/enumeratedDomain[1]/entityCodeList/entityReference"));
        if (b1) {
            return "Nominal";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/nominal/nonNumericDomain/textDomain[1]/definition"));
        if (o1 != null) {
            return "Nominal";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/ordinal/nonNumericDomain/enumeratedDomain[1]/codeDefinition[1]/code"));
        if (o1 != null) {
            return "Ordinal";
        }
        b1 = map.containsKey((Object)(xPath + "/measurementScale/ordinal/nonNumericDomain/enumeratedDomain[1]/entityCodeList/entityReference"));
        if (b1) {
            return "Ordinal";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/ordinal/nonNumericDomain/textDomain[1]/definition"));
        if (o1 != null) {
            return "Ordinal";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/interval/unit/standardUnit"));
        if (o1 != null) {
            return "Interval";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/interval/unit/customUnit"));
        if (o1 != null) {
            return "Interval";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/ratio/unit/standardUnit"));
        if (o1 != null) {
            return "Ratio";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/ratio/unit/customUnit"));
        if (o1 != null) {
            return "Ratio";
        }
        o1 = map.get((Object)(xPath + "/measurementScale/datetime/formatString"));
        if (o1 != null) {
            return "Datetime";
        }
        return "";
    }

    private String getUnit(OrderedMap map, String xPath) {
        Object o1 = map.get((Object)(xPath + "/measurementScale/interval/unit/standardUnit"));
        if (o1 != null) {
            return (String)o1;
        }
        o1 = map.get((Object)(xPath + "/measurementScale/interval/unit/customUnit"));
        if (o1 != null) {
            return (String)o1;
        }
        o1 = map.get((Object)(xPath + "/measurementScale/ratio/unit/standardUnit"));
        if (o1 != null) {
            return (String)o1;
        }
        o1 = map.get((Object)(xPath + "/measurementScale/ratio/unit/customUnit"));
        if (o1 != null) {
            return (String)o1;
        }
        return "";
    }
}

