/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.DataPackageFactory;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardListener;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.event.ActionEvent;
import org.w3c.dom.Node;

public class CreateNewDataPackageCommand
implements Command {
    private Morpho morpho = null;

    public CreateNewDataPackageCommand(Morpho morpho) {
        this.morpho = morpho;
    }

    public void execute(ActionEvent event) {
        Log.debug(20, "Action fired: New Data Package");
        DataPackageWizardInterface dpw = null;
        try {
            ServiceController services = ServiceController.getInstance();
            ServiceProvider provider = services.getServiceProvider(DataPackageWizardInterface.class);
            dpw = (DataPackageWizardInterface)((Object)provider);
        }
        catch (ServiceNotHandledException snhe) {
            Log.debug(6, snhe.getMessage());
        }
        try {
            dpw.startPackageWizard(new DataPackageWizardListener(){

                public void wizardComplete(Node newDOM) {
                    Log.debug(30, "Wizard complete - Will now create an AbstractDataPackage..");
                    AbstractDataPackage adp = DataPackageFactory.getDataPackage(newDOM);
                    Log.debug(30, "AbstractDataPackage complete");
                    adp.setAccessionNumber("temporary.1.1");
                    try {
                        ServiceController services = ServiceController.getInstance();
                        ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
                        DataPackageInterface dataPackage = (DataPackageInterface)((Object)provider);
                        dataPackage.openNewDataPackage(adp, null);
                    }
                    catch (ServiceNotHandledException snhe) {
                        Log.debug(6, snhe.getMessage());
                    }
                    Log.debug(45, "\n\n********** Wizard finished: DOM:");
                    Log.debug(45, XMLUtilities.getDOMTreeAsString((Node)newDOM, (boolean)false));
                }

                public void wizardCanceled() {
                    Log.debug(45, "\n\n********** Wizard canceled!");
                }
            });
        }
        catch (Throwable t) {
            Log.debug(5, "** ERROR: Unable to start wizard!");
            t.printStackTrace();
        }
    }
}

