/*
 * Decompiled with CFR 0.152.
 */
package edu.tesc.scidb.databank.sms.tdm;

import edu.tesc.scidb.databank.sms.tdm.Col;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Element;

public class ColImpl
implements Col {
    private Map props;

    public ColImpl(String name, String type) {
        this.props = new TreeMap();
        this.setProperty("dataType", type);
        this.setName(name);
    }

    public ColImpl(String name) {
        this.props = new TreeMap();
        this.setName(name);
    }

    public ColImpl(Map props) {
        this.props = props;
    }

    public void setName(String name) {
        this.setProperty("name", name);
    }

    public void setProperty(String name, Object value) {
        this.props.put(name, value);
    }

    public void setProperties(Map props) {
        this.props = props;
    }

    public void setOrder(Integer order) {
        this.props.put("order", order);
    }

    public String getName() {
        return (String)this.getProperty("name");
    }

    public Object getProperty(String name) {
        return this.props.get(name);
    }

    public Map getProperties() {
        return this.props;
    }

    public Integer getOrder() {
        return (Integer)this.props.get("order");
    }

    public boolean hasProperty(String name) {
        return this.props.containsKey(name);
    }

    public int compareTo(Object other) {
        if (this.getOrder() > ((ColImpl)other).getOrder()) {
            return 1;
        }
        if (this.getOrder() < ((ColImpl)other).getOrder()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "ColImpl " + this.props;
    }

    public Element getAsEML(Element parent, String parentTableName) {
        Element measurementScale;
        Element attribute = parent.addElement("attribute");
        attribute.addAttribute("id", parentTableName + "." + this.getName());
        Element attributeName = attribute.addElement("attributeName");
        attributeName.setText(this.getName());
        String attDef = (String)this.getProperty("description");
        if (attDef == null) {
            attDef = new String("");
        }
        Element attributeDef = attribute.addElement("attributeDefinition");
        attributeDef.setText(attDef);
        String attType = (String)this.getProperty("dataType");
        String attUnit = (String)this.getProperty("unit");
        if (attType != null) {
            Element storageType = attribute.addElement("storageType");
            storageType.setText(attType);
        }
        if (attType.equals("ID") || attType.equals("Reference") || attType.equals("StaticReference") || attType.equals("Boolean")) {
            measurementScale = attribute.addElement("measurementScale");
            Element nominal = measurementScale.addElement("nominal");
            Element nonNumericDomain = nominal.addElement("nonNumericDomain");
            Element enumeratedDomain = nonNumericDomain.addElement("enumeratedDomain");
            Element codeDefinition = enumeratedDomain.addElement("codeDefinition");
            Element code = codeDefinition.addElement("code");
            code.setText("1");
            Element definition = codeDefinition.addElement("definition");
            if (attType.equals("ID")) {
                definition.setText("Primary Key");
            } else if (attType.equals("Reference") || attType.equals("StaticReference")) {
                definition.setText("Foreign Key");
            } else if (attType.equals("Boolean")) {
                definition.setText("Boolean Value");
            }
        } else if (attType.equals("String") || attType.equals("Text") || attType.equals("Memo") || attType.equals("BigString")) {
            measurementScale = attribute.addElement("measurementScale");
            Element nominal = measurementScale.addElement("nominal");
            Element nonNumericDomain = nominal.addElement("nonNumericDomain");
            Element textDomain = nonNumericDomain.addElement("textDomain");
            Element definition = textDomain.addElement("definition");
            definition.setText("String Field");
        } else if (attType.equals("Date") || attType.equals("Time") || attType.equals("DateTime")) {
            measurementScale = attribute.addElement("measurementScale");
            Element dateTime = measurementScale.addElement("datetime");
            Element formatString = dateTime.addElement("formatString");
            formatString.setText("MM/DD/YYYY HH:MM:SS AM");
            Element dateTimePercision = dateTime.addElement("dateTimePrecision");
            dateTimePercision.setText("1");
            Element dateTimeDomain = dateTime.addElement("dateTimeDomain");
            Element bounds = dateTimeDomain.addElement("bounds");
        } else if (attType.equals("Integer") || attType.equals("Decimal") || attType.equals("Percent")) {
            if (attUnit == null) {
                attUnit = new String("number");
            }
            measurementScale = attribute.addElement("measurementScale");
            Element ratio = measurementScale.addElement("ratio");
            Element unit = ratio.addElement("unit");
            Element standardUnit = unit.addElement("standardUnit");
            standardUnit.setText(attUnit);
            Element precision = ratio.addElement("precision");
            precision.setText("1");
            Element numericDomain = ratio.addElement("numericDomain");
            Element numberType = numericDomain.addElement("numberType");
            if (attType.equals("Integer")) {
                numberType.setText("integer");
            } else {
                numberType.setText("real");
            }
            Element bounds = numericDomain.addElement("bounds");
        }
        return attribute;
    }
}

