/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.dtd;

import com.wutka.dtd.DTDExternalID;
import com.wutka.dtd.DTDOutput;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;

public class DTDEntity
implements DTDOutput {
    public String name;
    public boolean isParsed;
    public String value;
    public DTDExternalID externalID;
    public String ndata;
    public Object defaultLocation;

    public DTDEntity() {
    }

    public DTDEntity(String aName) {
        this.name = aName;
    }

    public DTDEntity(String aName, Object aDefaultLocation) {
        this.name = aName;
        this.defaultLocation = aDefaultLocation;
    }

    public void write(PrintWriter out) throws IOException {
        out.print("<!ENTITY ");
        if (this.isParsed) {
            out.print(" % ");
        }
        out.print(this.name);
        if (this.value != null) {
            char quoteChar = '\"';
            if (this.value.indexOf(quoteChar) >= 0) {
                quoteChar = '\'';
            }
            out.print(quoteChar);
            out.print(this.value);
            out.print(quoteChar);
        } else {
            this.externalID.write(out);
            if (this.ndata != null) {
                out.print(" NDATA ");
                out.print(this.ndata);
            }
        }
        out.println(">");
    }

    public String getExternalId() {
        return this.externalID.system;
    }

    public Reader getReader() throws IOException {
        Reader rd = this.getReader(this.externalID.system);
        return rd;
    }

    public Reader getReader(String entityName) {
        try {
            if (this.defaultLocation != null) {
                if (this.defaultLocation instanceof File) {
                    File loc = (File)this.defaultLocation;
                    BufferedReader in = new BufferedReader(new FileReader(new File(loc, entityName)));
                    return in;
                }
                if (this.defaultLocation instanceof URL) {
                    URL url = (URL)this.defaultLocation;
                    BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                    return in;
                }
            }
            BufferedReader in = new BufferedReader(new FileReader(entityName));
            return in;
        }
        catch (Exception ignore) {
            try {
                URL url = new URL(entityName);
                InputStream inStream = url.openStream();
                BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
                return in;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public boolean equals(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof DTDEntity)) {
            return false;
        }
        DTDEntity other = (DTDEntity)ob;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.isParsed != other.isParsed) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.externalID == null ? other.externalID != null : !this.externalID.equals(other.externalID)) {
            return false;
        }
        return !(this.ndata == null ? other.ndata != null : !this.ndata.equals(other.ndata));
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    public void setIsParsed(boolean flag) {
        this.isParsed = flag;
    }

    public boolean isParsed() {
        return this.isParsed;
    }

    public void setValue(String aValue) {
        this.value = aValue;
    }

    public String getValue() {
        return this.value;
    }

    public void setExternalID(DTDExternalID anExternalID) {
        this.externalID = anExternalID;
    }

    public DTDExternalID getExternalID() {
        return this.externalID;
    }

    public void setNdata(String anNdata) {
        this.ndata = anNdata;
    }

    public String getNdata() {
        return this.ndata;
    }
}

