/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultTreeModel;
import junit.extensions.jfcunit.tools.ComponentNode;

public final class ComponentBrowser
extends JFrame
implements ActionListener,
TreeSelectionListener,
WindowListener {
    protected static final String TITLE = "ComponentBrowser";
    private DefaultTableModel m_propTableModel;
    private JButton m_refreshButton;
    private JTree m_componentTree;
    static /* synthetic */ Class class$java$awt$Component;

    public ComponentBrowser() {
        this.setTitle(TITLE);
        this.equip(this.getContentPane());
        this.setSize(400, 300);
        this.pack();
        this.setVisible(true);
        this.addWindowListener(this);
    }

    public static void main(String[] args) {
        new ComponentBrowser();
    }

    public boolean isComponentSelected() {
        return (ComponentNode)this.m_componentTree.getLastSelectedPathComponent() != null;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_refreshButton) {
            ((DefaultTreeModel)this.m_componentTree.getModel()).reload();
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (e.getSource() == this.m_componentTree && this.isComponentSelected()) {
            ComponentNode node = (ComponentNode)this.m_componentTree.getLastSelectedPathComponent();
            this.componentSelected(node.getComponent());
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    private boolean isAccessibleGetterMethod(Method method) {
        return method.getName().startsWith("get") || method.getName().startsWith("is");
    }

    private String getPropertyName(String methodName) {
        String propName = null;
        if (methodName.startsWith("get")) {
            propName = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            propName = methodName.substring(2);
        }
        return propName.substring(0, 1).toLowerCase() + propName.substring(1);
    }

    private void addProperty(Component comp, Method method, Vector processed) {
        String name = method.getName();
        if (processed.contains(name)) {
            return;
        }
        processed.addElement(name);
        try {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length == 0) {
                Vector<Object> data = new Vector<Object>(2);
                data.addElement(this.getPropertyName(method.getName()));
                data.addElement(method.invoke((Object)comp, (Object[])new Class[0]));
                this.m_propTableModel.addRow(data);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
    }

    private void componentSelected(Component comp) {
        this.m_propTableModel.setNumRows(0);
        if (comp == null) {
            return;
        }
        Class<?> superClass = comp.getClass();
        Vector processed = new Vector();
        while ((class$java$awt$Component == null ? ComponentBrowser.class$("java.awt.Component") : class$java$awt$Component).isAssignableFrom(superClass)) {
            Method[] methods = superClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!this.isAccessibleGetterMethod(methods[i])) continue;
                this.addProperty(comp, methods[i], processed);
            }
            superClass = superClass.getSuperclass();
        }
        this.m_propTableModel.fireTableDataChanged();
    }

    private JPanel createLeftPanel() {
        this.m_componentTree = new JTree(new ComponentNode(null, null));
        this.m_componentTree.addTreeSelectionListener(this);
        JPanel leftPane = new JPanel(new BorderLayout());
        leftPane.setSize(100, 300);
        leftPane.setPreferredSize(leftPane.getSize());
        leftPane.add((Component)new JScrollPane(this.m_componentTree), "Center");
        this.m_refreshButton = this.createReloadButton();
        leftPane.add((Component)this.m_refreshButton, "South");
        return leftPane;
    }

    private JButton createReloadButton() {
        JButton button = new JButton("Reload");
        button.addActionListener(this);
        return button;
    }

    private JScrollPane createRightPanel() {
        Vector<String> colNames = new Vector<String>(2);
        colNames.add("Prop name");
        colNames.add("Value");
        this.m_propTableModel = new DefaultTableModel(colNames, 0);
        JTable propTable = new JTable(this.m_propTableModel);
        propTable.setAutoResizeMode(4);
        JScrollPane rightPane = new JScrollPane(propTable);
        rightPane.setSize(new Dimension(300, 300));
        rightPane.setPreferredSize(rightPane.getSize());
        rightPane.setColumnHeaderView(propTable.getTableHeader());
        return rightPane;
    }

    private void equip(Container pane) {
        pane.setSize(400, 300);
        pane.add((Component)new JSplitPane(1, this.createLeftPanel(), this.createRightPanel()), "Center");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

