/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import org.w3c.dom.Element;

public class JListMouseEventData
extends AbstractMouseEventData {
    private JList m_list;
    private int m_elementIndex;

    public JListMouseEventData() {
        this.setValid(false);
    }

    public JListMouseEventData(JFCTestCase testCase, JList list, Object element, int numberOfClicks) {
        this(testCase, list, element, numberOfClicks, 300L);
    }

    public JListMouseEventData(JFCTestCase testCase, JList list, Object element, int numberOfClicks, long sleepTime) {
        this(testCase, list, element, numberOfClicks, false, sleepTime);
    }

    public JListMouseEventData(JFCTestCase testCase, JList list, Object element, int numberOfClicks, boolean isPopupTrigger) {
        this(testCase, list, element, numberOfClicks, JListMouseEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger, 300L);
    }

    public JListMouseEventData(JFCTestCase testCase, JList list, Object element, int numberOfClicks, boolean isPopupTrigger, long sleepTime) {
        this(testCase, list, element, numberOfClicks, JListMouseEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger, sleepTime);
    }

    public JListMouseEventData(JFCTestCase testCase, JList list, Object element, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime) {
        this(testCase, list, element, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 0, null);
    }

    public JListMouseEventData(JFCTestCase testCase, JList list, Object element, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position) {
        this(testCase, list, element, numberOfClicks, modifiers, isPopupTrigger, sleepTime, position, null);
    }

    public JListMouseEventData(JFCTestCase testCase, JList list, Object element, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, Point referencePoint) {
        this(testCase, list, element, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 12, referencePoint);
    }

    public JListMouseEventData(JFCTestCase testCase, JList list, Object element, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position, Point referencePoint) {
        this(testCase, list, JListMouseEventData.getIndexOf(list, element), numberOfClicks, modifiers, isPopupTrigger, sleepTime, position, referencePoint);
    }

    public JListMouseEventData(JFCTestCase testCase, JList list, int elementIndex, int numberOfClicks) {
        this(testCase, list, elementIndex, numberOfClicks, 300L);
    }

    public JListMouseEventData(JFCTestCase testCase, JList list, int elementIndex, int numberOfClicks, long sleepTime) {
        this(testCase, list, elementIndex, numberOfClicks, false, sleepTime);
    }

    public JListMouseEventData(JFCTestCase testCase, JList list, int elementIndex, int numberOfClicks, boolean isPopupTrigger) {
        this(testCase, list, elementIndex, numberOfClicks, JListMouseEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger, 300L);
    }

    public JListMouseEventData(JFCTestCase testCase, JList list, int elementIndex, int numberOfClicks, boolean isPopupTrigger, long sleepTime) {
        this(testCase, list, elementIndex, numberOfClicks, JListMouseEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger, sleepTime);
    }

    public JListMouseEventData(JFCTestCase testCase, JList list, int elementIndex, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime) {
        this(testCase, list, elementIndex, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 0, (Point)null);
    }

    public JListMouseEventData(JFCTestCase testCase, JList list, int elementIndex, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position) {
        this(testCase, list, elementIndex, numberOfClicks, modifiers, isPopupTrigger, sleepTime, position, (Point)null);
    }

    public JListMouseEventData(JFCTestCase testCase, JList list, int elementIndex, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, Point referencePoint) {
        this(testCase, list, elementIndex, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 12, referencePoint);
    }

    public JListMouseEventData(JFCTestCase testCase, JList list, int elementIndex, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position, Point referencePoint) {
        this.setTestCase(testCase);
        this.setSource(list);
        this.setNumberOfClicks(numberOfClicks);
        this.setModifiers(modifiers);
        this.setPopupTrigger(isPopupTrigger);
        this.setElementIndex(elementIndex);
        this.setSleepTime(sleepTime);
        this.setPosition(position);
        this.setReferencePoint(referencePoint);
        this.setValid(true);
    }

    public Component getComponent() {
        return this.getSource();
    }

    public void setElementIndex(int elementIndex) {
        this.m_elementIndex = elementIndex;
    }

    public int getElementIndex() {
        return this.m_elementIndex;
    }

    public void setSource(JList list) {
        this.m_list = list;
    }

    public JList getSource() {
        return this.m_list;
    }

    public boolean canConsume(AWTEvent ae) {
        JList source;
        int index;
        if (!(super.canConsume(ae) && ae.getSource() instanceof JList && this.sameSource(ae))) {
            return false;
        }
        return !this.isValid() || (index = (source = (JList)ae.getSource()).locationToIndex(new Point(((MouseEvent)ae).getX(), ((MouseEvent)ae).getY()))) == this.getElementIndex();
    }

    public boolean consume(AWTEvent ae) {
        if (super.consume(ae)) {
            return true;
        }
        MouseEvent me = (MouseEvent)ae;
        JList source = (JList)me.getSource();
        this.setSource(source);
        this.setModifiers(me.getModifiers());
        this.setNumberOfClicks(me.getClickCount());
        this.setPopupTrigger(me.isPopupTrigger());
        Point p = new Point(me.getX(), me.getY());
        Point screen = source.getLocationOnScreen();
        screen.translate(p.x, p.y);
        this.setLocationOnScreen(screen);
        this.setSleepTime(this.getDefaultSleepTime());
        int index = this.m_list.locationToIndex(new Point(me.getX(), me.getY()));
        this.setElementIndex(index);
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setValid(true);
        return true;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        JListMouseEventData data = (JListMouseEventData)o;
        return data.getElementIndex() == this.getElementIndex();
    }

    public int hashCode() {
        return super.hashCode() + this.m_elementIndex;
    }

    public void populate(Element e) {
        super.populate(e);
        e.setAttribute("type", "JListMouseEventData");
        e.setAttribute("index", "" + this.getElementIndex());
    }

    public boolean prepareComponent() {
        if (!this.isValidForProcessing(this.getSource())) {
            return false;
        }
        this.m_list.ensureIndexIsVisible(this.m_elementIndex);
        JFCTestCase testCase = this.getTestCase();
        if (testCase != null) {
            testCase.flushAWT();
        }
        Rectangle cellRect = this.m_list.getCellBounds(this.m_elementIndex, this.m_elementIndex);
        if (testCase != null) {
            testCase.pauseAWT();
        }
        Point p = this.calculatePoint(cellRect);
        if (!this.m_list.getVisibleRect().contains(p)) {
            Rectangle vis = this.m_list.getVisibleRect();
            Rectangle newView = new Rectangle(p.x - vis.width / 2, p.y - vis.height / 2, vis.width, vis.height);
            this.m_list.scrollRectToVisible(newView);
        }
        Point screen = this.m_list.getLocationOnScreen();
        screen.translate(p.x, p.y);
        this.setLocationOnScreen(screen);
        return true;
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer buf = new StringBuffer(1000);
        buf.append(super.toString());
        buf.append(" index: " + this.getElementIndex());
        return buf.toString();
    }

    private static int getIndexOf(JList list, Object element) {
        for (int i = 0; i < list.getModel().getSize(); ++i) {
            if (list.getModel().getElementAt(i) == null || !list.getModel().getElementAt(i).equals(element)) continue;
            return i;
        }
        return -1;
    }
}

