/*
 * Decompiled with CFR 0.152.
 */
package phelps.util;

import com.pt.net.HTTP;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;

public class Dates {
    public static final int SECOND = 1;
    public static final int MINUTE = 60;
    public static final int HOUR = 3600;
    public static final int DAY = 86400;
    public static final int WEEK = 604800;
    public static final int YEAR = 31556736;
    private static final String[] DAYOFWEEK = new String[]{"XXX", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] MONTH = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] MON = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] AMPM = new String[]{"am", "pm"};
    private static DateFormat dateFormat_ = null;
    private static Calendar cal_ = null;

    private Dates() {
    }

    public static long parse(String string) throws ParseException {
        long l = -1L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (l == -1L) {
            try {
                l = HTTP.parseDate(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (l == -1L) {
            if (dateFormat_ == null) {
                dateFormat_ = DateFormat.getDateTimeInstance();
                dateFormat_.setLenient(true);
            }
            try {
                l = dateFormat_.parse(string).getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (l == -1L) {
            throw new ParseException("can't parse  date as either number or human readable: " + string, -1);
        }
        return l;
    }

    public static String relative(long l) {
        return Dates.relative(l, System.currentTimeMillis());
    }

    public static String relative(long l, long l2) {
        long l3 = (l2 - l) / 1000L;
        boolean bl = l3 < 0L;
        String string = " ago";
        if (bl) {
            l3 = -l3;
            string = "";
        }
        if (l3 < 120L) {
            return (bl ? "+" : "") + l3 + " seconds" + string;
        }
        if (l3 < 7200L) {
            return (bl ? "+" : "") + l3 / 60L + " minutes" + string;
        }
        if (l3 < 86400L) {
            return (bl ? "+" : "") + l3 / 3600L + " hours" + string;
        }
        if (cal_ == null) {
            cal_ = Calendar.getInstance();
        }
        Calendar calendar = cal_;
        calendar.setTimeInMillis(l);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(2);
        if (l3 < 172800L) {
            return n + ":" + (n2 < 10 ? "0" : "") + n2 + (bl ? " tomorrow" : " yesterday");
        }
        if (l3 < 604800L) {
            return n + ":" + (n2 < 10 ? "0" : "") + n2 + " " + DAYOFWEEK[calendar.get(7)];
        }
        if (l3 < 27216000L) {
            return calendar.get(5) + " " + MONTH[n3];
        }
        return calendar.get(5) + " " + MONTH[n3] + " " + calendar.get(1);
    }

    public static String prettySeconds(int n) {
        int n2 = n / 60;
        n -= n2 * 60;
        int n3 = n2 / 60;
        n2 -= n3 * 60;
        int n4 = n3 / 24;
        n3 -= n4 * 24;
        StringBuffer stringBuffer = new StringBuffer(100);
        boolean bl = false;
        if (n4 > 0) {
            stringBuffer.append(n4).append("/");
            bl = true;
        }
        if (n3 > 0) {
            stringBuffer.append(n3).append(":");
            bl = true;
        }
        if (n2 > 0 || bl) {
            stringBuffer.append(n2 < 10 && bl ? "0" : "").append(n2).append(":");
            bl = true;
        }
        stringBuffer.append(n < 10 && bl ? "0" : "").append(n);
        return stringBuffer.toString();
    }
}

