/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.ui;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.DocInfo;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.SemanticEvent;
import phelps.net.URIs;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishAnno
extends Behavior {
    public static final String MSG_PUBLISH = "publishAnnos";
    public static final String ATTR_URI = "uri";
    public static final String ATTR_TITLE = "title";
    URI publishTo_ = null;

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        String string = this.getAttr(ATTR_URI);
        try {
            this.publishTo_ = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.println(new StringBuffer().append("Bad URI to publish to: ").append(string).append(" (").append(uRISyntaxException).append(")").toString());
        }
    }

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/File" == string) {
            this.createUI("button", new StringBuffer().append("Publish Annos To ").append(this.getAttr(ATTR_TITLE)).append("...").toString(), "event publishAnnos", (INode)semanticEvent.getOut(), "save", false);
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (MSG_PUBLISH == string && this.publishTo_ != null) {
            String string2 = "xxx";
            Browser browser = this.getBrowser();
            String string3 = "";
            if (string3.length() > 0) {
                DocInfo docInfo = new DocInfo(this.publishTo_);
                docInfo.method = "POST";
                docInfo.attrs.put("POST", new StringBuffer().append("name=mvd/").append(URIs.encode(string2)).append("&contents=").append(URIs.encode(string3)).toString());
                browser.eventq("openDocument", docInfo);
            }
            return true;
        }
        return super.semanticEventAfter(semanticEvent, string);
    }
}

