/*
 * Decompiled with CFR 0.152.
 */
package multivalent;

import java.awt.AWTEvent;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.CHashMap;
import multivalent.Context;
import multivalent.ContextListener;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.EventListener;
import multivalent.INode;
import multivalent.IScrollPane;
import multivalent.Layer;
import multivalent.Leaf;
import multivalent.Mark;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.gui.VDialog;
import multivalent.node.LeafText;
import phelps.doc.RobustLocation;
import phelps.lang.Integers;
import phelps.net.URLs;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Span
extends Behavior
implements ContextListener,
EventListener {
    static final boolean DEBUG = false;
    public static final String MSG_DELETE = "deleteSpan";
    public static final String MSG_MORPH = "morphSpan";
    public static final String MSG_EDIT = "editSpan";
    public static final String MSG_UNATTACHED = "unattachedSpan";
    public static final String GI_START = "start";
    public static final String GI_END = "end";
    private static Map<Span, SoftReference<Node>> pending__;
    private final Mark start_ = new Mark(null, -1, this);
    private final Mark end_ = new Mark(null, -1, this);
    public Map<String, Object> pstart = null;
    public Map<String, Object> pend = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$multivalent$Span;

    public final Mark getStart() {
        return this.start_;
    }

    public final Mark getEnd() {
        return this.end_;
    }

    public boolean isSet() {
        return this.start_.leaf != null && this.end_.leaf != null;
    }

    @Override
    public int getPriority() {
        return 100000;
    }

    @Override
    public boolean appearance(Context context, boolean bl) {
        return false;
    }

    public void open(Node node) {
        if (!$assertionsDisabled && pending__.get(this) != null) {
            throw new AssertionError((Object)"double open()");
        }
        Mark mark = this.getStart();
        pending__.put(this, new SoftReference<Node>(node));
        mark.offset = node != null ? node.size() : 0;
    }

    public boolean close(Node node) {
        if (node == null) {
            return false;
        }
        SoftReference<Node> softReference = pending__.remove(this);
        if (!$assertionsDisabled && softReference == null) {
            throw new AssertionError((Object)"no open()");
        }
        Node node2 = softReference.get();
        Node node3 = node;
        if (node2 == null) {
            node2 = node3.getDocument().getFirstLeaf();
        }
        int n = this.getStart().offset;
        boolean bl = false;
        if (node2 != null && node3 != null) {
            Leaf leaf;
            int n2;
            Leaf leaf2 = node3.getLastLeaf();
            int n3 = n2 = leaf2 != null ? leaf2.size() : -1;
            if (node2.isStruct()) {
                leaf = n < node2.size() ? ((INode)node2).childAt(n).getFirstLeaf() : (n == node2.size() ? ((node2 = ((INode)node2).getLastChild()) != null ? node2.getFirstLeaf() : null) : ((node2 = node2.getNextNode()) != null ? node2.getFirstLeaf() : null));
                n = 0;
            } else {
                if (!$assertionsDisabled && !node2.isLeaf()) {
                    throw new AssertionError();
                }
                if (n < node2.size()) {
                    leaf = (Leaf)node2;
                } else if (node2 == leaf2) {
                    leaf = (Leaf)node2;
                    n = n2;
                } else {
                    Leaf leaf3 = node2.getNextLeaf();
                    if (leaf3 != null && node2.getDocument() == leaf3.getDocument()) {
                        leaf = leaf3;
                        n = 0;
                    } else {
                        leaf = (Leaf)node2;
                        n = node2.size();
                    }
                }
            }
            if (!$assertionsDisabled && leaf != null && leaf2 != null && Node.cmp(leaf, n, leaf2, n2, leaf.getDocument()) == 1) {
                throw new AssertionError((Object)new StringBuffer().append(node2).append("=>").append(leaf).append(" > ").append(leaf2).append(" for ").append(this.getName()).append(" ").append(this.getAttributes()).toString());
            }
            if (leaf != null && leaf2 != null) {
                this.moveq(leaf, n, leaf2, n2);
                bl = true;
            } else if (leaf != null) {
                this.moveq(leaf, n, leaf, n);
            } else if (leaf2 != null) {
                this.moveq(leaf2, n2, leaf2, n2);
            }
        }
        return bl && this.isSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int closeAll(Node node) {
        int n = 0;
        Leaf leaf = node.getLastLeaf();
        if (leaf != null) {
            Map<Span, SoftReference<Node>> map = pending__;
            synchronized (map) {
                ArrayList<Span> arrayList = new ArrayList<Span>(10);
                for (Map.Entry<Span, SoftReference<Node>> entry : pending__.entrySet()) {
                    Node node2 = entry.getValue().get();
                    if (node2 == null || !node.contains(node2)) continue;
                    arrayList.add(entry.getKey());
                }
                Iterator<Map.Entry<Span, SoftReference<Node>>> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    boolean bl = ((Span)((Object)iterator.next())).close(leaf);
                    if (!bl) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public void move(Leaf leaf, int n, Leaf leaf2, int n2) {
        this.markDirty();
        this.moveqSwap(leaf, n, leaf2, n2);
        this.markDirty();
        Browser browser = this.getBrowser();
        if (browser != null) {
            browser.repaint(100L);
        }
    }

    public void move(Span span) {
        Browser browser;
        if (this.isSet()) {
            this.markDirty();
        }
        this.moveq(span);
        if (this.isSet()) {
            this.markDirty();
        }
        if ((browser = this.getBrowser()) != null) {
            browser.repaint(100L);
        }
    }

    public void move(Mark mark, Mark mark2) {
        if (mark == null || mark2 == null) {
            this.move(null);
        } else {
            this.move(mark.leaf, mark.offset, mark2.leaf, mark2.offset);
        }
    }

    public void moveqSwap(Leaf leaf, int n, Leaf leaf2, int n2) {
        Document document = leaf.getDocument();
        if (Node.cmp(leaf, n, leaf2, n2, document) > 0) {
            Leaf leaf3 = leaf;
            leaf = leaf2;
            leaf2 = leaf3;
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        this.moveq(leaf, n, leaf2, n2);
    }

    public void moveq(Leaf leaf, int n, Leaf leaf2, int n2) {
        INode iNode;
        INode iNode2;
        Leaf leaf3 = this.start_.leaf;
        Leaf leaf4 = this.end_.leaf;
        int n3 = this.start_.offset;
        int n4 = this.end_.offset;
        if (leaf == leaf3 && n == n3 && leaf2 == leaf4 && n2 == n4) {
            return;
        }
        if (leaf == leaf4 && n == n4 && leaf2 == leaf3 && n2 == n3) {
            Leaf leaf5 = this.start_.leaf;
            int n5 = this.start_.offset;
            this.start_.leaf = this.end_.leaf;
            this.start_.offset = this.end_.offset;
            this.end_.leaf = leaf5;
            this.end_.offset = n5;
            return;
        }
        if (leaf3 != null && leaf4 != null && (iNode2 = leaf3.getParentNode()) != (iNode = leaf4.getParentNode())) {
            this.removeSummary(this.start_, iNode2);
            this.removeSummary(this.start_, iNode);
        }
        if (leaf != null && leaf2 != null) {
            int n6 = leaf.size();
            int n7 = leaf2.size();
            if (n2 > n7) {
                n2 = n7;
            }
            if (n > n6) {
                n = 0;
            }
            if (leaf != leaf2 || n != n2) {
                this.start_.move(leaf, n);
                this.end_.move(leaf2, n2);
            }
            INode iNode3 = leaf.getParentNode();
            INode iNode4 = leaf2.getParentNode();
            Document document = this.getDocument();
            if (iNode3 != iNode4) {
                this.addSummary(this.start_, iNode3, document);
                this.addSummary(this.start_, iNode4, document);
            }
        } else {
            this.start_.remove();
            this.start_.leaf = leaf;
            this.start_.offset = n;
            this.end_.remove();
            this.end_.leaf = leaf2;
            this.end_.offset = n2;
        }
    }

    public void moveq(Mark mark, Mark mark2) {
        this.moveq(mark != null ? mark.leaf : null, mark != null ? mark.offset : 0, mark2 != null ? mark2.leaf : null, mark2 != null ? mark2.offset : 0);
    }

    public void moveq(Span span) {
        if (span == null) {
            this.moveq(null, this.start_.offset, this.end_.leaf, this.end_.offset);
        } else {
            Mark mark = span.getStart();
            Mark mark2 = span.getEnd();
            this.moveq(mark.leaf, mark.offset, mark2.leaf, mark2.offset);
        }
    }

    public boolean contains(Node node, int n) {
        if (node == null || n < 0) {
            return false;
        }
        if (!($assertionsDisabled || n >= 0 && n <= node.size())) {
            throw new AssertionError((Object)new StringBuffer().append(node).append(" / ").append(n).toString());
        }
        if (!this.isSet()) {
            return false;
        }
        if (node.isStruct()) {
            node = node.getFirstLeaf();
            n = 0;
        }
        Leaf leaf = this.getStart().leaf;
        Leaf leaf2 = this.getEnd().leaf;
        int n2 = this.getStart().offset;
        int n3 = this.getEnd().offset;
        if (leaf == leaf2) {
            return node == leaf && n2 <= n && n <= n3;
        }
        if (node == leaf) {
            return n2 <= n;
        }
        if (node == leaf2) {
            return n <= n3;
        }
        INode iNode = (INode)leaf.commonAncestor(leaf2);
        if (!iNode.contains(node)) {
            return false;
        }
        return Node.cmp(leaf, n2, node, n, iNode) == -1 && Node.cmp(node, n, leaf2, n3, iNode) == -1;
    }

    public boolean contains(Mark mark) {
        return mark != null ? this.contains(mark.leaf, mark.offset) : false;
    }

    public static void stretch(Leaf leaf, INode iNode) {
        if (!$assertionsDisabled && leaf == null) {
            throw new AssertionError();
        }
        if (leaf.sizeSticky() == 0) {
            return;
        }
        Leaf leaf2 = leaf.getPrevLeaf();
        Leaf leaf3 = leaf.getNextLeaf();
        if (iNode != null) {
            if (!iNode.contains(leaf2)) {
                leaf2 = null;
            }
            if (!iNode.contains(leaf3)) {
                leaf3 = null;
            }
        }
        for (int i = leaf.sizeSticky() - 1; i >= 0; --i) {
            Mark mark = leaf.getSticky(i);
            Object object = mark.getOwner();
            if (!(object instanceof Span)) continue;
            Span span = (Span)object;
            Mark mark2 = span.getStart();
            Mark mark3 = span.getEnd();
            if (mark2.leaf == mark3.leaf) {
                span.moveq(null);
                --i;
                continue;
            }
            if (mark == mark3) {
                span.moveq(mark2.leaf, mark2.offset, leaf2, leaf2 != null ? leaf2.size() : -1);
                continue;
            }
            span.moveq(leaf3, 0, mark3.leaf, mark3.offset);
        }
        if (!$assertionsDisabled && leaf.sizeSticky() != 0) {
            throw new AssertionError();
        }
    }

    public void repaint(long l) {
        if (this.isSet()) {
            this.start_.leaf.commonAncestor(this.end_.leaf).repaint(l);
        }
    }

    public void repaint() {
        this.repaint(0L);
    }

    @Override
    public void destroy() {
        if (this.isSet()) {
            IScrollPane iScrollPane = this.getDocument().getIScrollPane();
            if (iScrollPane.isValid()) {
                this.getBrowser().repaint(100L);
            }
            this.markDirty();
            this.moveq(null);
        } else {
            pending__.remove(this);
        }
        super.destroy();
    }

    private void removeSummary(Mark mark, INode iNode) {
        int n;
        if (!($assertionsDisabled || mark != null && iNode != null)) {
            throw new AssertionError();
        }
        while (iNode != null && (n = iNode.indexSticky(mark)) != -1) {
            iNode.removeSticky(n);
            iNode = iNode.getParentNode();
        }
    }

    private void addSummary(Mark mark, INode iNode, Node node) {
        if (!($assertionsDisabled || mark != null && iNode != null)) {
            throw new AssertionError((Object)new StringBuffer().append(mark).append(" ").append(iNode).toString());
        }
        while (iNode != null && iNode != node) {
            int n = iNode.indexSticky(mark);
            if (n == -1) {
                iNode.addSticky(mark, false);
            } else {
                iNode.removeSticky(n);
            }
            iNode = iNode.getParentNode();
        }
    }

    public void markDirty() {
        if (this.isSet()) {
            this.start_.leaf.markDirtyTo(this.end_.leaf);
        }
    }

    @Override
    public ESISNode save() {
        ESISNode eSISNode = null;
        eSISNode = super.save();
        if (this.isSet()) {
            Document document = this.getDocument();
            Leaf leaf = this.getStart().leaf;
            Leaf leaf2 = this.getEnd().leaf;
            int n = this.getStart().offset;
            int n2 = this.getEnd().offset;
            if (this.pstart == null) {
                this.pstart = new CHashMap<Object>(5);
            } else {
                this.pstart.clear();
            }
            RobustLocation.descriptorFor(leaf, n, document, this.pstart);
            if (this.pend == null) {
                this.pend = new CHashMap<Object>(5);
            } else {
                this.pend.clear();
            }
            RobustLocation.descriptorFor(leaf2, n2, document, this.pend);
            this.putAttr("length", Integer.toString(leaf.lengthTo(n, leaf2, n2)));
            StringBuffer stringBuffer = new StringBuffer(1000);
            if (leaf instanceof LeafText) {
                stringBuffer.append(((LeafText)leaf).getText().substring(n));
            }
            if (leaf2 != leaf) {
                for (Leaf leaf3 = leaf.getNextLeaf(); leaf3 != leaf2; leaf3 = leaf3.getNextLeaf()) {
                    if (!(leaf3 instanceof LeafText)) continue;
                    stringBuffer.append(' ').append(((LeafText)leaf3).getText());
                }
                if (leaf2 instanceof LeafText) {
                    stringBuffer.append(((LeafText)leaf2).getText().substring(0, n2));
                }
            }
            if (stringBuffer.length() > 0) {
                this.putAttr("content", stringBuffer.substring(0));
            }
        }
        eSISNode.appendChild(new ESISNode(GI_START, this.pstart));
        eSISNode.appendChild(new ESISNode(GI_END, this.pend));
        return eSISNode;
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        if (eSISNode != null) {
            int n = eSISNode.size();
            for (int i = 0; i < n; ++i) {
                if (!(eSISNode.childAt(i) instanceof ESISNode)) continue;
                ESISNode eSISNode2 = (ESISNode)eSISNode.childAt(i);
                Map<String, Object> map2 = eSISNode2.attrs;
                String string = eSISNode2.getGI();
                if (GI_START.equals(string)) {
                    this.pstart = map2;
                    continue;
                }
                if (!GI_END.equals(string)) continue;
                this.pend = map2;
            }
        }
    }

    @Override
    public void buildAfter(Document document) {
        Document document2 = document;
        if (this.pstart == null || this.pend == null) {
            return;
        }
        Mark mark = RobustLocation.attach(this.pstart, document2);
        Mark mark2 = RobustLocation.attach(this.pend, document2);
        if (!(mark != null && mark2 != null || mark == null && mark2 == null)) {
            int n = Integers.parseInt(this.getAttr("length"), 5);
            if (mark2 == null) {
                mark2 = new Mark(mark);
                mark2.move(n);
            } else {
                mark = new Mark(mark2);
                mark.move(-n);
            }
        }
        if (mark != null && mark2 != null) {
            this.move(mark, mark2);
        } else {
            System.out.println(new StringBuffer().append("couldn't attach ").append(this.getClass().getName()).append("\n\t").append(this.pstart).append("\n\t").append(this.pend).append(", layer=").append(this.getLayer().getName()).toString());
        }
        super.buildAfter(document);
    }

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if (this == semanticEvent.getIn() && "createWidget/DOCPOPUP" == string && this.isEditable()) {
            INode iNode = (INode)semanticEvent.getOut();
            Browser browser = this.getBrowser();
            this.createUI("button", "Morph Span to Selection", new SemanticEvent(browser, MSG_MORPH, null, this, null), iNode, "EDIT", !browser.getSelectionSpan().isSet());
            this.createUI("button", "Delete Span", new SemanticEvent(browser, MSG_DELETE, null, this, null), iNode, null, false);
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Browser browser = this.getBrowser();
        Span span = browser.getSelectionSpan();
        if (this == semanticEvent.getIn()) {
            if (MSG_DELETE == string) {
                span.moveq(this);
                this.destroy();
            } else if (MSG_MORPH == string) {
                if (span.isSet()) {
                    this.move(span);
                    span.move(null);
                }
            } else if (MSG_EDIT == string) {
                URL uRL;
                String string2 = this.getClass().getName();
                if (string2.lastIndexOf(46) != -1) {
                    string2 = string2.substring(string2.lastIndexOf(46) + 1);
                }
                if ((uRL = this.getClass().getResource(new StringBuffer().append(string2).append("-edit.html").toString())) != null) {
                    URI uRI = null;
                    try {
                        uRI = URLs.toURI(uRL);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                    new VDialog("editspan", null, this.getRoot(), uRI, this.getAttributes(), this);
                }
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public void event(AWTEvent aWTEvent) {
    }

    @Override
    public boolean checkRep() {
        if (!$assertionsDisabled && !super.checkRep()) {
            throw new AssertionError();
        }
        if (!this.isSet()) {
            return true;
        }
        if (!($assertionsDisabled || this.start_.getOwner() == this && this.end_.getOwner() == this)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.start_.leaf != null && this.end_.leaf != null)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.start_.offset >= 0 && this.start_.offset <= this.start_.leaf.size())) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.end_.offset >= 0 && this.end_.offset <= this.end_.leaf.size())) {
            throw new AssertionError();
        }
        Document document = this.getDocument();
        if (!$assertionsDisabled && this.start_.leaf.getDocument() != this.end_.leaf.getDocument()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && document != null && document != this.start_.leaf.getDocument() && this != this.getBrowser().getSelectionSpan()) {
            throw new AssertionError();
        }
        return true;
    }

    @Override
    public String toString() {
        return new StringBuffer().append(this.getName()).append("{").append(this.start_).append("..").append(this.end_).append("}").toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$multivalent$Span == null ? (class$multivalent$Span = Span.class$("multivalent.Span")) : class$multivalent$Span).desiredAssertionStatus();
        pending__ = new IdentityHashMap<Span, SoftReference<Node>>(10);
    }
}

