/*
 * Decompiled with CFR 0.152.
 */
package multivalent;

import java.awt.Point;
import multivalent.INode;
import multivalent.Leaf;

public class Mark {
    static final boolean DEBUG = false;
    private Object owner;
    public Leaf leaf;
    public int offset;

    public Mark() {
        this(null, -1);
    }

    public Mark(Leaf leaf, int n) {
        this(leaf, n, null);
    }

    public Mark(Mark mark) {
        this(mark.leaf, mark.offset, mark.getOwner());
    }

    public Mark(Leaf leaf, int n, Object object) {
        this.leaf = leaf;
        this.offset = n;
        this.owner = object;
    }

    public final Object getOwner() {
        return this.owner;
    }

    public boolean isSet() {
        return this.leaf != null && this.leaf.indexSticky(this) != -1;
    }

    public void move(Mark mark) {
        if (mark == null) {
            this.move(null, -1);
        } else {
            this.move(mark.leaf, mark.offset);
        }
    }

    public void move(Leaf leaf, int n) {
        this.remove();
        this.leaf = leaf;
        this.offset = n;
        if (this.leaf != null) {
            this.leaf.addSticky(this);
        }
    }

    public void move(int n) {
        this.move(n, null);
    }

    public void move(int n, INode iNode) {
        if (!this.isSet()) {
            return;
        }
        Leaf leaf = this.leaf;
        this.remove();
        if (n > 0) {
            this.leaf = leaf;
            while (this.leaf != null && n + this.offset > this.leaf.size()) {
                n -= this.leaf.size() - this.offset + 1;
                leaf = this.leaf;
                this.leaf = this.leaf.getNextLeaf();
                this.offset = 0;
            }
            if (this.leaf != null) {
                this.offset = Math.min(this.leaf.size(), this.offset + n);
            } else {
                this.leaf = leaf;
                this.offset = leaf.size();
            }
        } else if (n < 0) {
            n = -n;
            this.leaf = leaf;
            while (this.leaf != null && n > this.offset) {
                n -= this.offset + 1;
                leaf = this.leaf;
                this.leaf = this.leaf.getPrevLeaf();
                this.offset = this.leaf.size();
            }
            if (this.leaf != null) {
                this.offset = Math.max(0, this.offset - n);
            } else {
                this.leaf = leaf;
                this.offset = 0;
            }
        }
        if (iNode != null && !iNode.contains(this.leaf)) {
            if (n < 0) {
                this.leaf = iNode.getFirstLeaf();
                this.offset = 0;
            } else if (n > 0) {
                this.leaf = iNode.getLastLeaf();
                this.offset = this.leaf.size();
            }
        }
        if (this.leaf != null) {
            this.leaf.addSticky(this);
        }
    }

    public void remove() {
        if (this.leaf != null) {
            this.leaf.removeSticky(this);
            this.leaf = null;
        }
    }

    public void scrollTo() {
        if (this.isSet()) {
            Point point = this.leaf.offset2rel(this.offset);
            this.leaf.scrollTo(point.x, point.y, true);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Mark)) {
            return false;
        }
        Mark mark = (Mark)object;
        return mark.leaf == this.leaf && mark.offset == this.offset && mark.owner == this.owner;
    }

    public int hashCode() {
        return System.identityHashCode(this.leaf) + this.offset;
    }

    public String toString() {
        return this.leaf + "/" + this.offset;
    }
}

