/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import com.pt.io.FSFileTar;
import com.pt.io.FileSystem;
import com.pt.io.InputUni;
import com.pt.io.RandomAccess;
import com.pt.io.RandomAccessFileBuffered;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;
import phelps.io.Files;

public class FileSystemTar
extends FileSystem {
    private static final boolean DEBUG = false;
    private static final int BLOCKSIZE = 512;
    public static final char separatorChar = '/';
    private URI uri_;
    private RandomAccess ra_;
    private long pos0_;

    public FileSystemTar(InputUni inputUni) throws IOException {
        super(inputUni.getURI());
        this.ra_ = inputUni.getRandomAccess();
    }

    public FileSystemTar(File file) throws IOException {
        super(file.toURI());
        this.ra_ = new RandomAccessFileBuffered(file, "r");
    }

    public Iterator iterator() throws IOException {
        return new IteratorFSFileTar();
    }

    public void close() throws IOException {
        if (this.ra_ != null) {
            this.ra_.close();
            this.ra_ = null;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        File file = Files.getFile("~/tmp/v/Multivalent-src.zip");
        FileSystemTar fileSystemTar = new FileSystemTar(file);
        fileSystemTar.list();
    }

    class IteratorFSFileTar
    implements Iterator {
        private FSFileTar next_;

        public boolean hasNext() {
            return this.next_ != null;
        }

        public Object next() {
            FSFileTar fSFileTar = this.next_;
            if (fSFileTar == null) {
                throw new NoSuchElementException();
            }
            try {
                throw new IOException("in order to compile");
            }
            catch (IOException iOException) {
                return fSFileTar;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

