/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import phelps.net.URIs;

public class FileLogRecord {
    public final String path;
    public long length;
    public long mod;
    public long hash;
    public String data;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileLogRecord(String string, long l, long l2, long l3, String string2) {
        this.path = string;
        if (!($assertionsDisabled || string != null && string.indexOf(9) == -1)) {
            throw new AssertionError((Object)string);
        }
        this.length = l;
        this.mod = l2;
        this.hash = l3;
        this.data = string2 == null ? "" : string2;
    }

    public FileLogRecord(File file) {
        this.path = file.toString();
        this.length = file.length();
        this.mod = file.lastModified();
        this.hash = -1L;
        this.data = "";
    }

    FileLogRecord(String string, int n) throws Exception {
        int n2;
        int n3;
        int n4;
        int n5;
        if (1 <= n && n <= 2) {
            n5 = string.indexOf(9);
            n4 = string.indexOf(9, n5 + 1);
            n3 = string.indexOf(9, n4 + 1);
            n2 = string.indexOf(9, n3 + 1);
            if (n5 == -1 || n4 == -1 || n3 == -1 || n2 == -1) {
                System.err.println("invalid record format: " + string);
            }
        } else {
            throw new Exception("unknown version " + n + ", latest known = 1");
        }
        this.path = URIs.decode(string.substring(0, n5));
        this.length = Long.parseLong(string.substring(n5 + 1, n4));
        this.mod = Long.parseLong(string.substring(n4 + 1, n3));
        this.hash = Long.parseLong(string.substring(n3 + 1, n2));
        this.data = URIs.decode(string.substring(n2 + 1));
    }

    public void computeHash() throws IOException {
        int n;
        File file = new File(this.path);
        if (file.isDirectory()) {
            return;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] byArray = new byte[8192];
        while ((n = randomAccessFile.read(byArray)) >= 0) {
            messageDigest.update(byArray, 0, n);
        }
        randomAccessFile.close();
        byte[] byArray2 = messageDigest.digest();
        for (int i = 0; i < 8; ++i) {
            this.hash = this.hash << 8 | (long)(byArray2[i] & 0xFF);
        }
    }

    public String toString() {
        return URIs.encode(this.path) + "\t" + this.length + "\t" + this.mod + "\t" + this.hash + "\t" + URIs.encode(this.data);
    }

    static {
        $assertionsDisabled = !FileLogRecord.class.desiredAssertionStatus();
    }
}

