/*
 * Decompiled with CFR 0.152.
 */
package tool.doc;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import phelps.net.RobustHyperlink;
import tool.doc.ExtractText;

public class LexSig {
    public static final String VERSION = "1.1 of $Date: 2003/07/04 08:40:24 $";
    public static final String USAGE = "java tool.doc.LexSig [-verbose] <URL-or-file>";
    boolean fverbose_;
    boolean fquiet_;
    ExtractText et_ = new ExtractText();

    public LexSig() {
        this.defaults();
    }

    public void defaults() {
        this.fverbose_ = true;
        this.fquiet_ = false;
    }

    public String computeSignature(URI uRI) throws Exception {
        String string = this.et_.extract(uRI);
        boolean bl = RobustHyperlink.Verbose;
        RobustHyperlink.Verbose = this.fverbose_;
        String string2 = RobustHyperlink.computeSignature(string);
        RobustHyperlink.Verbose = bl;
        return string2;
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.startsWith("-minwordlen")) {
                RobustHyperlink.MinWordLength = Integer.parseInt(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-pre")) {
                RobustHyperlink.FoldCase = false;
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                this.fverbose_ = false;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        LexSig lexSig = new LexSig();
        URI uRI = new File(".").getCanonicalFile().toURI();
        int n = stringArray.length;
        for (int i = lexSig.commandLine(stringArray); i < n; ++i) {
            try {
                URI uRI2 = uRI.resolve(stringArray[i]);
                System.out.println(uRI2);
                String string = lexSig.computeSignature(uRI2);
                System.out.println(string);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        RobustHyperlink.writeCache();
        System.exit(0);
    }
}

