/*
 * Decompiled with CFR 0.152.
 */
package phelps.lang.reflect;

import phelps.lang.reflect.Attribute_info;
import phelps.lang.reflect.ClassFile;
import phelps.lang.reflect.Cp_info;

public class Field_info {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_TRANSIENT = 128;
    public short access_flags;
    public String name;
    public String descriptor;
    public Attribute_info[] attributes;

    public Field_info(Cp_info[] cp_infoArray, ClassFile classFile) {
        this.access_flags = classFile.readu2();
        this.name = cp_infoArray[classFile.readu2()].getString(cp_infoArray, classFile);
        this.descriptor = cp_infoArray[classFile.readu2()].getString(cp_infoArray, classFile);
        this.attributes = new Attribute_info[classFile.readu2()];
        int n = this.attributes.length;
        for (int i = 0; i < n; ++i) {
            this.attributes[i] = classFile.getAttributeInfo(cp_infoArray);
        }
    }

    public static String access2String(int n) {
        if (n == 0) {
            return " ";
        }
        StringBuffer stringBuffer = new StringBuffer(25);
        if ((n & 1) != 0) {
            stringBuffer.append("public ");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("private ");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("protected ");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("static ");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("final ");
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append("volatile ");
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append("transient ");
        }
        return stringBuffer.substring(0);
    }

    public String toString() {
        int n = ClassFile.sizeof(this.descriptor);
        return Field_info.access2String(this.access_flags) + ClassFile.type2String(this.descriptor) + this.name + " (" + n + (n > 1 ? " bytes)" : " byte)");
    }
}

