/*
 * Decompiled with CFR 0.152.
 */
package multivalent.devel.lens;

import com.pt.awt.NFont;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import multivalent.Context;
import multivalent.INode;
import multivalent.Node;
import multivalent.std.lens.Lens;

public class Bounds
extends Lens {
    public static final Color[] RAINBOW = new Color[]{Color.RED, Color.BLUE, Color.GREEN, Color.YELLOW, Color.ORANGE};
    protected NFont font_ = NFont.getInstance("Times", 400, 2, 7.0f);

    public boolean appearance(Context context, boolean bl) {
        context.foreground = Color.LIGHT_GRAY;
        context.background = Color.WHITE;
        return false;
    }

    public boolean paintAfter(Context context, Node node) {
        Graphics2D graphics2D = context.g;
        graphics2D.setColor(Color.RED);
        Rectangle rectangle = this.getContentBounds();
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.clip(rectangle);
        this.paintRecurse(graphics2D2, graphics2D2.getClipBounds(), this.getBrowser().getRoot());
        graphics2D2.dispose();
        return super.paintAfter(context, node);
    }

    void paintRecurse(Graphics2D graphics2D, Rectangle rectangle, Node node) {
        Rectangle rectangle2 = node.bbox;
        if (rectangle.intersects(rectangle2)) {
            if (node.isStruct()) {
                int n = node.dx();
                int n2 = node.dy();
                graphics2D.translate(n, n2);
                rectangle.translate(-n, -n2);
                INode iNode = (INode)node;
                int n3 = iNode.size();
                for (int i = 0; i < n3; ++i) {
                    this.paintRecurse(graphics2D, rectangle, iNode.childAt(i));
                }
                graphics2D.translate(-n, -n2);
                rectangle.translate(n, n2);
            } else {
                graphics2D.setColor(RAINBOW[rectangle2.x % RAINBOW.length]);
                graphics2D.draw(rectangle2);
                String string = "(" + rectangle2.x + "," + rectangle2.y + ")";
                graphics2D.setColor(Color.BLACK);
                this.font_.drawString(graphics2D, string, rectangle2.x + 2, rectangle2.y + 9);
            }
        }
    }
}

