/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.security.Permission;
import javax.swing.JButton;
import javax.swing.JFrame;
import junit.extensions.jfcunit.ExitException;
import junit.extensions.jfcunit.TestHelper;
import junit.extensions.jfcunit.WindowMonitor;
import junit.framework.TestCase;

public class JFCTestCase
extends TestCase {
    private static final long DEFAULTLOCKWAIT = 25L;
    private static final long DEFAULTSLEEP = 100L;
    private Object m_lock = new Object();
    private Throwable m_err;
    private transient boolean m_assertExit = false;
    private TestHelper m_helper;
    private boolean m_cont = false;
    private boolean m_exited = false;
    private boolean m_runBare = false;
    private boolean m_forcedWait = false;
    private volatile boolean m_pausingAWT = false;
    private volatile boolean m_waiting = false;
    private long m_lockWait = 25L;
    private long m_sleepTime = 100L;

    protected JFCTestCase() {
    }

    public JFCTestCase(String name) {
        super(name);
    }

    public final void setAssertExit(boolean aValue) {
        if (!this.m_assertExit && aValue && this.m_runBare) {
            System.setSecurityManager(this.createNoExitSecurityManager());
        }
        this.m_assertExit = aValue;
    }

    public final boolean getAssertExit() {
        return this.m_assertExit;
    }

    public final void setHelper(TestHelper helper) {
        this.m_helper = helper;
    }

    public final TestHelper getHelper() {
        return this.m_helper;
    }

    public final void setSleepTime(long time) {
        this.m_sleepTime = time;
    }

    public final void awtSleep() {
        this.release();
        try {
            this.acquire();
        }
        catch (ExitException exe) {
            this.setError(exe);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public final void awtSleep(long sleepTime) {
        this.setSleepTime(sleepTime);
        this.awtSleep();
    }

    public final void flushAWT() {
        this.pauseAWT();
        this.resumeAWT();
    }

    public final void pauseAWT() {
        this.m_pausingAWT = true;
        this.awtSleep();
    }

    public final void resetSleepTime() {
        this.m_sleepTime = 100L;
    }

    public final void resumeAWT() {
        this.awtSleep();
        this.m_pausingAWT = false;
        this.awtSleep();
    }

    public final void sleep(long delay) {
        long releaseTime = System.currentTimeMillis() + delay;
        releaseTime += delay;
        while (System.currentTimeMillis() < releaseTime) {
            this.release();
            try {
                Thread.currentThread();
                Thread.sleep(this.m_lockWait);
                this.acquire();
            }
            catch (InterruptedException ie) {}
        }
    }

    public boolean isAWTRunning() {
        return !this.m_pausingAWT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        SecurityManager oldsm = System.getSecurityManager();
        if (this.m_assertExit) {
            System.setSecurityManager(this.createNoExitSecurityManager());
        }
        this.m_runBare = true;
        try {
            try {
                this.runCode(new Runnable(){

                    public void run() {
                        try {
                            JFCTestCase.this.setUp();
                            JFCTestCase.this.flushAWT();
                        }
                        catch (Throwable e) {
                            JFCTestCase.this.setError(e);
                        }
                    }
                });
                try {
                    this.runTest();
                }
                catch (ExitException exe) {
                    this.setError(exe);
                }
            }
            catch (Throwable throwable) {
                this.runCode(new Runnable(){

                    public void run() {
                        try {
                            JFCTestCase.this.resumeAWT();
                            JFCTestCase.this.tearDown();
                            JFCTestCase.this.flushAWT();
                        }
                        catch (Throwable e) {
                            JFCTestCase.this.setError(e);
                        }
                    }
                });
                throw throwable;
            }
            this.runCode(new /* invalid duplicate definition of identical inner class */);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            System.setSecurityManager(oldsm);
            if (this.m_assertExit) {
                JFCTestCase.assertTrue((String)"System.exit() was not called", (boolean)this.m_exited);
            }
            throw throwable;
        }
        System.setSecurityManager(oldsm);
        if (this.m_assertExit) {
            JFCTestCase.assertTrue((String)"System.exit() was not called", (boolean)this.m_exited);
        }
    }

    protected final void setError(Throwable error) {
        if (error != null) {
            this.setContinue(false);
        }
        this.m_err = error;
    }

    protected final Throwable getError() {
        return this.m_err;
    }

    protected final void setForcedWait(boolean forced) {
        this.m_forcedWait = forced;
    }

    protected final void setLockWait(long duration) {
        this.m_lockWait = duration <= 0L ? 25L : duration;
    }

    protected final long getLockWait() {
        return this.m_lockWait;
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected final SecurityManager createNoExitSecurityManager() {
        return new JFCSecurityManager(System.getSecurityManager());
    }

    protected final boolean hasError() {
        return this.m_err != null && !(this.m_err instanceof ExitException);
    }

    protected final void resetError() {
        this.setError(null);
    }

    protected final void resetForcedWait() {
        this.m_forcedWait = false;
    }

    protected synchronized void runCode(final Runnable code) throws Throwable {
        this.m_waiting = false;
        this.setContinue(true);
        this.resetError();
        TestHelper.setCurrentTestCase(this);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = JFCTestCase.this.m_lock;
                synchronized (object) {
                    JFCTestCase.this.m_waiting = true;
                    try {
                        JFCTestCase.this.acquire();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    try {
                        code.run();
                    }
                    catch (Throwable exe) {
                        JFCTestCase.this.setError(exe);
                    }
                    JFCTestCase.this.setContinue(false);
                    JFCTestCase.this.release();
                }
            }
        }, this.getName()).start();
        while (!this.m_waiting) {
            try {
                Thread.currentThread();
                Thread.sleep(this.m_lockWait);
            }
            catch (ExitException exe) {
                this.setError(exe);
            }
            catch (InterruptedException ie) {}
        }
        boolean condition = false;
        boolean firstTime = true;
        long elapsedTime = 0L;
        do {
            if (firstTime && this.m_pausingAWT) {
                Toolkit.getDefaultToolkit().getSystemEventQueue();
                EventQueue.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = JFCTestCase.this.m_lock;
                        synchronized (object) {
                            JFCTestCase.this.release();
                            try {
                                JFCTestCase.this.acquire();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                });
                if (this.m_forcedWait) {
                    firstTime = false;
                }
            }
            try {
                elapsedTime += this.m_lockWait;
                Thread.currentThread();
                Thread.sleep(this.m_lockWait);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        } while (condition = this.m_forcedWait ? elapsedTime <= this.getSleepTime() : this.getContinue());
        if (this.hasError()) {
            throw this.getError();
        }
    }

    protected void runTest() throws Throwable {
        Method runMethod;
        try {
            runMethod = ((Object)((Object)this)).getClass().getMethod(this.getName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            JFCTestCase.fail((String)("Method \"" + this.getName() + "\" not found"));
            return;
        }
        if (runMethod != null && !Modifier.isPublic(runMethod.getModifiers())) {
            JFCTestCase.fail((String)("Method \"" + this.getName() + "\" should be public"));
            return;
        }
        this.runCode(new Runnable(){

            public void run() {
                try {
                    runMethod.invoke((Object)JFCTestCase.this, new Object[0]);
                    JFCTestCase.this.flushAWT();
                }
                catch (InvocationTargetException e) {
                    JFCTestCase.this.setError(e.getTargetException());
                }
                catch (Throwable e) {
                    JFCTestCase.this.setError(e);
                }
            }
        });
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void setContinue(boolean c) {
        this.m_cont = c;
    }

    private boolean getContinue() {
        return this.m_cont;
    }

    private long getSleepTime() {
        return this.m_sleepTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquire() throws InterruptedException {
        Object object = this.m_lock;
        synchronized (object) {
            try {
                if (this.m_pausingAWT) {
                    this.m_lock.wait();
                } else {
                    this.m_lock.wait(this.m_lockWait);
                }
            }
            catch (ExitException exitException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        Object object = this.m_lock;
        synchronized (object) {
            try {
                this.m_lock.notify();
            }
            catch (ExitException exitException) {
                // empty catch block
            }
        }
    }

    protected void pause() {
        final boolean[] finished = new boolean[]{false};
        final JFrame frame = new JFrame();
        JButton button = new JButton("Continue");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                finished[0] = true;
                frame.setVisible(false);
                frame.dispose();
            }
        });
        frame.getContentPane().add(button);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        while (!finished[0]) {
            this.sleep(1000L);
        }
    }

    static {
        WindowMonitor.start();
    }

    class JFCSecurityManager
    extends SecurityManager {
        private SecurityManager m_delegate;

        public JFCSecurityManager(SecurityManager delegate) {
            this.m_delegate = delegate;
        }

        public void checkExit(int status) {
            if (JFCTestCase.this.m_assertExit) {
                JFCTestCase.this.m_exited = true;
                JFCTestCase.this.setContinue(false);
                throw new ExitException(status);
            }
            this.m_delegate.checkExit(status);
        }

        public void checkPermission(Permission perm) {
            if (this.m_delegate != null) {
                this.m_delegate.checkPermission(perm);
            }
        }

        public void checkAccept(String host, int port) {
            if (this.m_delegate != null) {
                this.m_delegate.checkAccept(host, port);
            }
        }

        public void checkAccess(Thread t) {
            if (this.m_delegate != null) {
                this.m_delegate.checkAccess(t);
            }
        }

        public void checkAccess(ThreadGroup g) {
            if (this.m_delegate != null) {
                this.m_delegate.checkAccess(g);
            }
        }

        public void checkAwtEventQueueAccess() {
            if (this.m_delegate != null) {
                this.m_delegate.checkAwtEventQueueAccess();
            }
        }

        public void checkConnect(String host, int port) {
            if (this.m_delegate != null) {
                this.m_delegate.checkConnect(host, port);
            }
        }

        public void checkConnect(String host, int port, Object context) {
            if (this.m_delegate != null) {
                this.m_delegate.checkConnect(host, port, context);
            }
        }

        public void checkCreateClassLoader() {
            if (this.m_delegate != null) {
                this.m_delegate.checkCreateClassLoader();
            }
        }

        public void checkDelete(String file) {
            if (this.m_delegate != null) {
                this.m_delegate.checkDelete(file);
            }
        }

        public void checkExec(String cmd) {
            if (this.m_delegate != null) {
                this.m_delegate.checkExec(cmd);
            }
        }

        public void checkLink(String lib) {
            if (this.m_delegate != null) {
                this.m_delegate.checkLink(lib);
            }
        }

        public void checkListen(int port) {
            if (this.m_delegate != null) {
                this.m_delegate.checkListen(port);
            }
        }

        public void checkMemberAccess(Class clazz, int which) {
            if (this.m_delegate != null) {
                this.m_delegate.checkMemberAccess(clazz, which);
            }
        }

        public void checkMulticast(InetAddress maddr) {
            if (this.m_delegate != null) {
                this.m_delegate.checkMulticast(maddr);
            }
        }

        public void checkPackageAccess(String pkg) {
            if (this.m_delegate != null) {
                this.m_delegate.checkPackageAccess(pkg);
            }
        }

        public void checkPackageDefinition(String pkg) {
            if (this.m_delegate != null) {
                this.m_delegate.checkPackageDefinition(pkg);
            }
        }

        public void checkPermission(Permission perm, Object context) {
            if (this.m_delegate != null) {
                this.m_delegate.checkPermission(perm, context);
            }
        }

        public void checkPrintJobAccess() {
            if (this.m_delegate != null) {
                this.m_delegate.checkPrintJobAccess();
            }
        }

        public void checkPropertiesAccess() {
            if (this.m_delegate != null) {
                this.m_delegate.checkPropertiesAccess();
            }
        }

        public void checkPropertyAccess(String key) {
            if (this.m_delegate != null) {
                this.m_delegate.checkPropertyAccess(key);
            }
        }

        public void checkRead(FileDescriptor fd) {
            if (this.m_delegate != null) {
                this.m_delegate.checkRead(fd);
            }
        }

        public void checkRead(String file) {
            if (this.m_delegate != null) {
                this.m_delegate.checkRead(file);
            }
        }

        public void checkRead(String file, Object context) {
            if (this.m_delegate != null) {
                this.m_delegate.checkRead(file, context);
            }
        }

        public void checkSecurityAccess(String target) {
            if (this.m_delegate != null) {
                this.m_delegate.checkSecurityAccess(target);
            }
        }

        public void checkSetFactory() {
            if (this.m_delegate != null) {
                this.m_delegate.checkSetFactory();
            }
        }

        public void checkSystemClipboardAccess() {
            if (this.m_delegate != null) {
                this.m_delegate.checkSystemClipboardAccess();
            }
        }

        public boolean checkTopLevelWindow(Object window) {
            if (this.m_delegate != null) {
                return this.m_delegate.checkTopLevelWindow(window);
            }
            return false;
        }

        public void checkWrite(FileDescriptor fd) {
            if (this.m_delegate != null) {
                this.m_delegate.checkWrite(fd);
            }
        }

        public void checkWrite(String file) {
            if (this.m_delegate != null) {
                this.m_delegate.checkWrite(file);
            }
        }

        public Object getSecurityContext() {
            if (this.m_delegate != null) {
                return this.m_delegate.getSecurityContext();
            }
            return "";
        }

        public ThreadGroup getThreadGroup() {
            if (this.m_delegate != null) {
                return this.m_delegate.getThreadGroup();
            }
            return null;
        }
    }
}

