/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.datastore.MetacatUploadException;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.SwingWorker;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.query.OpenDialogBox;
import edu.ucsb.nceas.morpho.query.RefreshCommand;
import edu.ucsb.nceas.morpho.query.ResultPanel;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class LocalToNetworkCommand
implements Command {
    private JDialog synchronizeDialog = null;
    private OpenDialogBox openDialog = null;
    private MorphoFrame morphoFrame = null;
    private String morphoFrameType = null;
    private ResultPanel resultPane = null;
    String selectDocId = null;
    private boolean inLocal = false;
    private boolean inNetwork = false;
    private boolean comeFromOpenDialog = false;

    public LocalToNetworkCommand(OpenDialogBox myOpenDialog, JDialog box, MorphoFrame myFrame, String frameType, String selectId, boolean myInLocal, boolean myInNetwork) {
        if (myOpenDialog != null) {
            this.openDialog = myOpenDialog;
            this.comeFromOpenDialog = true;
        } else {
            this.morphoFrameType = frameType;
        }
        this.synchronizeDialog = box;
        this.morphoFrame = myFrame;
        this.selectDocId = selectId;
        this.inLocal = myInLocal;
        this.inNetwork = myInNetwork;
    }

    public void execute(ActionEvent event) {
        if (this.selectDocId != null && !this.selectDocId.equals("") && !this.inNetwork && this.inLocal) {
            if (this.synchronizeDialog != null) {
                this.synchronizeDialog.setVisible(false);
                this.synchronizeDialog.dispose();
                this.synchronizeDialog = null;
            }
            this.doUpload(this.openDialog, this.comeFromOpenDialog, this.morphoFrame);
        }
    }

    private void doUpload(final OpenDialogBox open, final boolean hasOpen, final MorphoFrame frame) {
        SwingWorker worker = new SwingWorker(){
            DataPackageInterface dataPackage;
            boolean refreshFlag = false;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object construct() {
                try {
                    ServiceController services = ServiceController.getInstance();
                    ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
                    this.dataPackage = (DataPackageInterface)((Object)provider);
                }
                catch (ServiceNotHandledException snhe) {
                    Log.debug(6, "Error in upload");
                    return null;
                }
                frame.setBusy(true);
                RefreshCommand refresh = null;
                refresh = hasOpen ? new RefreshCommand(open) : new RefreshCommand(frame);
                Log.debug(20, "Uploading package.");
                try {
                    block14: {
                        block13: {
                            this.dataPackage.upload(LocalToNetworkCommand.this.selectDocId, false);
                            this.refreshFlag = true;
                            if (LocalToNetworkCommand.this.comeFromOpenDialog) break block13;
                            if (LocalToNetworkCommand.this.morphoFrameType == null) break block14;
                            String string = LocalToNetworkCommand.this.morphoFrameType;
                            LocalToNetworkCommand.this.morphoFrame;
                            if (!string.equals("searchResultFrame")) break block14;
                        }
                        refresh.execute(null);
                        return null;
                    }
                    if (LocalToNetworkCommand.this.morphoFrameType == null) return null;
                    String string = LocalToNetworkCommand.this.morphoFrameType;
                    LocalToNetworkCommand.this.morphoFrame;
                    if (!string.equals("dataPackageFrame")) return null;
                    this.refreshDataPackageFrame();
                    return null;
                }
                catch (MetacatUploadException mue) {
                    String errorMsg = mue.getMessage();
                    if (errorMsg.indexOf("Invalid content") > -1) {
                        Log.debug(1, "Synchonization failed due to validation problem!");
                        Log.debug(20, "MetacatUploadException: " + errorMsg);
                        return null;
                    }
                    String message = "A conflict has been found in one or more of the identifiers \nin your package.  It is possible that you or \nsomeone else has made a change on the server that has not \nbeen reflected on your local copy. If you proceed the identifier \nfor this package will be changed.  Are you sure you want to \nproceed with the upload?";
                    int choice = 0;
                    choice = hasOpen ? JOptionPane.showConfirmDialog(open, message, "Morpho", 1, 2) : JOptionPane.showConfirmDialog(frame, message, "Morpho", 1, 2);
                    if (choice != 0) return null;
                    try {
                        block16: {
                            block15: {
                                Log.debug(30, "the docid before upload: " + LocalToNetworkCommand.this.selectDocId);
                                LocalToNetworkCommand.this.selectDocId = this.dataPackage.upload(LocalToNetworkCommand.this.selectDocId, true);
                                Log.debug(30, "docid after upload: " + LocalToNetworkCommand.this.selectDocId);
                                this.refreshFlag = true;
                                if (LocalToNetworkCommand.this.comeFromOpenDialog) break block15;
                                if (LocalToNetworkCommand.this.morphoFrameType == null) break block16;
                                String string = LocalToNetworkCommand.this.morphoFrameType;
                                LocalToNetworkCommand.this.morphoFrame;
                                if (!string.equals("searchResultFrame")) break block16;
                            }
                            refresh.execute(null);
                            return null;
                        }
                        if (LocalToNetworkCommand.this.morphoFrameType == null) return null;
                        String string = LocalToNetworkCommand.this.morphoFrameType;
                        LocalToNetworkCommand.this.morphoFrame;
                        if (!string.equals("dataPackageFrame")) return null;
                        this.refreshDataPackageFrame();
                        return null;
                    }
                    catch (MetacatUploadException mue2) {
                        Log.debug(0, mue2.getMessage());
                        return null;
                    }
                }
            }

            private void refreshDataPackageFrame() {
                String location = "localmetacat";
                this.dataPackage.openDataPackage(location, LocalToNetworkCommand.this.selectDocId, null, null, null);
                UIController.getInstance().removeWindow(frame);
                frame.dispose();
            }

            public void finished() {
                if (!this.refreshFlag) {
                    frame.setBusy(false);
                }
            }
        };
        worker.start();
    }
}

