/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.SwingWorker;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.query.CancelCommand;
import edu.ucsb.nceas.morpho.query.ExportDialog;
import edu.ucsb.nceas.morpho.query.OpenDialogBox;
import edu.ucsb.nceas.morpho.query.RefreshCommand;
import edu.ucsb.nceas.morpho.query.ResultPanel;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ExportCommand
implements Command {
    private ExportDialog exportDialog = null;
    private OpenDialogBox dialog = null;
    private MorphoFrame morphoFrame = null;
    private ResultPanel resultPane = null;
    DataPackageInterface dataPackage = null;
    public static final String ZIP = "ZIP";
    public static final String REGULAR = "REGULAR";
    public static final String TOEML2 = "TOEML2";
    private String ZIPEXTENSION = "zip";
    private String format = null;
    String selectDocId = null;
    boolean metacatLoc = false;
    boolean localLoc = false;
    String location = null;

    public ExportCommand(OpenDialogBox box, String myFormat, ExportDialog exportDialog) {
        this.exportDialog = exportDialog;
        this.dialog = box;
        if (myFormat.equals(ZIP)) {
            this.format = ZIP;
        } else if (myFormat.equals(REGULAR)) {
            this.format = REGULAR;
        } else if (myFormat.equals(TOEML2)) {
            this.format = TOEML2;
        } else {
            Log.debug(20, "Unkown export format!");
        }
    }

    public void execute(ActionEvent event) {
        new CancelCommand(this.exportDialog).execute(null);
        try {
            ServiceController services = ServiceController.getInstance();
            ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
            this.dataPackage = (DataPackageInterface)((Object)provider);
        }
        catch (ServiceNotHandledException snhe) {
            Log.debug(6, snhe.getMessage());
            return;
        }
        if (this.dialog != null) {
            this.morphoFrame = this.dialog.getParentFrame();
            this.resultPane = this.dialog.getResultPanel();
        } else {
            this.morphoFrame = UIController.getInstance().getCurrentActiveWindow();
            this.resultPane = RefreshCommand.getResultPanelFromMorphoFrame(this.morphoFrame);
        }
        if (this.resultPane != null) {
            this.selectDocId = this.resultPane.getSelectedId();
            this.metacatLoc = this.resultPane.getMetacatLocation();
            this.localLoc = this.resultPane.getLocalLocation();
            if (this.selectDocId != null && !this.selectDocId.equals("")) {
                if (this.dialog != null) {
                    this.dialog.setVisible(false);
                    this.dialog.dispose();
                    this.dialog = null;
                }
                this.doExport(this.selectDocId, this.morphoFrame);
            }
        } else {
            this.selectDocId = this.dataPackage.getDocIdFromMorphoFrame(this.morphoFrame);
            this.metacatLoc = this.dataPackage.isDataPackageInNetwork(this.morphoFrame);
            this.localLoc = this.dataPackage.isDataPackageInLocal(this.morphoFrame);
            if (this.selectDocId != null && !this.selectDocId.equals("")) {
                this.doExport(this.selectDocId, this.morphoFrame);
            }
        }
    }

    private void doExport(final String docid, final MorphoFrame frame) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                if (frame != null) {
                    frame.setBusy(true);
                }
                Log.debug(20, "Exporting dataset");
                if (ExportCommand.this.format.equals(ExportCommand.REGULAR)) {
                    ExportCommand.this.exportDataset(docid);
                } else if (ExportCommand.this.format.equals(ExportCommand.ZIP)) {
                    ExportCommand.this.exportDatasetToZip(docid);
                } else if (ExportCommand.this.format.equals(ExportCommand.TOEML2)) {
                    Log.debug(1, "No longer applicable!!!");
                }
                return null;
            }

            public void finished() {
                if (frame != null) {
                    frame.setBusy(false);
                }
            }
        };
        worker.start();
    }

    private void exportDataset(String id) {
        if (this.location == null) {
            this.location = this.getLocation();
        }
        if (this.location.trim().equals("")) {
            Log.debug(3, "Sorry, Package must be saved before it can be exported!");
            return;
        }
        String curdir = System.getProperty("user.dir");
        JFileChooser filechooser = new JFileChooser(curdir);
        filechooser.setDialogTitle("Export Datapackage to Selected Directory");
        filechooser.setApproveButtonText("Export");
        filechooser.setApproveButtonMnemonic('E');
        filechooser.setApproveButtonToolTipText("Choose a directory to export this Datapackage to.");
        filechooser.setFileSelectionMode(1);
        int result = this.dialog == null ? filechooser.showSaveDialog(this.morphoFrame) : filechooser.showSaveDialog(this.dialog);
        File exportDir = filechooser.getSelectedFile();
        if (result == 0) {
            this.dataPackage.export(id, exportDir.toString(), this.location);
        }
    }

    private void exportDatasetToEml2(String id) {
        String fileName;
        String curdir = System.getProperty("user.dir");
        curdir = curdir + System.getProperty("file.separator") + id + "_eml2.xml";
        File eml2File = new File(curdir);
        JFileChooser filechooser = new JFileChooser(curdir);
        filechooser.setFileSelectionMode(0);
        filechooser.setDialogTitle("Export Datapackage to EML2 File");
        filechooser.setApproveButtonText("Export");
        filechooser.setApproveButtonMnemonic('E');
        filechooser.setApproveButtonToolTipText("Choose a file name to export this Datapackage to.");
        filechooser.setSelectedFile(eml2File);
        int result = this.dialog == null ? filechooser.showSaveDialog(this.morphoFrame) : filechooser.showSaveDialog(this.dialog);
        File exportDir = filechooser.getSelectedFile();
        if (result == 0 && exportDir != null && (fileName = exportDir.getAbsolutePath()) != null) {
            String location = this.getLocation();
            this.dataPackage.exportToEml2(id, fileName, location);
        }
    }

    private void exportDatasetToZip(String id) {
        FileFilter zipFilter = new FileFilter(){

            public boolean accept(File f) {
                boolean flag = false;
                if (f != null) {
                    if (f.isDirectory()) {
                        flag = true;
                    } else {
                        String extention = this.getFileExtension(f);
                        if (extention != null && extention.equalsIgnoreCase(ExportCommand.this.ZIPEXTENSION)) {
                            flag = true;
                        }
                    }
                }
                return flag;
            }

            public String getDescription() {
                return "Zip(*.zip, *.ZIP)";
            }

            private String getFileExtension(File f) {
                String filename;
                int i;
                if (f != null && (i = (filename = f.getName()).lastIndexOf(".")) > 0 && i < filename.length() - 1) {
                    return filename.substring(i + 1).toLowerCase();
                }
                return null;
            }
        };
        String curdir = System.getProperty("user.dir");
        curdir = curdir + System.getProperty("file.separator") + id + ".zip";
        File zipFile = new File(curdir);
        JFileChooser filechooser = new JFileChooser(curdir);
        filechooser.addChoosableFileFilter(zipFilter);
        filechooser.setFileFilter(zipFilter);
        filechooser.setFileSelectionMode(0);
        filechooser.setDialogTitle("Export Datapackage to Selected Zip File");
        filechooser.setApproveButtonText("Export");
        filechooser.setApproveButtonMnemonic('E');
        filechooser.setApproveButtonToolTipText("Choose a file to export this Datapackage to.");
        filechooser.setSelectedFile(zipFile);
        int result = this.dialog == null ? filechooser.showSaveDialog(this.morphoFrame) : filechooser.showSaveDialog(this.dialog);
        File exportDir = filechooser.getSelectedFile();
        if (result == 0) {
            String fileName;
            String location = this.getLocation();
            if (exportDir != null && (fileName = exportDir.getAbsolutePath()) != null) {
                String fileExtention;
                String lowerCaseName = fileName.toLowerCase();
                if (!lowerCaseName.endsWith(fileExtention = "." + this.ZIPEXTENSION)) {
                    fileName = fileName + fileExtention;
                }
                Log.debug(30, "fileName is: " + fileName);
                this.dataPackage.exportToZip(id, fileName, location);
            }
        }
    }

    private String getLocation() {
        String location = null;
        location = this.metacatLoc && this.localLoc ? "localmetacat" : (this.metacatLoc && !this.localLoc ? "metacat" : (!this.metacatLoc && this.localLoc ? "local" : ""));
        return location;
    }
}

