/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.AccessionNumber;
import edu.ucsb.nceas.morpho.datapackage.Attribute;
import edu.ucsb.nceas.morpho.datapackage.Entity;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CodeImportSummary
extends AbstractUIPage {
    public final String pageID = "CODE_IMPORT_SUMMARY";
    public String nextPageID = "CODE_IMPORT_PAGE";
    public final String pageNumber = "13";
    public final String PACKAGE_WIZ_SUMMARY_TITLE = "New Data Package Wizard";
    public final String ENTITY_WIZ_SUMMARY_TITLE = "New Data Table Wizard";
    public final String SUBTITLE = "Summary";
    private JLabel desc1;
    private JLabel desc3;
    private JLabel desc4;
    private WizardContainerFrame mainWizFrame;
    private AbstractDataPackage adp = null;

    public CodeImportSummary(WizardContainerFrame mainWizFrame) {
        this.mainWizFrame = mainWizFrame;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(WidgetFactory.makeDefaultSpacer());
        this.add(WidgetFactory.makeDefaultSpacer());
        this.add(WidgetFactory.makeDefaultSpacer());
        this.desc1 = WidgetFactory.makeHTMLLabel("", 1);
        this.add(this.desc1);
        this.desc3 = WidgetFactory.makeHTMLLabel("<p>You can press the \"Finish\" button, or you can use the \"< Back\" button to return to previous pages and change the information you have added.</p>", 2);
        this.add(this.desc3);
        this.desc4 = WidgetFactory.makeHTMLLabel("", 2);
        this.add(this.desc4);
        this.desc1.setAlignmentX(-1.0f);
        this.desc3.setAlignmentX(-1.0f);
        this.desc4.setAlignmentX(-1.0f);
        this.add(Box.createVerticalGlue());
    }

    private String getLastParagraph() {
        String ID = this.mainWizFrame.getFirstPageID();
        if (ID == null) {
            return "";
        }
        int remaining = this.adp.getAttributeImportCount();
        if (remaining > 0) {
            this.desc3.setText("");
            return "<p>Proceed to define or import data tables for the other attributes</p>";
        }
        return "<p>All necessary imports have been completed</p>";
    }

    private String getActionName() {
        String ID = this.mainWizFrame.getFirstPageID();
        if (ID == null) {
            return "";
        }
        if (ID.equals("CODE_IMPORT_PAGE")) {
            return "import the codes for the attribute <i>" + this.adp.getCurrentImportAttributeName() + "</i>";
        }
        if (ID.equals("DATA_LOCATION")) {
            return "create your new data table";
        }
        return "create your new data package";
    }

    public void onLoadAction() {
        this.adp = this.getADP();
        if (this.adp == null) {
            Log.debug(10, "Error! Unable to obtain the ADP in CodeImportSummary page!");
            return;
        }
        String firstPageID = this.mainWizFrame.getFirstPageID();
        String prevID = this.mainWizFrame.getPreviousPageID();
        String currentAttrName = "";
        if (prevID.equals("CODE_DEFINITION")) {
            currentAttrName = this.adp.getCurrentImportAttributeName();
            if (this.adp.isCurrentImportNewTable()) {
                this.updateAttributeInNewTable();
            }
            this.adp.removeAttributeForImport();
            this.desc1.setText("<html><table width=\"100%\"><tr><td valign=\"top\" width=\"100%\"><font style=\"font-size: 9px;\" face=\"Sans-Serif\"><p> The new data table has been created and the codes for the attribute <i> " + currentAttrName + "</i> have been imported</p>" + "</font></td></tr></table></html>");
        } else if (prevID.equals("CODE_IMPORT_PAGE")) {
            String firstPage = this.mainWizFrame.getFirstPageID();
            currentAttrName = this.adp.getCurrentImportAttributeName();
            if (this.adp.isCurrentImportNewTable()) {
                this.updateAttributeInNewTable();
            }
            this.adp.removeAttributeForImport();
            this.desc1.setText("<html><table width=\"100%\"><tr><td valign=\"top\" width=\"100%\"><font style=\"font-size: 9px;\" face=\"Sans-Serif\"><p>All the information required to import the codes for the attribute <i> " + currentAttrName + "</i> has been collected</p>" + "</font></td></tr></table></html>");
        } else if (prevID.equals("TEXT_IMPORT_WIZARD")) {
            this.desc1.setText("<html><table width=\"100%\"><tr><td valign=\"top\" width=\"100%\"><font style=\"font-size: 9px;\" face=\"Sans-Serif\"><p>The new data table has been created successfully.</p></font></td></tr></table></html>");
            Entity[] arr = this.adp.getOriginalEntityArray();
            if (arr == null) {
                arr = this.adp.getEntityArray();
                if (arr == null) {
                    arr = new Entity[]{};
                }
                this.adp.setOriginalEntityArray(arr);
            }
            Node newDOM = this.mainWizFrame.collectDataFromPages();
            this.mainWizFrame.setDOMToReturn(null);
            if (this.adp == null) {
                this.adp = this.getADP();
            }
            Node entNode = null;
            String entityXpath = "";
            try {
                entityXpath = XMLUtilities.getTextNodeWithXPath((Node)this.adp.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='package']/entities").getNodeValue();
                NodeList entityNodes = XMLUtilities.getNodeListWithXPath((Node)newDOM, (String)entityXpath);
                entNode = entityNodes.item(0);
            }
            catch (Exception w) {
                Log.debug(5, "Error in trying to get entNode in ImportDataCommand");
            }
            Entity entityNode = new Entity(entNode);
            Log.debug(30, "Adding Entity object to AbstractDataPackage..");
            this.adp.addEntity(entityNode);
            Morpho morpho = Morpho.thisStaticInstance;
            AccessionNumber an = new AccessionNumber(morpho);
            String curid = this.adp.getAccessionNumber();
            String newid = null;
            newid = !curid.equals("") ? an.incRev(curid) : an.getNextId();
            this.adp.setAccessionNumber(newid);
            this.adp.setLocation("");
        }
        this.desc4.setText("<html><table width=\"100%\"><tr><td valign=\"top\" width=\"100%\"><font style=\"font-size: 9px;\" face=\"Sans-Serif\">" + this.getLastParagraph() + "</font></td></tr></table></html>");
        this.updateButtonsStatus();
    }

    private AbstractDataPackage getADP() {
        AbstractDataPackage dp = UIController.getInstance().getCurrentAbstractDataPackage();
        return dp;
    }

    private void updateAttributeInNewTable() {
        OrderedMap map = this.adp.getCurrentImportMap();
        this.adp = this.getADP();
        if (this.adp == null) {
            return;
        }
        String eName = this.adp.getCurrentImportEntityName();
        String aName = this.adp.getCurrentImportAttributeName();
        String xPath = this.adp.getCurrentImportXPath();
        int entityIndex = this.adp.getEntityIndex(eName);
        int attrIndex = this.adp.getAttributeIndex(entityIndex, aName);
        String firstKey = (String)map.keySet().iterator().next();
        if (!firstKey.startsWith("/attribute")) {
            OrderedMap newMap = new OrderedMap();
            for (String k : map.keySet()) {
                int idx1 = k.indexOf("/attributeList") + new String("/attributeList").length();
                String tk = k.substring(idx1 + 1);
                int idx2 = tk.indexOf("/");
                String newKey = "/attribute" + tk.substring(idx2);
                newMap.put((Object)newKey, (Object)((String)map.get((Object)k)));
            }
            map = newMap;
            xPath = "/attribute";
        }
        String oldID = this.adp.getAttributeID(entityIndex, attrIndex);
        map.put((Object)(xPath + "/@id"), (Object)oldID);
        Attribute attr = new Attribute(map);
        this.adp.insertAttribute(entityIndex, attr, attrIndex);
        this.adp.deleteAttribute(entityIndex, attrIndex + 1);
    }

    private void updateButtonsStatus() {
        if (this.adp != null && this.adp.getAttributeImportCount() > 0) {
            this.mainWizFrame.setButtonsStatus(true, true, false);
        } else {
            this.mainWizFrame.setButtonsStatus(true, false, true);
        }
    }

    private String getDataLocation() {
        String loc;
        String summaryText = WizardSettings.getSummaryText();
        if (summaryText != null && (summaryText.equals("You have chosen to describe data that is available online at: ") || summaryText.equals("In addition to describing your data, you have chosen to include it within the data package.")) && (loc = WizardSettings.getDataLocation()) != null) {
            return "<span style=\"text-decoration: underline;\">" + loc + "</span>";
        }
        return "";
    }

    public void onRewindAction() {
    }

    public boolean onAdvanceAction() {
        if (this.nextPageID.equals("CODE_IMPORT_PAGE")) {
            this.mainWizFrame.reInitializePageStack();
        }
        return true;
    }

    public OrderedMap getPageData() {
        return null;
    }

    public OrderedMap getPageData(String rootXPath) {
        throw new UnsupportedOperationException("getPageData(String rootXPath) Method Not Implemented");
    }

    public String getPageID() {
        return "CODE_IMPORT_SUMMARY";
    }

    public String getTitle() {
        if (this.mainWizFrame.getFirstPageID() == "DATA_LOCATION") {
            return "New Data Table Wizard";
        }
        return "New Data Package Wizard";
    }

    public String getSubtitle() {
        return "Summary";
    }

    public String getNextPageID() {
        return this.nextPageID;
    }

    public String getPageNumber() {
        return "13";
    }

    public boolean setPageData(OrderedMap data, String xPathRoot) {
        return false;
    }
}

