/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.editor;

import edu.ucsb.nceas.morpho.editor.NodeInfo;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

class XMLDisplayHandler
extends DefaultHandler
implements LexicalHandler {
    private Stack stack;
    private DefaultTreeModel treeModel;
    private int nodeCount;
    String docname;
    String publicId;
    String systemId;
    String text = "";

    public XMLDisplayHandler(DefaultTreeModel treeModel) {
        this.treeModel = treeModel;
        this.nodeCount = 0;
        this.stack = new Stack();
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getDocname() {
        return this.docname;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.text = "";
        NodeInfo ni = new NodeInfo(localName);
        for (int i = 0; i < atts.getLength(); ++i) {
            if (atts.getQName(i).equals("help")) {
                ni.setHelp(atts.getValue(i));
                continue;
            }
            if (atts.getQName(i).equals("editor")) {
                ni.setEditor(atts.getValue(i));
                ni.attr.put(atts.getQName(i), atts.getValue(i));
                continue;
            }
            if (atts.getQName(i).equals("cardinality")) {
                ni.setCardinality(atts.getValue(i));
                continue;
            }
            if (atts.getQName(i).equals("nodeVisLevel")) {
                String visLevel = atts.getValue(i);
                int nvl = new Integer(visLevel);
                ni.setNodeVisLevel(nvl);
                continue;
            }
            ni.attr.put(atts.getQName(i), atts.getValue(i));
        }
        this.setCardinality(ni);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(ni);
        if (this.nodeCount > 0) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.stack.peek();
            parentNode.add(newNode);
            this.treeModel.reload();
        } else {
            this.treeModel.setRoot(newNode);
        }
        ++this.nodeCount;
        this.stack.push(newNode);
    }

    private void setCardinality(NodeInfo ni) {
        String minOccurs = "";
        String maxOccurs = "";
        if (ni.attr.containsKey("minOccurs")) {
            minOccurs = (String)ni.attr.get("minOccurs");
        }
        if (ni.attr.containsKey("maxOccurs")) {
            maxOccurs = (String)ni.attr.get("maxOccurs");
        }
        if (minOccurs.equals("1") && maxOccurs.equals("1")) {
            ni.setCardinality("ONE");
        }
        if (minOccurs.equals("0") && maxOccurs.equals("1")) {
            ni.setCardinality("OPTIONAL");
        }
        if (minOccurs.equals("1") && !maxOccurs.equals("1")) {
            ni.setCardinality("ONE to MANY");
        }
        if (minOccurs.equals("0") && !maxOccurs.equals("1")) {
            ni.setCardinality("ZERO to MANY");
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.text.trim().length() > 0) {
            NodeInfo ni = new NodeInfo("#PCDATA");
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(ni);
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.stack.peek();
            parentNode.add(newNode);
            ni.setPCValue(this.text);
            this.text = "";
            this.treeModel.reload();
            ++this.nodeCount;
        }
        if (this.nodeCount > 1) {
            this.stack.pop();
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.text = this.text + new String(ch, start, length);
        if (this.text.length() > 1) {
            this.text = this.text.trim();
            if (this.text.equals("")) {
                this.text = " ";
            }
        }
        this.text = this.text.replace('\n', ' ');
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.docname = name;
        this.publicId = publicId;
        this.systemId = systemId;
    }

    public void endDTD() throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }
}

