/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.SwingWorker;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.DataPackageWizardPlugin;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddResearchProjectCommand
implements Command {
    private final String DATAPACKAGE_PROJECT_GENERIC_NAME = "project";
    private final String PROJECT_SUBTREE_NODENAME = "/project/";
    private Node existingProjectRoot;
    private AbstractDataPackage adp;
    private AbstractUIPage projectPage;

    public void execute(ActionEvent event) {
        DataPackageWizardInterface dpwPlugin = null;
        try {
            ServiceController sc = ServiceController.getInstance();
            dpwPlugin = (DataPackageWizardInterface)((Object)sc.getServiceProvider(DataPackageWizardInterface.class));
        }
        catch (ServiceNotHandledException se) {
            Log.debug(6, "unable to start project editor!");
            se.printStackTrace();
            return;
        }
        if (dpwPlugin == null) {
            return;
        }
        this.projectPage = dpwPlugin.getPage("PROJECT");
        this.adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (this.backupSubtreeAndShowProjectDialog()) {
            final MorphoFrame frame = UIController.getInstance().getCurrentActiveWindow();
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    if (frame != null) {
                        frame.setBusy(true);
                        frame.setEnabled(false);
                    }
                    try {
                        ArrayList<AbstractUIPage> pagesList = new ArrayList<AbstractUIPage>();
                        pagesList.add(AddResearchProjectCommand.this.projectPage);
                        DataPackageWizardPlugin.deleteExistingAndAddPageDataToDOM(UIController.getInstance().getCurrentAbstractDataPackage(), pagesList, "/project/", "project");
                    }
                    catch (Exception w) {
                        Log.debug(15, "Exception trying to modify project DOM: " + w);
                        w.printStackTrace();
                        Log.debug(5, "Unable to add project details!");
                    }
                    return null;
                }

                public void finished() {
                    if (frame != null) {
                        frame.setBusy(false);
                        frame.setEnabled(true);
                        UIController.showNewPackage(AddResearchProjectCommand.this.adp);
                    }
                }
            };
            worker.start();
        } else if (this.existingProjectRoot == null) {
            this.adp.deleteSubtree("project", 0);
        } else {
            this.adp.replaceSubtree("project", this.existingProjectRoot, 0);
        }
    }

    private boolean backupSubtreeAndShowProjectDialog() {
        this.existingProjectRoot = this.adp.getSubtree("project", 0);
        OrderedMap existingValuesMap = null;
        if (this.existingProjectRoot == null) {
            Log.debug(45, "No project subtree in the datapackage, so adding one...");
            DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
            Document doc = impl.createDocument("", "project", null);
            Element blankProjectRoot = doc.getDocumentElement();
            Element titleNode = doc.createElement("title");
            blankProjectRoot.appendChild(titleNode);
            Log.debug(45, "\n\nblankProjectRoot: " + XMLUtilities.getDOMTreeAsString((Node)blankProjectRoot));
            Node check = this.adp.insertSubtree("project", blankProjectRoot, 0);
            Log.debug(45, "\n\nadp: " + this.adp);
            if (check == null) {
                Log.debug(45, "** ERROR: AddResearchProjectCommand, trying to add blankProjectRoot");
                Log.debug(5, "** ERROR: Unable to open project editor");
                return false;
            }
        } else {
            Log.debug(45, "Found project subtree in the datapackage; reading...");
            existingValuesMap = XMLUtilities.getDOMTreeAsXPathMap((Node)this.existingProjectRoot);
        }
        Log.debug(45, "sending previous data to projectPage -\n\n" + existingValuesMap);
        boolean pageCanHandleAllData = this.projectPage.setPageData(existingValuesMap, "/project/");
        ModalDialog dialog = null;
        if (!pageCanHandleAllData) {
            UIController.getInstance().launchEditorAtSubtreeForCurrentFrame("project", 0);
            return false;
        }
        dialog = new ModalDialog(this.projectPage, UIController.getInstance().getCurrentActiveWindow(), 770, 570);
        return dialog.USER_RESPONSE == 10;
    }
}

