/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AddCreatorCommand
implements Command {
    private final String DATAPACKAGE_CREATOR_GENERIC_NAME = "creator";
    private List exsitingCreatorRoot;
    private Node creatorRoot;
    private AbstractDataPackage adp;
    private AbstractUIPage creatorPage;

    public void execute(ActionEvent event) {
        this.adp = UIController.getInstance().getCurrentAbstractDataPackage();
        this.exsitingCreatorRoot = this.adp.getSubtrees("creator");
        if (this.showCreatorDialog()) {
            try {
                this.insertCreator();
                UIController.showNewPackage(this.adp);
            }
            catch (Exception w) {
                Log.debug(15, "Exception trying to modify creator DOM: " + w);
                w.printStackTrace();
                Log.debug(5, "Unable to add creator details!");
            }
        } else {
            this.adp.deleteAllSubtrees("creator");
            if (!this.exsitingCreatorRoot.isEmpty()) {
                Object nextXPathObj = null;
                int count = this.exsitingCreatorRoot.size();
                DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
                for (int i = count - 1; i > -1; --i) {
                    this.creatorRoot = (Node)this.exsitingCreatorRoot.get(i);
                    Node check = this.adp.insertSubtree("creator", this.creatorRoot, 0);
                    if (check != null) {
                        Log.debug(45, "added new creator details to package...");
                        continue;
                    }
                    Log.debug(5, "** ERROR: Unable to add new creator details to package **");
                }
            }
        }
    }

    private boolean showCreatorDialog() {
        DataPackageWizardInterface dpwPlugin = null;
        try {
            ServiceController sc = ServiceController.getInstance();
            dpwPlugin = (DataPackageWizardInterface)((Object)sc.getServiceProvider(DataPackageWizardInterface.class));
        }
        catch (ServiceNotHandledException se) {
            Log.debug(6, se.getMessage());
            se.printStackTrace();
        }
        if (dpwPlugin == null) {
            return false;
        }
        this.creatorPage = dpwPlugin.getPage("PARTY_CREATOR_PAGE");
        OrderedMap existingValuesMap = new OrderedMap();
        List creatorList = this.adp.getSubtrees("creator");
        if (!creatorList.isEmpty()) {
            Iterator listIt = creatorList.iterator();
            Object nextObj = null;
            Object nextTempObj2 = null;
            String nextTempString = null;
            int count = 1;
            while (listIt.hasNext()) {
                nextObj = listIt.next();
                OrderedMap tempMap = XMLUtilities.getDOMTreeAsXPathMap((Node)nextObj);
                for (Object nextTempObj2 : tempMap.keySet()) {
                    nextTempString = nextTempObj2;
                    if (nextTempString == null) continue;
                    existingValuesMap.put((Object)("/creator[" + count + "]" + nextTempString.substring("creator".length() + 1, nextTempString.length())), tempMap.get(nextTempObj2));
                }
                ++count;
            }
        }
        Log.debug(45, "sending previous data to creatorPage -\n\n" + existingValuesMap);
        boolean pageCanHandleAllData = this.creatorPage.setPageData(existingValuesMap, null);
        ModalDialog dialog = null;
        if (!pageCanHandleAllData) {
            UIController.getInstance().launchEditorAtSubtreeForCurrentFrame("creator", 0);
            return false;
        }
        dialog = new ModalDialog(this.creatorPage, UIController.getInstance().getCurrentActiveWindow(), 770, 570);
        return dialog.USER_RESPONSE == 10;
    }

    private void insertCreator() {
        OrderedMap creatorMap;
        OrderedMap map = this.creatorPage.getPageData("/creator[");
        Log.debug(45, "\n insertCreator() Got creator details from creator page -\n" + map.toString());
        if (map == null) {
            Log.debug(5, "Unable to get creator details from input!");
            return;
        }
        if (map.isEmpty()) {
            Log.debug(45, "Deleting all creator details!");
        }
        DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
        this.adp.deleteAllSubtrees("creator");
        Iterator creatorIt = map.keySet().iterator();
        Object nextXPathObj2 = null;
        String nextXPath = null;
        HashMap<String, OrderedMap> creatorSetMap = new HashMap<String, OrderedMap>();
        while (creatorIt.hasNext()) {
            nextXPathObj2 = creatorIt.next();
            if (nextXPathObj2 == null) continue;
            nextXPath = nextXPathObj2;
            String temp = nextXPath.substring("creator".length() + 2, nextXPath.length());
            temp = temp.substring(0, temp.indexOf("]"));
            nextXPath = nextXPath.replaceFirst(temp, "1");
            if (creatorSetMap.containsKey(temp)) {
                creatorMap = (OrderedMap)creatorSetMap.get(temp);
                creatorMap.put((Object)nextXPath, map.get(nextXPathObj2));
                continue;
            }
            creatorMap = new OrderedMap();
            creatorMap.put((Object)nextXPath, map.get(nextXPathObj2));
            creatorSetMap.put(temp, creatorMap);
        }
        for (Object nextXPathObj2 : creatorSetMap.keySet()) {
            creatorMap = (OrderedMap)creatorSetMap.get(nextXPathObj2);
            Document doc = impl.createDocument("", "creator", null);
            this.creatorRoot = doc.getDocumentElement();
            try {
                XMLUtilities.getXPathMapAsDOMTree((Map)creatorMap, (Node)this.creatorRoot);
            }
            catch (TransformerException w) {
                Log.debug(5, "Unable to add creator details to package!");
                Log.debug(15, "TransformerException (" + w + ") calling " + "XMLUtilities.getXPathMapAsDOMTree(map, creatorRoot) with \n" + "map = " + map + " and creatorRoot = " + this.creatorRoot);
                return;
            }
            Node check = this.adp.insertSubtree("creator", this.creatorRoot, 0);
            if (check != null) {
                Log.debug(45, "added new creator details to package...");
                continue;
            }
            Log.debug(5, "** ERROR: Unable to add new creator details to package **");
        }
    }
}

