/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import com.arbortext.catalog.CatalogEntityResolver;
import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.PackageUtil;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.util.Log;
import java.io.File;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AccessionNumber {
    private Morpho morpho;
    private ConfigXML profile;

    public AccessionNumber(Morpho morpho) {
        this.morpho = morpho;
        this.profile = morpho.getProfile();
    }

    public synchronized String getNextId() {
        String scope = this.profile.get("scope", 0);
        String lastidS = this.profile.get("lastId", 0);
        int lastid = new Integer(lastidS);
        String separator = this.profile.get("separator", 0);
        if (scope.trim().equals("USERNAME")) {
            String username;
            scope = username = this.profile.get("username", 0);
        }
        String identifier = scope + separator + lastid;
        String s = "" + ++lastid;
        if (!this.profile.set("lastId", 0, s)) {
            Log.debug(1, "Error incrementing the accession number id");
            return null;
        }
        this.profile.save();
        return identifier + ".1";
    }

    public String incRev(String id) {
        return this.incRev(id, true);
    }

    public String incRev(String id, boolean addOne) {
        String sep = this.profile.get("separator", 0);
        int count = 0;
        for (int i = 0; i < id.length(); ++i) {
            if (id.charAt(i) != sep.trim().charAt(0)) continue;
            ++count;
        }
        if (count == 1) {
            return id + ".1";
        }
        int revIndex = id.lastIndexOf(".");
        String revNumStr = id.substring(revIndex + 1, id.length());
        Integer revNum = new Integer(revNumStr);
        int rev = revNum;
        if (addOne) {
            ++rev;
        }
        return id.substring(0, revIndex) + "." + rev;
    }

    public String incRevInTriples(File xmlfile, String oldid, String newid) {
        Vector<String> oldids = new Vector<String>();
        oldids.addElement(oldid);
        Vector<String> newids = new Vector<String>();
        newids.addElement(newid);
        return this.incRevInTriples(xmlfile, oldids, newids);
    }

    public String incRevInTriples(File xmlfile, Vector oldid, Vector newid) {
        Document doc;
        System.out.println("oldid: " + oldid.toString() + " newid: " + newid.toString());
        DocumentBuilder parser = Morpho.createDomParser();
        CatalogEntityResolver cer = new CatalogEntityResolver();
        try {
            AccessionNumber accessionNumber = this;
            ConfigXML config = accessionNumber.morpho.getConfiguration();
            String catalogPath = config.get("local_catalog_path", 0);
            doc = PackageUtil.getDoc(xmlfile, catalogPath);
        }
        catch (Exception e) {
            Log.debug(0, "error parsing " + xmlfile.getPath() + " : " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        NodeList tripleList = null;
        String triplePath = "//triple";
        try {
            tripleList = XPathAPI.selectNodeList((Node)doc, (String)triplePath);
        }
        catch (TransformerException se) {
            System.err.println("incRevInTriples() : parse threw: " + se.toString());
        }
        for (int i = 0; i < tripleList.getLength(); ++i) {
            Node triple = tripleList.item(i);
            NodeList children = triple.getChildNodes();
            Object sub = null;
            Object rel = null;
            Object obj = null;
            if (children.getLength() <= 2) continue;
            for (int j = 0; j < children.getLength(); ++j) {
                String nodeval;
                Node childNode = children.item(j);
                String nodename = childNode.getNodeName().trim().toUpperCase();
                if (!nodename.equals("SUBJECT") && !nodename.equals("OBJECT")) continue;
                try {
                    nodeval = childNode.getFirstChild().getNodeValue().trim();
                }
                catch (NullPointerException npe) {
                    continue;
                }
                if (!oldid.contains(nodeval.trim())) continue;
                String newidS = "";
                for (int k = 0; k < newid.size(); ++k) {
                    newidS = (String)newid.elementAt(k);
                    if (nodeval.trim().equals(oldid.elementAt(k))) break;
                }
                System.out.println("replacing: " + nodeval + " with " + newidS);
                childNode.getFirstChild().setNodeValue(newidS);
            }
        }
        return PackageUtil.printDoctype(doc) + PackageUtil.print(doc.getDocumentElement());
    }

    public Vector getParts(String id) {
        String separator = this.profile.get("separator", 0);
        String scope = id.substring(0, id.indexOf(separator));
        String idpart = id.substring(id.indexOf(separator) + 1, id.lastIndexOf(separator));
        String rev = id.substring(id.lastIndexOf(separator) + 1, id.length());
        Vector<String> v = new Vector<String>();
        v.addElement(scope);
        v.addElement(idpart);
        v.addElement(rev);
        v.addElement(separator);
        return v;
    }

    public String getIdNoRev(String fullId) {
        Vector idVec = this.getParts(fullId);
        String scope = (String)idVec.elementAt(0);
        String id = (String)idVec.elementAt(1);
        String rev = (String)idVec.elementAt(2);
        String sep = (String)idVec.elementAt(3);
        return scope + sep + id;
    }

    public String getDocIdFromInternalFileName(String internalFileName) {
        String id = null;
        if (internalFileName != null) {
            id = this.profile.get("scope", 0) + this.profile.get("separator", 0) + internalFileName;
        }
        return id;
    }
}

