/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.util;

import edu.ucsb.nceas.morpho.util.SortableJTable;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class SortableTableHeaderCellRenderer
extends DefaultTableCellRenderer {
    private ImageIcon NONSORTED = null;
    private ImageIcon ASCENDING = new ImageIcon(this.getClass().getResource("ascendingArrow.gif"));
    private ImageIcon DECENDING = new ImageIcon(this.getClass().getResource("decendingArrow.gif"));
    private static final int FONTSIZE = 12;

    public SortableTableHeaderCellRenderer() {
        this.setFont(new Font("Dialog", 0, 12));
        this.setHorizontalTextPosition(2);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        int indexOfSortedColumn = -1;
        boolean sorted = false;
        String order = null;
        SortableJTable sortTable = null;
        ImageIcon shownIcon = null;
        if (table instanceof SortableJTable) {
            sortTable = (SortableJTable)table;
            sorted = sortTable.getSorted();
            if (!sorted) {
                this.setIcon(this.NONSORTED);
            } else {
                indexOfSortedColumn = sortTable.getIndexOfSortedColumn();
                order = sortTable.getOrderOfSortedColumn();
                shownIcon = order.equals("ascending") ? this.ASCENDING : this.DECENDING;
                if (col == indexOfSortedColumn) {
                    this.setIcon(shownIcon);
                } else {
                    this.setIcon(this.NONSORTED);
                }
            }
        }
        if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }
}

