/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.query.CellComparator;
import edu.ucsb.nceas.morpho.query.Query;
import edu.ucsb.nceas.morpho.query.ResultsetHandler;
import edu.ucsb.nceas.morpho.query.SynchronizeVector;
import edu.ucsb.nceas.morpho.util.ColumnSortableTableModel;
import edu.ucsb.nceas.morpho.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ResultSet
extends AbstractTableModel
implements ColumnSortableTableModel {
    private Query savedQuery = null;
    protected Vector resultsVector = null;
    private Vector returnFields;
    private Morpho morpho = null;
    private ConfigXML config = null;
    private Stack elementStack = null;
    private String[] headers;
    private String docid;
    private String docname;
    private String doctype;
    private String createdate;
    private String updatedate;
    private String paramName;
    private Hashtable params;
    private Hashtable triple;
    private Vector tripleList;
    private Hashtable mapColumnNameAndVectorIndex = new Hashtable();
    public static ImageIcon localIcon = null;
    public static ImageIcon metacatIcon = null;
    public static ImageIcon blankIcon = null;
    public static ImageIcon packageIcon = null;
    public static ImageIcon packageDataIcon = null;
    protected static final int PACKAGEICONINDEX = 0;
    protected static final int TITLEINDEX = 1;
    protected static final int SURNAMEINDEX = 2;
    protected static final int KEYWORDSINDEX = 3;
    protected static final int CREATEDATEINDEX = 4;
    protected static final int UPDATEDATEINDEX = 5;
    protected static final int DOCIDINDEX = 6;
    protected static final int DOCNAMEINDEX = 7;
    protected static final int DOCTYPEINDEX = 8;
    protected static final int ISLOCALINDEX = 9;
    protected static final int ISMETACATINDEX = 10;
    protected static final int TRIPLEINDEX = 11;
    private static final int HEIGHTFACTOR = 2;
    private String accumulatedCharacters = null;

    public ResultSet(Query query, String source, Vector vec, Morpho morpho) {
        this.initIcons();
        this.init(query, source, morpho);
        this.initMapping();
        this.resultsVector = vec;
    }

    public ResultSet(Query query, String source, InputStream resultsXMLStream, Morpho morpho) {
        this.initIcons();
        this.init(query, source, morpho);
        this.initMapping();
        Log.debug(30, "(2.41) Creating result set ...");
        this.resultsVector = new Vector();
        XMLReader parser = null;
        try {
            ResultsetHandler handler = new ResultsetHandler(morpho, source);
            parser = Morpho.createSaxParser(handler, null);
            Log.debug(30, "(2.43) Creating result set ...");
            parser.parse(new InputSource(new InputStreamReader(resultsXMLStream)));
            SynchronizeVector parseResult = handler.getSynchronizeVector();
            this.resultsVector = parseResult.getVector();
            Log.debug(30, "(2.44) Creating result set ...");
        }
        catch (Exception e) {
            Log.debug(30, "(2.431) Exception creating result set ...");
            Log.debug(6, "(2.432) " + e.toString());
            Log.debug(30, "(2.433) Exception is: " + e.getClass().getName());
        }
    }

    private void init(Query query, String source, Morpho morpho) {
        this.savedQuery = query;
        this.morpho = morpho;
        this.createTableHeader();
    }

    private void initIcons() {
        localIcon = new ImageIcon(this.getClass().getResource("local-package-small.png"));
        localIcon.setDescription("Stored on my computer");
        metacatIcon = new ImageIcon(this.getClass().getResource("network-package-small.png"));
        metacatIcon.setDescription("Stored on network");
        blankIcon = new ImageIcon(this.getClass().getResource("blank.gif"));
        blankIcon.setDescription("Blank");
        packageIcon = new ImageIcon(this.getClass().getResource("metadata-only-small.png"));
        packageIcon.setDescription("Documentation only");
        packageDataIcon = new ImageIcon(this.getClass().getResource("metadata+data-small.png"));
        packageDataIcon.setDescription("Data & documentation");
    }

    private void initMapping() {
        this.mapColumnNameAndVectorIndex.put(" ", new Integer(0));
        this.mapColumnNameAndVectorIndex.put("Title", new Integer(1));
        this.mapColumnNameAndVectorIndex.put("Document ID", new Integer(6));
        this.mapColumnNameAndVectorIndex.put("Surname", new Integer(2));
        this.mapColumnNameAndVectorIndex.put("Keywords", new Integer(3));
        this.mapColumnNameAndVectorIndex.put("Last Modified", new Integer(5));
        this.mapColumnNameAndVectorIndex.put("Local", new Integer(9));
        this.mapColumnNameAndVectorIndex.put("Net", new Integer(10));
    }

    public Vector getResultsVector() {
        return this.resultsVector;
    }

    public void setResultsVector(Vector rv) {
        this.resultsVector = rv;
    }

    public int getColumnCount() {
        return this.headers.length;
    }

    public int getRowCount() {
        return this.resultsVector.size();
    }

    public int getRowHeight() {
        if (localIcon != null) {
            int height = localIcon.getIconHeight() * 2;
            return height;
        }
        return 1;
    }

    public String getColumnName(int col) {
        return this.headers[col];
    }

    public Object getValueAt(int row, int col) {
        Object value = null;
        return value;
    }

    public Morpho getMorpho() {
        return this.morpho;
    }

    public void setHeader(String[] anotherHeader) {
        this.headers = new String[anotherHeader.length];
        for (int i = 0; i < this.headers.length; ++i) {
            this.headers[i] = anotherHeader[i];
        }
    }

    public void setMapping(Hashtable hash) {
        this.mapColumnNameAndVectorIndex = hash;
    }

    public int lookupResultsVectorIndex(int headerIndex) {
        String head = this.headers[headerIndex];
        return this.lookupResultsVectorIndex(head);
    }

    public int lookupResultsVectorIndex(String headName) {
        int vectorIndex = -1;
        Object obj = this.mapColumnNameAndVectorIndex.get(headName);
        if (obj != null) {
            Integer value = (Integer)obj;
            vectorIndex = value;
        }
        return vectorIndex;
    }

    public Class getColumnClass(int c) {
        Class<?> currentClass = null;
        try {
            currentClass = this.getValueAt(0, c).getClass();
        }
        catch (NullPointerException npe) {
            try {
                currentClass = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        return currentClass;
    }

    private void createTableHeader() {
        int cnt = this.returnFields == null ? 0 : this.returnFields.size();
        cnt = 3;
        int numberFixedHeaders = 5;
        this.headers = new String[numberFixedHeaders + cnt];
        this.headers[0] = " ";
        this.headers[1] = "Title";
        this.headers[2] = "Document ID";
        this.headers[3] = "Surname";
        this.headers[4] = "Keywords";
        this.headers[5] = "Last Modified";
        this.headers[6] = "Local";
        this.headers[7] = "Net";
    }

    public Query getQuery() {
        return this.savedQuery;
    }

    public void setQuery(Query query) {
        this.savedQuery = query;
    }

    public void openResultRecord(int row) {
        try {
            Vector rowVector = (Vector)this.resultsVector.elementAt(row);
            this.openResultRecord(rowVector);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            Log.debug(1, "array index out of bounds");
        }
    }

    protected void openResultRecord(Vector rowVector) {
        int numHeaders = this.headers.length;
        String docid = null;
        boolean openLocal = false;
        boolean openMetacat = false;
        Vector rowTriples = null;
        try {
            docid = (String)rowVector.elementAt(6);
            openLocal = (Boolean)rowVector.elementAt(9);
            openMetacat = (Boolean)rowVector.elementAt(10);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            Log.debug(1, "array index out of bounds");
            docid = null;
        }
        catch (NullPointerException npe) {
            Log.debug(1, "null pointer exception");
            docid = null;
        }
        String location = "";
        if (openLocal) {
            location = "local";
        }
        if (openMetacat) {
            location = location + "metacat";
        }
        location = location.trim();
        try {
            ServiceController services = ServiceController.getInstance();
            ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
            DataPackageInterface dataPackage = (DataPackageInterface)((Object)provider);
            dataPackage.openDataPackage(location, docid, rowTriples, null, null);
        }
        catch (ServiceNotHandledException snhe) {
            Log.debug(6, snhe.getMessage());
        }
    }

    public void merge(ResultSet r2) {
        if (r2 != null) {
            Vector r2Rows = r2.getResultsVector();
            this.merge(r2Rows);
        }
    }

    public void merge(Vector r2Rows) {
        String currentDocid;
        Hashtable<String, Integer> docidList = new Hashtable<String, Integer>();
        int numColumns = this.getColumnCount();
        for (int i = 0; i < this.getRowCount(); ++i) {
            Vector rowVector = (Vector)this.resultsVector.elementAt(i);
            currentDocid = (String)rowVector.elementAt(6);
            docidList.put(currentDocid, new Integer(i));
        }
        Enumeration ee = r2Rows.elements();
        while (ee.hasMoreElements()) {
            Vector row = (Vector)ee.nextElement();
            currentDocid = (String)row.elementAt(6);
            if (docidList.containsKey(currentDocid)) {
                int rowIndex = (Integer)docidList.get(currentDocid);
                Vector originalRow = (Vector)this.resultsVector.elementAt(rowIndex);
                ImageIcon currentIcon = (ImageIcon)originalRow.elementAt(0);
                if (currentIcon.getDescription().equals(packageDataIcon.getDescription())) {
                    originalRow.setElementAt(packageDataIcon, 0);
                } else {
                    originalRow.setElementAt(packageIcon, 0);
                }
                originalRow.setElementAt(new Boolean(true), 9);
                originalRow.setElementAt(new Boolean(true), 10);
                continue;
            }
            this.resultsVector.addElement(row);
        }
    }

    public Morpho getFramework() {
        return this.morpho;
    }

    public void sortTableByColumn(int col, String order) {
        this.sortVector(this.resultsVector, col, order);
    }

    protected void sortVector(Vector vector, int col, String order) {
        boolean sort = false;
        boolean ascending = false;
        if (order.equals("ascending")) {
            sort = true;
            ascending = true;
        } else if (order.equals("decending")) {
            sort = true;
            ascending = false;
        } else if (order.equals("nonodered")) {
            sort = false;
        }
        if (sort) {
            int resultColIndex = this.lookupResultsVectorIndex(col);
            Collections.sort(vector, new CellComparator(resultColIndex, ascending));
        }
    }
}

