/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.SwingWorker;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.query.OpenDialogBox;
import edu.ucsb.nceas.morpho.query.RefreshCommand;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;

public class NetworkToLocalCommand
implements Command {
    private JDialog synchronizeDialog = null;
    private OpenDialogBox openDialog = null;
    private MorphoFrame morphoFrame = null;
    private String morphoFrameType = null;
    String selectDocId = null;
    private boolean inLocal = false;
    private boolean inNetwork = false;
    private boolean comeFromOpenDialog = false;

    public NetworkToLocalCommand(OpenDialogBox myOpenDialog, JDialog mySynDialog, MorphoFrame myFrame, String frameType, String selectId, boolean myInLocal, boolean myInNetwork) {
        if (myOpenDialog != null) {
            this.openDialog = myOpenDialog;
            this.comeFromOpenDialog = true;
        } else {
            this.morphoFrameType = frameType;
        }
        this.synchronizeDialog = mySynDialog;
        this.morphoFrame = myFrame;
        this.selectDocId = selectId;
        this.inLocal = myInLocal;
        this.inNetwork = myInNetwork;
    }

    public void execute(ActionEvent event) {
        if (this.selectDocId != null && !this.selectDocId.equals("") && !this.inLocal && this.inNetwork) {
            if (this.synchronizeDialog != null) {
                this.synchronizeDialog.setVisible(false);
                this.synchronizeDialog.dispose();
                this.synchronizeDialog = null;
            }
            this.doDownload(this.selectDocId, this.morphoFrame, this.openDialog, this.comeFromOpenDialog);
        }
    }

    private void doDownload(final String docid, final MorphoFrame frame, final OpenDialogBox open, final boolean hasOpen) {
        SwingWorker worker = new SwingWorker(){
            DataPackageInterface dataPackage;
            boolean refreshFlag = false;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object construct() {
                block5: {
                    RefreshCommand refresh;
                    block4: {
                        try {
                            ServiceController services = ServiceController.getInstance();
                            ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
                            this.dataPackage = (DataPackageInterface)((Object)provider);
                        }
                        catch (ServiceNotHandledException snhe) {
                            Log.debug(6, "Error in upload");
                            return null;
                        }
                        frame.setBusy(true);
                        refresh = null;
                        refresh = hasOpen ? new RefreshCommand(open) : new RefreshCommand(frame);
                        Log.debug(30, "Downloading package. (id: " + docid);
                        this.dataPackage.download(docid);
                        this.refreshFlag = true;
                        if (NetworkToLocalCommand.this.comeFromOpenDialog) break block4;
                        if (NetworkToLocalCommand.this.morphoFrameType == null) break block5;
                        String string = NetworkToLocalCommand.this.morphoFrameType;
                        NetworkToLocalCommand.this.morphoFrame;
                        if (!string.equals("searchResultFrame")) break block5;
                    }
                    refresh.execute(null);
                    return null;
                }
                if (NetworkToLocalCommand.this.morphoFrameType == null) return null;
                String string = NetworkToLocalCommand.this.morphoFrameType;
                NetworkToLocalCommand.this.morphoFrame;
                if (!string.equals("dataPackageFrame")) return null;
                this.refreshDataPackageFrame();
                return null;
            }

            private void refreshDataPackageFrame() {
                String location = "localmetacat";
                this.dataPackage.openDataPackage(location, NetworkToLocalCommand.this.selectDocId, null, null, null);
                UIController.getInstance().removeWindow(frame);
                frame.dispose();
            }

            public void finished() {
                if (!this.refreshFlag) {
                    frame.setBusy(false);
                }
            }
        };
        worker.start();
    }
}

