/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageSubPanelAPI;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.TaxonHierarchy;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.TaxonLevel;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ParentTaxaPanel
extends JPanel
implements WizardPageSubPanelAPI {
    public static final int DIALOG_WIDTH = 450;
    public static final int DIALOG_HEIGHT = 500;
    private JLabel headLabel;
    private CustomList hierList = null;
    private boolean editedAlready = false;

    ParentTaxaPanel() {
        this.init();
    }

    private void init() {
        JPanel sub = WidgetFactory.makePanel();
        sub.setLayout(new BoxLayout(sub, 1));
        JLabel info = this.getLabel("Enter information about the Taxon");
        sub.add(WidgetFactory.makeDefaultSpacer());
        this.headLabel = WidgetFactory.makeLabel("Enter the Taxonomic Hierarchy (in descending order):", false, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.add((Component)this.headLabel, "Center");
        String[] colNames2 = new String[]{"Rank", "Name", "Common Name(s)"};
        Object[] jtf2 = new JTextField[3];
        for (int i = 0; i < 3; ++i) {
            jtf2[i] = new JTextField();
        }
        this.hierList = WidgetFactory.makeList(colNames2, jtf2, 0, true, false, false, true, true, true);
        JPanel hierPanel = new JPanel(new BorderLayout());
        hierPanel.add((Component)this.hierList, "Center");
        sub.add(labelPanel);
        sub.add(WidgetFactory.makeDefaultSpacer());
        sub.add(hierPanel);
        sub.add(WidgetFactory.makeDefaultSpacer());
        this.setLayout(new BorderLayout());
        this.add((Component)sub, "Center");
    }

    public void setHierarchy(TaxonHierarchy hier) {
        Iterator it = hier.iterator();
        while (it.hasNext()) {
            TaxonLevel level = (TaxonLevel)it.next();
            String rank = level.getRank();
            if (rank.trim().equals("")) continue;
            String name = level.getName();
            String commonName = level.getCommonNamesDisplayString();
            ArrayList<String> row = new ArrayList<String>();
            row.add(rank);
            row.add(name);
            row.add(commonName);
            this.hierList.addRow(row);
        }
    }

    public TaxonHierarchy getHierarchy() {
        Vector<TaxonLevel> vec = new Vector<TaxonLevel>();
        List rows = this.hierList.getListOfRowLists();
        for (List row : rows) {
            String rank = (String)row.get(0);
            String name = (String)row.get(1);
            String[] commonNames = null;
            String cn = (String)row.get(2);
            if (cn != null) {
                commonNames = this.parseCommonNames(cn);
            }
            TaxonLevel level = new TaxonLevel(rank, name, commonNames);
            vec.add(level);
        }
        TaxonHierarchy hier = new TaxonHierarchy(vec);
        return hier;
    }

    private String[] parseCommonNames(String names) {
        ArrayList<String> t = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(names, ",");
        while (st.hasMoreTokens()) {
            t.add(st.nextToken().trim());
        }
        if (t.size() == 0) {
            return null;
        }
        String[] ret = new String[t.size()];
        ret = t.toArray(ret);
        return ret;
    }

    public void setHierarchy1(List row) {
        if (row == null || row.size() < 6) {
            return;
        }
        String ancestor = (String)row.get(0);
        String rank1 = (String)row.get(1);
        String name1 = (String)row.get(2);
        String rank2 = (String)row.get(3);
        String name2 = (String)row.get(4);
        String commonName = (String)row.get(5);
        if (!this.editedAlready) {
            this.hierList.removeAllRows();
            int r1 = WizardSettings.getIndexOfTaxonRank(rank1);
            int r2 = WizardSettings.getIndexOfTaxonRank(rank2);
            int max = r1 >= r2 ? r1 : r2;
            List hier = WizardSettings.getTaxonHierarchyTillIndex(max);
            for (String r : hier) {
                String v = "";
                String cn = "";
                if (r.equals(rank1)) {
                    v = name1;
                } else if (r.equals(rank2)) {
                    v = name2;
                    cn = commonName;
                }
                ArrayList<String> newRow = new ArrayList<String>();
                newRow.add(r);
                newRow.add(v);
                newRow.add(cn);
                this.hierList.addRow(newRow);
            }
        } else {
            List rows = this.hierList.getListOfRowLists();
            int size = rows.size();
            if (size < 1) {
                return;
            }
            if (size >= 2) {
                List pr = (List)rows.get(size - 2);
                pr.set(0, rank1);
                pr.set(1, name1);
                this.hierList.replaceRow(size - 2, pr);
            }
            ArrayList<String> cr = new ArrayList<String>();
            cr.add(rank2);
            cr.add(name2);
            cr.add(commonName);
            this.hierList.replaceRow(size - 1, cr);
        }
    }

    public List getSurrogate() {
        ArrayList<String> res = new ArrayList<String>();
        String cn = "";
        List rows = this.hierList.getListOfRowLists();
        if (rows.size() >= 2) {
            Iterator it = rows.iterator();
            for (int i = 0; i < rows.size() - 2; ++i) {
                String nm;
                List r = (List)it.next();
                String rk = (String)r.get(0);
                if (rk == null || rk.trim().equals("") || (nm = (String)r.get(1)) == null || nm.trim().equals("")) continue;
                cn = cn + rk + "=" + nm + ";";
            }
            res.add(cn);
            List pl = (List)it.next();
            res.add((String)pl.get(0));
            res.add((String)pl.get(1));
            List cl = (List)it.next();
            res.add((String)cl.get(0));
            res.add((String)cl.get(1));
            res.add((String)cl.get(2));
        } else {
            if (rows.size() == 0) {
                return res;
            }
            List cr = (List)rows.get(0);
            String rank = (String)cr.get(0);
            int rankIndex = WizardSettings.getIndexOfTaxonRank(rank);
            if (rankIndex == 6) {
                res.add("");
                res.add("");
                res.add("");
                res.add(rank);
                res.add((String)cr.get(1));
                res.add((String)cr.get(2));
            } else {
                res.add("");
                res.add(rank);
                res.add((String)cr.get(1));
                res.add("");
                res.add("");
                res.add("");
            }
        }
        this.editedAlready = true;
        return res;
    }

    public boolean hasBeenEdited() {
        return this.editedAlready;
    }

    public void onLoadAction() {
    }

    public boolean onAdvanceAction() {
        boolean dataPresent = false;
        ArrayList<String> ranks = new ArrayList<String>();
        List rows = this.hierList.getListOfRowLists();
        for (List row : rows) {
            String t = (String)row.get(0);
            String t1 = (String)row.get(1);
            if (ranks.contains(t)) {
                JOptionPane.showMessageDialog(this, "Invalid hierarchy! Two taxonomic levels cannot have the same taxon rank", "Error", 0);
                return false;
            }
            ranks.add(t);
            if (t.trim().equals("") || t1.trim().equals("")) continue;
            dataPresent = true;
        }
        if (!dataPresent) {
            JOptionPane.showMessageDialog(this, "Atleast one taxonomic level must be defined", "Error", 0);
            return false;
        }
        short[] conditions = new short[]{10, 10, 30};
        this.hierList.deleteEmptyRows((short)51, conditions);
        return this.hierList.getRowCount() != 0;
    }

    public boolean validateUserInput() {
        boolean ret = this.onAdvanceAction();
        if (!ret) {
            WidgetFactory.hiliteComponent(this.headLabel);
        } else {
            WidgetFactory.unhiliteComponent(this.headLabel);
        }
        return ret;
    }

    public OrderedMap getPanelData(String xPathRoot) {
        return null;
    }

    public void setPanelData(String xPathRoot, OrderedMap map) {
    }

    private JLabel getLabel(String text) {
        if (text == null) {
            text = "";
        }
        JLabel label = new JLabel(text);
        label.setAlignmentX(1.0f);
        label.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        label.setBorder(BorderFactory.createMatteBorder(1, 10, 1, 3, (Color)null));
        return label;
    }

    public Object clonePanel() {
        ParentTaxaPanel panel = new ParentTaxaPanel();
        for (List row : this.hierList.getListOfRowLists()) {
            panel.hierList.addRow(row);
        }
        return panel;
    }
}

