/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.DataPackageFactory;
import edu.ucsb.nceas.morpho.editor.DocFrame;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardListener;
import edu.ucsb.nceas.morpho.plugins.PluginInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceExistsException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageLibrary;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.PartyPage;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.xml.transform.TransformerException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataPackageWizardPlugin
implements PluginInterface,
ServiceProvider,
DataPackageWizardInterface {
    public void initialize(Morpho morpho) {
        try {
            ServiceController services = ServiceController.getInstance();
            services.addService(DataPackageWizardInterface.class, this);
            Log.debug(20, "Service added: DataPackageWizardInterface.");
        }
        catch (ServiceExistsException see) {
            Log.debug(6, "Service registration failed: DataPackageWizardInterface");
            Log.debug(6, see.toString());
        }
    }

    public void startPackageWizard(DataPackageWizardListener listener) {
        boolean isRunning = UIController.getInstance().isWizardRunning();
        if (isRunning) {
            JOptionPane.showConfirmDialog(null, "Sorry, only one instance of the Data Package Wizard can be running at a time!", "Wizard already running", -1, 2);
            return;
        }
        AbstractDataPackage tempDataPackage = DataPackageFactory.getDataPackage(this.getNewEmptyDataPackageDOM("<eml:eml    packageId=\"\" system=\"knb\"    xmlns:eml=\"eml://ecoinformatics.org/eml-2.0.1\"    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"    xsi:schemaLocation=\"eml://ecoinformatics.org/eml-2.0.1 eml.xsd\">    <dataset>    <title> </title>    <creator> </creator>   <coverage><taxonomicCoverage><taxonomicSystem><classificationSystem>                             <classificationSystemCitation><title> </title>            </classificationSystemCitation> </classificationSystem>            </taxonomicSystem> </taxonomicCoverage></coverage>   <project><title> </title></project>   </dataset> </eml:eml>"));
        if (tempDataPackage == null) {
            return;
        }
        UIController.getInstance().setWizardIsRunning(tempDataPackage);
        this.startWizardAtPage("INTRODUCTION", true, listener, "New Data Package Wizard");
    }

    private Node getNewEmptyDataPackageDOM(String DocText) {
        Node rootNode = null;
        try {
            rootNode = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)new StringReader(DocText));
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.debug(5, "unexpected error trying to create new XML document");
            return null;
        }
        return rootNode;
    }

    public void startEntityWizard(DataPackageWizardListener listener) {
        this.startWizardAtPage("DATA_LOCATION", false, listener, "New Data Table Wizard");
    }

    public void startCodeDefImportWizard(DataPackageWizardListener listener) {
        this.startWizardAtPage("CODE_IMPORT_PAGE", false, listener, "Import Code Definitions");
    }

    private void startWizardAtPage(String pageID, boolean showPageCount, DataPackageWizardListener listener, String frameTitle) {
        WizardContainerFrame dpWiz = new WizardContainerFrame();
        dpWiz.setDataPackageWizardListener(listener);
        dpWiz.setBounds(100, 100, 800, 600);
        dpWiz.setCurrentPage(pageID);
        dpWiz.setShowPageCountdown(showPageCount);
        dpWiz.setTitle(frameTitle);
        dpWiz.setVisible(true);
    }

    public AbstractUIPage getPage(String pageID) {
        return WizardPageLibrary.getPage(pageID);
    }

    public static void main(String[] args) {
        Morpho.main(null);
        Log.setDebugLevel(55);
        DataPackageWizardPlugin plugin = new DataPackageWizardPlugin();
        plugin.startPackageWizard(new DataPackageWizardListener(){

            public void wizardComplete(Node newDOM) {
                Log.debug(1, "Wizard complete - Will now create an AbstractDataPackage..");
                AbstractDataPackage dp = DataPackageFactory.getDataPackage(newDOM);
                Log.debug(1, "AbstractDataPackage complete - Will now show in an XML Editor..");
                Node domnode = dp.getMetadataNode();
                DocFrame df = new DocFrame();
                df.setVisible(true);
                df.initDoc(null, domnode, null, null, "eml://ecoinformatics.org/eml-2.0.1");
                Log.debug(45, "\n\n********** Wizard finished: DOM:");
                Log.debug(45, XMLUtilities.getDOMTreeAsString((Node)newDOM, (boolean)false));
            }

            public void wizardCanceled() {
                Log.debug(45, "\n\n********** Wizard canceled!");
                System.exit(0);
            }
        });
    }

    public static boolean deleteExistingAndAddPageDataToDOM(AbstractDataPackage adp, List pageList, String rootXPath, String subtreeGenericName) {
        if (adp == null) {
            Log.debug(15, "** ERROR - deleteExistingAndAddPageDataToDOM() Got NULL AbstractDataPackage");
            return false;
        }
        if (pageList == null) {
            Log.debug(15, "** ERROR - deleteExistingAndAddPageDataToDOM() Got NULL pageList");
            return false;
        }
        if (subtreeGenericName == null || subtreeGenericName.trim().length() == 0) {
            Log.debug(15, "** ERROR - deleteExistingAndAddPageDataToDOM() Got subtreeGenericName: " + subtreeGenericName);
            return false;
        }
        if (rootXPath == null) {
            Log.debug(15, "** ERROR - deleteExistingAndAddPageDataToDOM() Got NULL rootXPath");
            return false;
        }
        if (!(rootXPath = rootXPath.trim()).startsWith("/")) {
            rootXPath = "/" + rootXPath;
        }
        boolean errorOccurred = false;
        String rootNodeName = rootXPath;
        while (rootNodeName.endsWith("/")) {
            rootNodeName = rootNodeName.substring(0, rootNodeName.length() - 1);
        }
        int lastSlashIdx = 1 + rootNodeName.lastIndexOf("/");
        int lastPredicateIdx = rootNodeName.lastIndexOf("[");
        if (lastPredicateIdx < 0) {
            lastPredicateIdx = rootNodeName.length();
        }
        rootNodeName = rootNodeName.substring(lastSlashIdx, lastPredicateIdx);
        Log.debug(45, "rootNodeName=" + rootNodeName);
        DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
        List deletedOriginalsList = adp.deleteAllSubtrees(subtreeGenericName);
        int index = 0;
        for (AbstractUIPage nextPage : pageList) {
            if (nextPage == null) continue;
            OrderedMap map = nextPage.getPageData(rootXPath);
            Log.debug(45, "\n deleteExistingAndAddPageDataToDOM() Got rootXPath: " + rootXPath);
            Log.debug(45, "\n deleteExistingAndAddPageDataToDOM() Got details from page " + index + " - " + map);
            if (map == null || map.isEmpty()) {
                Log.debug(15, "ERROR - Unable to get details from page" + index + "!");
                errorOccurred = true;
            }
            Document doc = impl.createDocument("", rootNodeName, null);
            Element subtreeRoot = doc.getDocumentElement();
            try {
                XMLUtilities.getXPathMapAsDOMTree((Map)map, (Node)subtreeRoot);
            }
            catch (TransformerException w) {
                Log.debug(15, "TransformerException (" + w + ") calling " + "XMLUtilities.getXPathMapAsDOMTree(map, subtreeRoot) with \n" + "map = " + map + " and subtreeRoot = " + subtreeRoot);
                w.printStackTrace();
                errorOccurred = true;
                Log.debug(5, "Unable to add to package!");
            }
            Node check = null;
            Log.debug(45, "deleteExistingAndAddPageDataToDOM() adding subtree to package...");
            Log.debug(45, "subtreeGenericName=" + subtreeGenericName);
            Log.debug(45, "subtreeRoot=" + XMLUtilities.getDOMTreeAsString((Node)subtreeRoot));
            Log.debug(45, "index=" + index);
            check = adp.insertSubtree(subtreeGenericName, subtreeRoot, index);
            if (check == null) {
                Log.debug(15, "deleteExistingAndAddPageDataToDOM(): ADP.insertSubtree() returned NULL");
                errorOccurred = true;
                Log.debug(5, "** ERROR: Unable to add new details to package **\n");
            }
            ++index;
        }
        if (errorOccurred) {
            adp.deleteAllSubtrees(subtreeGenericName);
            int idx = 0;
            for (Node nextNode : deletedOriginalsList) {
                adp.replaceSubtree(subtreeGenericName, nextNode, idx++);
            }
        }
        Log.debug(45, errorOccurred ? "\n** ERROR - data NOT added - datapackage reset to original values" : "\n>> data added successfully ");
        return true;
    }

    public static void updateDOMFromPartiesList(CustomList partiesCustomList, String rootXPath, String subtreeGenericName, String pageType) {
        List nextRowList2 = null;
        ArrayList<AbstractUIPage> pagesList = new ArrayList<AbstractUIPage>();
        Object nextPageObj = null;
        for (List nextRowList2 : partiesCustomList.getListOfRowLists()) {
            if (nextRowList2.size() < 4 || (nextPageObj = nextRowList2.get(3)) == null || !(nextPageObj instanceof AbstractUIPage)) continue;
            pagesList.add(nextPageObj);
        }
        DataPackageWizardPlugin.deleteExistingAndAddPageDataToDOM(UIController.getInstance().getCurrentAbstractDataPackage(), pagesList, rootXPath, subtreeGenericName);
        DataPackageWizardPlugin.updatePartiesListFromDOM(partiesCustomList, rootXPath, subtreeGenericName, pageType);
    }

    public static void updatePartiesListFromDOM(CustomList partiesCustomList, String rootXPath, String subtreeGenericName, String pageType) {
        AbstractDataPackage adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (adp == null) {
            Log.debug(15, "\npackage from UIController is null");
            Log.debug(5, "ERROR: cannot update!");
            return;
        }
        List partySubtreesList = adp.getSubtrees(subtreeGenericName);
        Log.debug(45, "updatePartiesListFromDOM - partySubtreesList.size() = " + partySubtreesList.size());
        ArrayList<OrderedMap> partiesOrderedMapList = new ArrayList<OrderedMap>();
        Iterator it = partySubtreesList.iterator();
        while (it.hasNext()) {
            partiesOrderedMapList.add(XMLUtilities.getDOMTreeAsXPathMap((Node)((Node)it.next())));
        }
        DataPackageWizardPlugin.populatePartiesList(partiesCustomList, partiesOrderedMapList, rootXPath, pageType);
    }

    public static boolean populatePartiesList(CustomList partiesCustomList, List partiesOrderedMapList, String partyXPathRoot, String pageType) {
        Iterator persIt = partiesOrderedMapList.iterator();
        OrderedMap nextPersonnelMap = null;
        int partyPredicate = 1;
        partiesCustomList.removeAllRows();
        boolean partyRetVal = true;
        if (!partyXPathRoot.startsWith("/")) {
            partyXPathRoot = "/" + partyXPathRoot;
        }
        if (!partyXPathRoot.endsWith("[")) {
            partyXPathRoot = partyXPathRoot + "[";
        }
        while (persIt.hasNext()) {
            nextPersonnelMap = (OrderedMap)persIt.next();
            if (nextPersonnelMap == null || nextPersonnelMap.isEmpty()) continue;
            PartyPage nextParty = (PartyPage)WizardPageLibrary.getPage(pageType);
            boolean checkParty = nextParty.setPageData(nextPersonnelMap, partyXPathRoot + partyPredicate++ + "]");
            if (!checkParty) {
                partyRetVal = false;
            }
            List newRow = nextParty.getSurrogate();
            newRow.add(nextParty);
            partiesCustomList.addRow(newRow);
        }
        return partyRetVal;
    }
}

