/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins;

import edu.ucsb.nceas.morpho.plugins.ServiceExistsException;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.util.Log;
import java.util.Hashtable;

public class ServiceController {
    private Hashtable servicesRegistry = new Hashtable();
    private static ServiceController services;

    private ServiceController() {
    }

    public static ServiceController getInstance() {
        if (services == null) {
            services = new ServiceController();
        }
        return services;
    }

    public ServiceProvider getServiceProvider(Class serviceInterface) throws ServiceNotHandledException {
        if (this.servicesRegistry.containsKey(serviceInterface)) {
            return (ServiceProvider)this.servicesRegistry.get(serviceInterface);
        }
        throw new ServiceNotHandledException("No such service registered.");
    }

    public void addService(Class serviceInterface, ServiceProvider provider) throws ServiceExistsException {
        if (this.servicesRegistry.containsKey(serviceInterface)) {
            throw new ServiceExistsException(serviceInterface.getName());
        }
        Log.debug(20, "Adding service: " + serviceInterface.getName());
        this.servicesRegistry.put(serviceInterface, provider);
    }

    public boolean checkForService(Class serviceInterface) {
        return this.servicesRegistry.containsKey(serviceInterface);
    }
}

