/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.framework;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.LoginClientInterface;
import edu.ucsb.nceas.morpho.framework.LoginCommand;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class ConnectionFrame
extends JDialog
implements LoginClientInterface {
    Morpho container = null;
    ImageIcon still = null;
    ImageIcon flapping = null;
    boolean frameSizeAdjusted = false;
    JLabel JLabel1 = new JLabel();
    JPanel JPanel2 = new JPanel();
    JPanel JButtonGroupPanel1 = new JPanel();
    JPanel JPanel3 = new JPanel();
    JLabel Name = new JLabel();
    JLabel NameLabel = new JLabel();
    JPanel JPanel4 = new JPanel();
    JLabel Password = new JLabel();
    JPasswordField PWTextField = new JPasswordField();
    JLabel ActivityLabel = new JLabel();
    JPanel JPanel1 = new JPanel();
    JButton connectButton = new JButton();
    JButton DisconnectButton = new JButton();
    JButton CancelButton = new JButton();
    KeyPressActionListener keyPressListener = new KeyPressActionListener();

    public ConnectionFrame(Morpho cont) {
        this(cont, true);
    }

    public ConnectionFrame(Morpho cont, boolean modal) {
        this.setModal(true);
        this.container = cont;
        this.setDefaultCloseOperation(2);
        this.setTitle("Network Login");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setVisible(false);
        this.JLabel1.setHorizontalAlignment(0);
        this.JLabel1.setText("Network Login");
        this.getContentPane().add("North", this.JLabel1);
        this.JLabel1.setForeground(Color.black);
        this.JLabel1.setFont(new Font("Dialog", 1, 14));
        this.JPanel2.setLayout(new BorderLayout(0, 0));
        this.getContentPane().add("Center", this.JPanel2);
        this.JButtonGroupPanel1.setLayout(new GridLayout(4, 1, 0, 0));
        this.JPanel2.add("North", this.JButtonGroupPanel1);
        JPanel instructPanel = new JPanel();
        instructPanel.setLayout(new FlowLayout(0, 5, 5));
        this.JButtonGroupPanel1.add(instructPanel);
        JLabel instructLabel = new JLabel();
        instructLabel.setFont(new Font("Dialog", 1, 12));
        instructLabel.setForeground(Color.black);
        instructLabel.setText("Enter your Network password in order to log in.");
        instructPanel.add(instructLabel);
        this.JPanel3.setLayout(new FlowLayout(0, 5, 5));
        this.JButtonGroupPanel1.add(this.JPanel3);
        this.Name.setText("Name");
        this.JPanel3.add(this.Name);
        this.Name.setForeground(Color.black);
        this.Name.setFont(new Font("Dialog", 0, 12));
        this.JPanel3.add(this.NameLabel);
        this.JPanel4.setLayout(new FlowLayout(0, 5, 5));
        this.JButtonGroupPanel1.add(this.JPanel4);
        this.Password.setText("Password");
        this.JPanel4.add(this.Password);
        this.Password.setForeground(Color.black);
        this.Password.setFont(new Font("Dialog", 0, 12));
        this.PWTextField.setColumns(21);
        this.addKeyListenerToComponent(this.PWTextField);
        this.JPanel4.add(this.PWTextField);
        this.ActivityLabel.setDoubleBuffered(true);
        this.ActivityLabel.setHorizontalTextPosition(2);
        this.ActivityLabel.setHorizontalAlignment(4);
        this.JButtonGroupPanel1.add(this.ActivityLabel);
        this.ActivityLabel.setForeground(Color.black);
        this.JPanel1.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add("South", this.JPanel1);
        this.connectButton.setText("Login");
        this.connectButton.setActionCommand("OK");
        this.connectButton.setMnemonic(76);
        this.addKeyListenerToComponent(this.connectButton);
        this.JPanel1.add(this.connectButton);
        this.connectButton.isDefaultButton();
        this.DisconnectButton.setText("Logout");
        this.DisconnectButton.setActionCommand("Disconnect");
        this.DisconnectButton.setMnemonic(79);
        this.addKeyListenerToComponent(this.DisconnectButton);
        this.DisconnectButton.setEnabled(false);
        this.JPanel1.add(this.DisconnectButton);
        this.CancelButton.setText("Skip Login");
        this.CancelButton.setActionCommand("Cancel");
        this.CancelButton.setMnemonic(83);
        this.addKeyListenerToComponent(this.CancelButton);
        this.CancelButton.setEnabled(true);
        this.JPanel1.add(this.CancelButton);
        SymAction lSymAction = new SymAction();
        this.connectButton.addActionListener(lSymAction);
        this.DisconnectButton.addActionListener(lSymAction);
        this.CancelButton.addActionListener(lSymAction);
        if (this.container != null) {
            this.NameLabel.setText(this.container.getUserName());
        }
        try {
            this.still = new ImageIcon(this.getClass().getResource("Btfly.gif"));
            this.ActivityLabel.setIcon(this.still);
            this.flapping = new ImageIcon(this.getClass().getResource("Btfly4.gif"));
        }
        catch (Exception w) {
            Log.debug(7, "Error in loading images");
        }
        this.pack();
        this.updateEnabeDisable();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frameDim = this.getBounds();
        this.setLocation((screenDim.width - frameDim.width) / 2, (screenDim.height - frameDim.height) / 2);
    }

    private void updateEnabeDisable() {
        ConnectionFrame connectionFrame = this;
        this.DisconnectButton.setEnabled(connectionFrame.container.isConnected());
        ConnectionFrame connectionFrame2 = this;
        this.connectButton.setEnabled(!connectionFrame2.container.isConnected());
        ConnectionFrame connectionFrame3 = this;
        this.CancelButton.setEnabled(!connectionFrame3.container.isConnected());
        ConnectionFrame connectionFrame4 = this;
        this.PWTextField.setEnabled(!connectionFrame4.container.isConnected());
        if (this.PWTextField.isEnabled()) {
            this.PWTextField.requestFocus();
        }
    }

    public void addNotify() {
        Dimension size = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        JMenuBar menuBar = this.getRootPane().getJMenuBar();
        int menuBarHeight = 0;
        if (menuBar != null) {
            menuBarHeight = menuBar.getPreferredSize().height;
        }
        this.setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height + menuBarHeight);
    }

    private void addKeyListenerToComponent(Component component) {
        if (component == null) {
            Log.debug(10, "ConnectionFrame.addKeyListenerToComponent() - received NULL arg");
            return;
        }
        component.addKeyListener(this.keyPressListener);
    }

    void connectButton_actionPerformed(ActionEvent event) {
        this.ActivityLabel.setIcon(this.flapping);
        this.ActivityLabel.invalidate();
        this.JPanel2.validate();
        this.JPanel2.paint(this.JPanel2.getGraphics());
        new LoginCommand(this.container, this).execute(event);
    }

    void DisconnectButton_actionPerformed(ActionEvent event) {
        this.container.logOut();
        this.updateEnabeDisable();
    }

    void CancelButton_actionPerformed(ActionEvent event) {
        ConfigXML profile = this.container.getProfile();
        profile.set("searchmetacat", 0, "false");
        profile.save();
        this.dispose();
    }

    public String getPassword() {
        return new String(this.PWTextField.getPassword());
    }

    public void setLoginSuccessful(boolean success) {
        if (success) {
            this.dispose();
        } else {
            Log.debug(9, "Login failed.\nPlease check the Caps Lock key and try again.");
            this.updateEnabeDisable();
            this.ActivityLabel.setIcon(this.still);
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == ConnectionFrame.this.connectButton) {
                ConnectionFrame.this.connectButton_actionPerformed(event);
            } else if (object == ConnectionFrame.this.DisconnectButton) {
                ConnectionFrame.this.DisconnectButton_actionPerformed(event);
            } else if (object == ConnectionFrame.this.CancelButton) {
                ConnectionFrame.this.CancelButton_actionPerformed(event);
            }
        }
    }

    class KeyPressActionListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                if (e.getSource() instanceof JButton) {
                    ((JButton)e.getSource()).doClick();
                } else {
                    ActionEvent event = new ActionEvent(ConnectionFrame.this.connectButton, 0, "OK");
                    ConnectionFrame.this.connectButton_actionPerformed(event);
                }
            } else if (e.getKeyCode() == 27) {
                ConnectionFrame.this.dispose();
            }
        }
    }
}

