/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datastore;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datastore.CacheAccessException;
import edu.ucsb.nceas.morpho.datastore.DataStore;
import edu.ucsb.nceas.morpho.datastore.DataStoreInterface;
import edu.ucsb.nceas.morpho.datastore.MetacatUploadException;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Properties;
import java.util.Vector;

public class MetacatDataStore
extends DataStore
implements DataStoreInterface {
    private Morpho morpho;

    public MetacatDataStore(Morpho morpho) {
        super(morpho);
        this.morpho = morpho;
    }

    public File openFile(String name) throws FileNotFoundException, CacheAccessException {
        String path = this.parseId(name);
        String dirs = path.substring(0, path.lastIndexOf("/"));
        StringBuffer response = new StringBuffer();
        File localfile = new File(this.cachedir + "/" + path);
        File localdir = new File(this.cachedir + "/" + dirs);
        if (localfile.exists() && localfile.length() > 0L) {
            Log.debug(11, "MetacatDataStore: getting cached file");
            return localfile;
        }
        if (localfile.length() == 0L) {
            localfile.delete();
        }
        Log.debug(11, "MetacatDataStore: getting file from Metacat");
        Properties props = new Properties();
        props.put("action", "read");
        props.put("docid", name);
        props.put("qformat", "xml");
        try {
            localdir.mkdirs();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        try {
            FileOutputStream fos = new FileOutputStream(localfile);
            BufferedOutputStream bfos = new BufferedOutputStream(fos);
            InputStream metacatInput = this.morpho.getMetacatInputStream(props);
            Morpho.connectionBusy = true;
            BufferedInputStream bmetacatInputStream = new BufferedInputStream(metacatInput);
            int c = bmetacatInputStream.read();
            while (c != -1) {
                if (c > 127) {
                    bfos.write(38);
                    bfos.write(35);
                    int h = c / 100;
                    int t = (c - h * 100) / 10;
                    int o = c - h * 100 - t * 10;
                    bfos.write(Character.forDigit(h, 10));
                    bfos.write(Character.forDigit(t, 10));
                    bfos.write(Character.forDigit(o, 10));
                    bfos.write(59);
                    Log.debug(40, "char > 127!");
                } else if (c < 32) {
                    if (c == 9 || c == 10 || c == 13) {
                        bfos.write(c);
                    }
                } else {
                    bfos.write(c);
                }
                c = bmetacatInputStream.read();
            }
            bfos.flush();
            bfos.close();
            FileReader reader = new FileReader(localfile);
            BufferedReader breader = new BufferedReader(reader);
            c = breader.read();
            for (int cnt = 0; c != -1 && cnt < 1000; ++cnt) {
                response.append((char)c);
                c = breader.read();
            }
            String responseStr = response.toString();
            if (responseStr.indexOf("<error>") != -1) {
                bfos.close();
                breader.close();
                bmetacatInputStream.close();
                metacatInput.close();
                if (!localfile.delete()) {
                    throw new CacheAccessException("A cached file could not be deleted.  Please check your access permissions on the cache directory.Failing to delete cached files can result in erroneous operation of morpho.You may want to manually clear your cache now.");
                }
                throw new FileNotFoundException(name + " does not exist on your " + "current Metacat system: ");
            }
            bfos.close();
            breader.close();
            bmetacatInputStream.close();
            metacatInput.close();
            Morpho.connectionBusy = false;
            return localfile;
        }
        catch (FileNotFoundException mde) {
            throw mde;
        }
        catch (Exception e) {
            e.printStackTrace();
            Morpho.connectionBusy = false;
            return null;
        }
    }

    public File openDataFile(String name) throws FileNotFoundException, CacheAccessException {
        String path = this.parseId(name);
        String dirs = path.substring(0, path.lastIndexOf("/"));
        StringBuffer response = new StringBuffer();
        File localfile = new File(this.cachedir + "/" + path);
        File localdir = new File(this.cachedir + "/" + dirs);
        if (localfile.exists() && localfile.length() > 0L) {
            Log.debug(11, "MetacatDataStore: getting cached file");
            return localfile;
        }
        if (localfile.length() == 0L) {
            localfile.delete();
        }
        Log.debug(11, "MetacatDataStore: getting file from Metacat");
        Properties props = new Properties();
        props.put("action", "read");
        props.put("docid", name);
        props.put("qformat", "xml");
        try {
            localdir.mkdirs();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        try {
            FileOutputStream fos = new FileOutputStream(localfile);
            BufferedOutputStream bfos = new BufferedOutputStream(fos);
            InputStream metacatInput = this.morpho.getMetacatInputStream(props);
            Morpho.connectionBusy = true;
            BufferedInputStream bmetacatInputStream = new BufferedInputStream(metacatInput);
            int c = bmetacatInputStream.read();
            while (c != -1) {
                bfos.write(c);
                c = bmetacatInputStream.read();
            }
            bfos.flush();
            bfos.close();
            FileReader reader = new FileReader(localfile);
            BufferedReader breader = new BufferedReader(reader);
            c = breader.read();
            for (int cnt = 0; c != -1 && cnt < 1000; ++cnt) {
                response.append((char)c);
                c = breader.read();
            }
            String responseStr = response.toString();
            if (responseStr.indexOf("<error>") != -1) {
                bfos.close();
                breader.close();
                bmetacatInputStream.close();
                metacatInput.close();
                if (!localfile.delete()) {
                    throw new CacheAccessException("A cached file could not be deleted.  Please check your access permissions on the cache directory.Failing to delete cached files can result in erroneous operation of morpho.You may want to manually clear your cache now.");
                }
                throw new FileNotFoundException(name + " does not exist on your " + "current Metacat system: ");
            }
            bfos.close();
            breader.close();
            bmetacatInputStream.close();
            metacatInput.close();
            Morpho.connectionBusy = false;
            return localfile;
        }
        catch (FileNotFoundException mde) {
            throw mde;
        }
        catch (Exception e) {
            e.printStackTrace();
            Morpho.connectionBusy = false;
            return null;
        }
    }

    public boolean exists(String name) {
        String path = this.parseId(name);
        String dirs = path.substring(0, path.lastIndexOf("/"));
        StringBuffer response = new StringBuffer();
        File localfile = new File(this.cachedir + "/" + path);
        File localdir = new File(this.cachedir + "/" + dirs);
        if (localfile.exists() && localfile.length() > 0L) {
            Log.debug(11, "MetacatDataStore: cached file exists ");
            return true;
        }
        if (localfile.length() == 0L) {
            localfile.delete();
        }
        Log.debug(11, "MetacatDataStore: getting file from Metacat");
        Properties props = new Properties();
        props.put("action", "read");
        props.put("docid", name);
        props.put("qformat", "xml");
        try {
            FileOutputStream fos = new FileOutputStream(localfile);
            BufferedOutputStream bfos = new BufferedOutputStream(fos);
            InputStream metacatInput = this.morpho.getMetacatInputStream(props);
            Morpho.connectionBusy = true;
            BufferedInputStream bmetacatInputStream = new BufferedInputStream(metacatInput);
            boolean x = true;
            int c = bmetacatInputStream.read();
            while (c != -1) {
                bfos.write(c);
                c = bmetacatInputStream.read();
            }
            bfos.flush();
            bfos.close();
            FileReader reader = new FileReader(localfile);
            BufferedReader breader = new BufferedReader(reader);
            c = breader.read();
            for (int cnt = 0; c != -1 && cnt < 1000; ++cnt) {
                response.append((char)c);
                c = breader.read();
            }
            String responseStr = response.toString();
            if (responseStr.indexOf("<error>") != -1) {
                bfos.close();
                breader.close();
                bmetacatInputStream.close();
                metacatInput.close();
                if (!localfile.delete()) {
                    throw new CacheAccessException("A cached file could not be deleted.  Please check your access permissions on the cache directory.Failing to delete cached files can result in erroneous operation of morpho.You may want to manually clear your cache now.");
                }
                return false;
            }
            bfos.close();
            breader.close();
            bmetacatInputStream.close();
            metacatInput.close();
            Morpho.connectionBusy = false;
            return true;
        }
        catch (Exception e) {
            Morpho.connectionBusy = false;
            return false;
        }
    }

    public File saveFile(String name, Reader file) throws MetacatUploadException {
        return this.saveFile(name, file, "update", true);
    }

    public File saveFile(String name, Reader file, boolean checkforaccessfile) throws MetacatUploadException {
        return this.saveFile(name, file, "update", checkforaccessfile);
    }

    private File saveFile(String name, Reader file, String action, boolean checkforaccessfile) throws MetacatUploadException {
        String access = "no";
        StringBuffer fileText = new StringBuffer();
        StringBuffer messageBuf = new StringBuffer();
        Object accessFileId = null;
        BufferedReader bfile = new BufferedReader(file);
        try {
            StringWriter sw = new StringWriter();
            File tempfile = new File(this.tempdir + "/metacat.noid");
            FileWriter fw = new FileWriter(tempfile);
            BufferedWriter bfw = new BufferedWriter(fw);
            int c = bfile.read();
            while (c != -1) {
                bfw.write(c);
                sw.write(c);
                c = bfile.read();
            }
            bfw.flush();
            bfw.close();
            bfile.close();
            String filetext = sw.toString();
            Log.debug(30, "filelength is:" + filetext.length());
            if (filetext.length() == 0) {
                return null;
            }
            Properties prop = new Properties();
            prop.put("action", action);
            prop.put("public", access);
            prop.put("doctext", filetext);
            prop.put("docid", name);
            Log.debug(11, "sending docid: " + name + " to metacat");
            Log.debug(11, "action: " + action);
            Log.debug(11, "public access: " + access);
            InputStream metacatInput = null;
            metacatInput = this.morpho.getMetacatInputStream(prop, true);
            Morpho.connectionBusy = true;
            InputStreamReader metacatInputReader = new InputStreamReader(metacatInput);
            BufferedReader bmetacatInputReader = new BufferedReader(metacatInputReader);
            int d = bmetacatInputReader.read();
            while (d != -1) {
                messageBuf.append((char)d);
                d = bmetacatInputReader.read();
            }
            String message = messageBuf.toString();
            Log.debug(11, "message from server: " + message);
            if (message.indexOf("<error>") != -1) {
                bmetacatInputReader.close();
                metacatInput.close();
                throw new MetacatUploadException(message);
            }
            if (message.indexOf("<success>") != -1) {
                String docid = this.parseIdFromMessage(message);
                try {
                    bmetacatInputReader.close();
                    metacatInput.close();
                    Morpho.connectionBusy = false;
                    return this.openFile(docid);
                }
                catch (Exception ee) {
                    bmetacatInputReader.close();
                    metacatInput.close();
                    ee.printStackTrace();
                    Morpho.connectionBusy = false;
                    return null;
                }
            }
            Morpho.connectionBusy = false;
            throw new Exception("unexpected error in edu.ucsb.nceas.morpho..datastore.MetacatDataStore.saveFile(): " + message);
        }
        catch (Exception e) {
            Morpho.connectionBusy = false;
            throw new MetacatUploadException(e.getMessage());
        }
    }

    public File newFile(String name, Reader file) throws MetacatUploadException {
        return this.saveFile(name, file, "insert", true);
    }

    public File newFile(String name, Reader file, boolean checkforaccessfile) throws MetacatUploadException {
        return this.saveFile(name, file, "insert", checkforaccessfile);
    }

    public void newDataFile(String id, File file) throws MetacatUploadException {
        try {
            if (file.length() > 0L) {
                int len;
                System.out.println("id:" + id + "  filelength:" + file.length());
                InputStream metacatInput = null;
                metacatInput = this.morpho.sendDataFile(id, file);
                InputStreamReader returnStream = new InputStreamReader(metacatInput);
                BufferedReader breturnStream = new BufferedReader(returnStream);
                StringWriter sw = new StringWriter();
                char[] characters = new char[512];
                while ((len = breturnStream.read(characters, 0, 512)) != -1) {
                    sw.write(characters, 0, len);
                }
                breturnStream.close();
                String response = sw.toString();
                sw.close();
                if (response.indexOf("<error>") != -1) {
                    throw new MetacatUploadException(response);
                }
                Log.debug(20, response);
            }
        }
        catch (Exception e) {
            throw new MetacatUploadException(e.getMessage());
        }
    }

    public boolean deleteFile(String name) {
        StringBuffer messageBuf = new StringBuffer();
        Properties prop = new Properties();
        prop.put("action", "delete");
        prop.put("docid", name);
        Log.debug(11, "deleting docid: " + name + " from metacat");
        InputStream metacatInput = null;
        metacatInput = this.morpho.getMetacatInputStream(prop, true);
        Morpho.connectionBusy = true;
        InputStreamReader metacatInputReader = new InputStreamReader(metacatInput);
        BufferedReader bmetacatInputReader = new BufferedReader(metacatInputReader);
        try {
            int d = bmetacatInputReader.read();
            while (d != -1) {
                messageBuf.append((char)d);
                d = bmetacatInputReader.read();
            }
        }
        catch (IOException ioe) {
            Log.debug(0, "Error deleting file from metacat: " + ioe.getMessage());
            Morpho.connectionBusy = false;
            return false;
        }
        String message = messageBuf.toString();
        Log.debug(11, "message from server: " + message);
        if (message.indexOf("<error>") != -1) {
            try {
                bmetacatInputReader.close();
                metacatInput.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            Morpho.connectionBusy = false;
            return false;
        }
        if (message.indexOf("<success>") != -1) {
            try {
                bmetacatInputReader.close();
                metacatInput.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            Morpho.connectionBusy = false;
            return true;
        }
        Morpho.connectionBusy = false;
        return false;
    }

    public static void main(String[] args) {
        String username = args[0];
        String password = args[1];
        try {
            Log.debug(20, "Initializing mds test...");
            ConfigXML config = new ConfigXML("./lib/config.xml");
            Morpho morpho = new Morpho(config);
            String profileDir = config.get("profile_directory", 0);
            String profileName = profileDir + File.separator + username + File.separator + username + ".xml";
            ConfigXML profile = new ConfigXML(profileName);
            morpho.setProfile(profile);
            morpho.setPassword(password);
            morpho.logIn();
            MetacatDataStore mds = new MetacatDataStore(morpho);
            Log.debug(20, "Testing metadata upload...");
            String id = args[2];
            File f = new File(args[3]);
            FileReader fr = new FileReader(f);
            Log.debug(20, "Testing data upload...");
            id = args[4];
            f = new File(args[5]);
            mds.newDataFile(id, f);
            Log.debug(20, "Data file uploaded!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String saveFilesTransaction(Vector namesVec, Vector readersVec) {
        String temp = "";
        String response = "OK";
        for (int i = 0; i < namesVec.size(); ++i) {
            String name = (String)namesVec.elementAt(i);
            Reader reader = (Reader)readersVec.elementAt(i);
            try {
                this.saveFile(name, reader);
                continue;
            }
            catch (Exception e) {
                response = name;
                for (int j = 0; j < i - 1; ++j) {
                    String name1 = (String)namesVec.elementAt(i);
                    boolean deleted = this.deleteFile(name1);
                    if (deleted) continue;
                    temp = temp + "Could not delete" + name;
                }
            }
        }
        if (temp.length() > 0) {
            response = temp;
        }
        return response;
    }
}

