/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.AccessionNumber;
import edu.ucsb.nceas.morpho.datapackage.DataPackageFactory;
import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.datapackage.EML200DataPackage;
import edu.ucsb.nceas.morpho.datastore.MetacatUploadException;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringReader;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SaveDialog
extends JDialog {
    private JButton executeButton = null;
    private JButton cancelButton = null;
    private boolean showPackageFlag = true;
    private JCheckBox localLoc = new JCheckBox("Save Locally");
    private JCheckBox networkLoc = new JCheckBox("Save to Network.");
    private JCheckBox upgradeEml = new JCheckBox("Upgrade to latest EML (eml-2.0.1)");
    private static final int PADDINGWIDTH = 8;
    private static String WARNING = "Please choose where you would like to save the data package.";
    MorphoFrame morphoFrame = null;
    String morphoFrameType = null;
    String selectDocId = null;
    private boolean inLocal = false;
    private boolean inNetwork = false;
    AbstractDataPackage adp = null;

    public SaveDialog(AbstractDataPackage adp) {
        this.setModal(true);
        this.adp = adp;
        this.morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        this.initialize(this.morphoFrame);
    }

    public SaveDialog(AbstractDataPackage adp, boolean showPackageFlag) {
        this(adp);
        this.showPackageFlag = showPackageFlag;
    }

    private void initialize(Window parent) {
        int parentWidth = parent.getWidth();
        int parentHeight = parent.getHeight();
        int dialogWidth = 400;
        int dialogHeight = 270;
        this.setSize(dialogWidth, dialogHeight);
        this.setResizable(false);
        double parentX = parent.getLocation().getX();
        double parentY = parent.getLocation().getY();
        double centerX = parentX + 0.5 * (double)parentWidth;
        double centerY = parentY + 0.5 * (double)parentHeight;
        int dialogX = new Double(centerX - 0.5 * (double)dialogWidth).intValue();
        int dialogY = new Double(centerY - 0.5 * (double)dialogHeight).intValue();
        this.setLocation(dialogX, dialogY);
        this.setTitle("Save Current DataPackage");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().add("East", Box.createHorizontalStrut(8));
        this.getContentPane().add("West", Box.createHorizontalStrut(8));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(0, 0));
        Box noteBox = Box.createVerticalBox();
        noteBox.add(Box.createVerticalStrut(8));
        JLabel note = WidgetFactory.makeHTMLLabel(WARNING, 2);
        noteBox.add(note);
        noteBox.add(Box.createVerticalStrut(8));
        mainPanel.add("North", noteBox);
        Box radioBox = Box.createVerticalBox();
        radioBox.add(this.localLoc);
        radioBox.add(this.networkLoc);
        radioBox.add(this.upgradeEml);
        Box centerBox = Box.createHorizontalBox();
        centerBox.add(Box.createHorizontalGlue());
        centerBox.add(radioBox);
        centerBox.add(Box.createHorizontalGlue());
        mainPanel.add("Center", centerBox);
        this.getContentPane().add("Center", mainPanel);
        Box bottomBox = Box.createVerticalBox();
        this.getContentPane().add("South", bottomBox);
        bottomBox.add(Box.createVerticalStrut(8));
        Box controlButtonsBox = Box.createHorizontalBox();
        controlButtonsBox.add(Box.createHorizontalGlue());
        this.executeButton = new JButton("Save");
        controlButtonsBox.add(this.executeButton);
        controlButtonsBox.add(Box.createHorizontalStrut(8));
        this.cancelButton = new JButton("Cancel");
        controlButtonsBox.add(this.cancelButton);
        controlButtonsBox.add(Box.createHorizontalStrut(8));
        bottomBox.add(controlButtonsBox);
        bottomBox.add(Box.createVerticalStrut(10));
        SymAction lSymAction = new SymAction();
        this.executeButton.addActionListener(lSymAction);
        this.cancelButton.addActionListener(lSymAction);
        String location = this.adp.getLocation();
        if (location.equals("")) {
            this.localLoc.setEnabled(true);
            this.networkLoc.setEnabled(true);
            this.localLoc.setSelected(true);
            this.networkLoc.setSelected(false);
        } else if (location.equals("local")) {
            this.localLoc.setEnabled(false);
            this.networkLoc.setEnabled(true);
            this.localLoc.setSelected(true);
            this.networkLoc.setSelected(true);
        } else if (location.equals("metacat")) {
            this.localLoc.setEnabled(true);
            this.networkLoc.setEnabled(false);
            this.localLoc.setSelected(true);
            this.networkLoc.setSelected(true);
        } else if (location.equals("localmetacat")) {
            this.localLoc.setEnabled(false);
            this.networkLoc.setEnabled(false);
            this.localLoc.setSelected(false);
            this.networkLoc.setSelected(false);
        }
        try {
            String emlVersion = ((EML200DataPackage)this.adp).getEMLVersion();
            Log.debug(10, "\n\n**********Got the EML version: " + emlVersion);
            boolean askUpgrade = emlVersion.toLowerCase().indexOf("eml-2.0.1") == -1;
            this.upgradeEml.setSelected(askUpgrade);
            this.upgradeEml.setVisible(askUpgrade);
        }
        catch (Exception e) {
            Log.debug(30, "Couldn't get EML version: " + e.getMessage());
        }
        this.setVisible(true);
    }

    private void enableExecuteButton(Object object, JDialog dialog) {
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
        this.dispose();
    }

    void executeButton_actionPerformed(ActionEvent event) {
        Component comp = this.morphoFrame.getContentComponent();
        if (comp instanceof DataViewContainerPanel) {
            ((DataViewContainerPanel)comp).saveDataChanges();
        }
        boolean problem = false;
        Morpho morpho = Morpho.thisStaticInstance;
        String location = this.adp.getLocation();
        if (location.equals("")) {
            AccessionNumber an;
            try {
                if (this.upgradeEml.isSelected()) {
                    ((EML200DataPackage)this.adp).setEMLVersion("eml-2.0.1");
                    this.adp = (EML200DataPackage)DataPackageFactory.getDataPackage(new StringReader(XMLUtil.getDOMTreeAsString(this.adp.getMetadataNode().cloneNode(true).getOwnerDocument())), false, true);
                }
            }
            catch (Exception ex) {
                Log.debug(30, "Problem setting new EML version: " + ex.toString());
            }
            try {
                String id = this.adp.getAccessionNumber();
                if (id.indexOf("temporary") > -1) {
                    an = new AccessionNumber(morpho);
                    String nextid = an.getNextId();
                    this.adp.setAccessionNumber(nextid);
                } else {
                    an = new AccessionNumber(morpho);
                    String newid = an.incRev(id);
                    this.adp.setAccessionNumber(newid);
                }
            }
            catch (Exception www) {
                an = new AccessionNumber(morpho);
                String nextid = an.getNextId();
                this.adp.setAccessionNumber(nextid);
            }
        }
        try {
            if (this.localLoc.isSelected() && this.localLoc.isEnabled() && this.networkLoc.isSelected() && this.networkLoc.isEnabled()) {
                this.adp.serialize("localmetacat");
                this.adp.setLocation("localmetacat");
                this.adp.serializeData();
            } else if (this.localLoc.isSelected() && this.localLoc.isEnabled()) {
                this.adp.serialize("local");
                this.adp.setLocation("local");
                this.adp.serializeData();
            } else if (this.networkLoc.isSelected() && this.networkLoc.isEnabled()) {
                this.adp.serialize("metacat");
                this.adp.setLocation("metacat");
                this.adp.serializeData();
            } else {
                Log.debug(1, "No location for saving is selected!");
            }
        }
        catch (MetacatUploadException mue) {
            String errormsg = mue.getMessage();
            if (errormsg.indexOf("ERROR SAVING DATA TO METACAT") > -1) {
                Log.debug(5, "Problem Saving Data to Metacat");
            } else if (errormsg.indexOf("is already in use") > -1) {
                Log.debug(5, "Problem Saving Data: Id already in use");
            } else if (errormsg.indexOf("Document not found for Accession number") > -1) {
                Log.debug(5, "Problem Saving Data: Document not found for Accession number");
            } else if (errormsg.indexOf("Invalid content") > -1) {
                Log.debug(5, "Problem Saving Data due to invalid content");
            }
            Log.debug(20, "Problem Saving\n" + mue.getMessage());
            problem = true;
        }
        this.setVisible(false);
        this.dispose();
        if (!problem) {
            if (this.showPackageFlag) {
                UIController.showNewPackageNoLocChange(this.adp);
            } else {
                MorphoFrame morphoFrame = UIController.getInstance().getCurrentActiveWindow();
                morphoFrame.setVisible(false);
                UIController controller = UIController.getInstance();
                controller.removeWindow(morphoFrame);
                morphoFrame.dispose();
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == SaveDialog.this.executeButton) {
                SaveDialog.this.executeButton_actionPerformed(event);
            } else if (object == SaveDialog.this.cancelButton) {
                SaveDialog.this.cancelButton_actionPerformed(event);
            }
        }
    }
}

