/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho;

import HTTPClient.http.Handler;
import com.sun.net.ssl.internal.ssl.Provider;
import edu.ucsb.nceas.itis.Itis;
import edu.ucsb.nceas.itis.ItisException;
import edu.ucsb.nceas.itis.Taxon;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.ConnectionFrame;
import edu.ucsb.nceas.morpho.framework.ConnectionListener;
import edu.ucsb.nceas.morpho.framework.HelpCommand;
import edu.ucsb.nceas.morpho.framework.HttpMessage;
import edu.ucsb.nceas.morpho.framework.InitialScreen;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.MorphoPrefsDialog;
import edu.ucsb.nceas.morpho.framework.ProfileAddedListener;
import edu.ucsb.nceas.morpho.framework.ProfileDialog;
import edu.ucsb.nceas.morpho.framework.SplashFrame;
import edu.ucsb.nceas.morpho.framework.SwingWorker;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.PluginInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.UISettings;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.net.UnknownHostException;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.XMLReader;

public class Morpho {
    public static String VERSION = "1.6.1";
    public static String SEPARATOR_PRECEDING = "separator_preceding";
    public static String SEPARATOR_FOLLOWING = "separator_following";
    public static final String INITIALFRAMENAME = "Morpho";
    private static final Integer DIVIDER_THICKNESS_FOR_MSWINDOWS = new Integer(8);
    static boolean log_file = false;
    private String userName = "public";
    private String passWord = "none";
    private String metacatURL = null;
    private static ConfigXML config;
    private static ConfigXML profileConfig;
    private ConfigXML profile;
    private static boolean connected;
    private boolean networkStatus = false;
    private boolean sslStatus = false;
    private Vector connectionRegistry = null;
    private static final List profileAddedListenerList;
    private static MorphoFrame initialFrame;
    private boolean pluginsLoaded = false;
    private String sessionCookie = null;
    private Itis itis;
    private boolean versionFlag = true;
    private URL metacatPingURL = null;
    private URLConnection urlConn = null;
    private boolean origNetworkStatus = false;
    private static final int METACAT_PING_INTERVAL = 30000;
    private static String configFile;
    private static String profileFileName;
    private static boolean debug;
    private static int debug_level;
    public static Morpho thisStaticInstance;
    public static boolean connectionBusy;
    ActionListener pingActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Morpho.this.doPing();
        }
    };

    public Morpho(ConfigXML config) {
        Morpho.config = config;
        this.profile = null;
        this.checkJavaVersion();
        this.connectionRegistry = new Vector();
        this.loadConfigurationParameters();
        this.sslStatus = this.metacatURL.indexOf("https://") == 0;
        try {
            this.metacatPingURL = new URL(this.metacatURL);
        }
        catch (MalformedURLException mfue) {
            Log.debug(5, "unable to read or resolve Metacat URL");
        }
        this.startPing();
        this.finishPing(true);
        Timer timer = new Timer(30000, this.pingActionListener);
        timer.setRepeats(true);
        timer.start();
    }

    public void setUserName(String uname) {
        if (!this.userName.equals(uname)) {
            this.userName = uname;
            this.fireUsernameChangedEvent();
        }
    }

    public void setPassword(String pword) {
        this.passWord = pword;
    }

    public void setProfile(ConfigXML newProfile) {
        this.setProfileDontLogin(newProfile, false);
        if (initialFrame == null) {
            this.establishConnection();
        } else if (!initialFrame.isShowing()) {
            this.establishConnection();
        }
        this.fireConnectionChangedEvent();
    }

    public void setProfileDontLogin(ConfigXML newProfile) {
        this.setProfileDontLogin(newProfile, true);
    }

    private void setProfileDontLogin(ConfigXML newProfile, boolean doFireConnectionChangedEvent) {
        this.profile = newProfile;
        String profilename = this.profile.get("profilename", 0);
        String scope = this.profile.get("scope", 0);
        String dn = this.profile.get("dn", 0);
        Log.debug(20, "Setting username to dn: " + dn);
        this.setUserName(dn);
        if (!profileConfig.set("current_profile", 0, profilename)) {
            boolean success = profileConfig.insert("current_profile", profilename);
        }
        profileConfig.save();
        this.setLastID(scope);
        if (doFireConnectionChangedEvent) {
            this.fireConnectionChangedEvent();
        }
    }

    public void setProfile(String newProfileName) {
        this.setProfile(newProfileName, true);
    }

    public void setProfileDontLogin(String newProfileName) {
        this.setProfile(newProfileName, false);
    }

    private void setProfile(String newProfileName, boolean doLogin) {
        String profileDir = config.getConfigDirectory() + File.separator + config.get("profile_directory", 0);
        String currentProfile = Morpho.getCurrentProfileName();
        if (!newProfileName.equals(currentProfile)) {
            String newProfilePath = profileDir + File.separator + newProfileName + File.separator + newProfileName + ".xml";
            try {
                ConfigXML newProfile = new ConfigXML(newProfilePath);
                if (doLogin) {
                    this.setProfile(newProfile);
                } else {
                    this.setProfileDontLogin(newProfile);
                }
            }
            catch (FileNotFoundException fnf) {
                Log.debug(5, "Profile not found!");
            }
        }
    }

    public void cleanCache() {
        String profileDir = config.getConfigDirectory() + File.separator + config.get("profile_directory", 0);
        String cacheDir = profileDir + File.separator + Morpho.getCurrentProfileName() + File.separator + "cache";
        File cacheDirFile = new File(cacheDir);
        String[] cacheList = cacheDirFile.list();
        for (int i = 0; i < cacheList.length; ++i) {
            File f = new File(cacheDir + File.separator + cacheList[i]);
            if (f.isDirectory()) {
                String[] fList = f.list();
                for (int j = 0; j < fList.length; ++j) {
                    File ff = new File(f.getAbsolutePath() + File.separator + fList[j]);
                    ff.delete();
                }
            }
            f.delete();
        }
    }

    public void cleanTemp() {
        String profileDir = config.getConfigDirectory() + File.separator + config.get("profile_directory", 0);
        String cacheDir = profileDir + File.separator + Morpho.getCurrentProfileName() + File.separator + "temp";
        File cacheDirFile = new File(cacheDir);
        String[] cacheList = cacheDirFile.list();
        for (int i = 0; i < cacheList.length; ++i) {
            File f = new File(cacheDir + File.separator + cacheList[i]);
            if (f.isDirectory()) {
                String[] fList = f.list();
                for (int j = 0; j < fList.length; ++j) {
                    File ff = new File(f.getAbsolutePath() + File.separator + fList[j]);
                    ff.delete();
                }
            }
            f.delete();
        }
    }

    public InputStream getMetacatInputStream(Properties prop, boolean requiresLogin) {
        if (requiresLogin && !connected) {
            this.establishConnection();
        }
        return this.getMetacatInputStream(prop);
    }

    public String getSessionCookie() {
        return this.sessionCookie;
    }

    public synchronized InputStream getMetacatInputStream(Properties prop) {
        connectionBusy = true;
        InputStream returnStream = null;
        try {
            Log.debug(20, "Sending data to: " + this.metacatURL);
            URL url = new URL(this.metacatURL);
            HttpMessage msg = new HttpMessage(url);
            returnStream = msg.sendPostMessage(prop);
            this.sessionCookie = msg.getCookie();
            connectionBusy = false;
            return returnStream;
        }
        catch (Exception e) {
            try {
                Log.debug(20, "Sending data (again) to : " + this.metacatURL);
                URL url = new URL(this.metacatURL);
                HttpMessage msg = new HttpMessage(url);
                returnStream = msg.sendPostMessage(prop);
                this.sessionCookie = msg.getCookie();
                connectionBusy = false;
                return returnStream;
            }
            catch (Exception e2) {
                try {
                    Log.debug(20, "Sending data (again)(again) to: " + this.metacatURL);
                    URL url = new URL(this.metacatURL);
                    HttpMessage msg = new HttpMessage(url);
                    returnStream = msg.sendPostMessage(prop);
                    this.sessionCookie = msg.getCookie();
                    connectionBusy = false;
                    return returnStream;
                }
                catch (Exception e3) {
                    Log.debug(1, "Fatal error sending data to Metacat: " + e3.getMessage());
                    e.printStackTrace(System.err);
                    connectionBusy = false;
                    return returnStream;
                }
            }
        }
    }

    public String getMetacatString(Properties prop, boolean requiresLogin) {
        if (requiresLogin && !connected) {
            this.establishConnection();
        }
        return this.getMetacatString(prop);
    }

    public String getMetacatString(Properties prop) {
        String response = null;
        try {
            int len;
            InputStreamReader returnStream = new InputStreamReader(this.getMetacatInputStream(prop));
            StringWriter sw = new StringWriter();
            char[] characters = new char[512];
            while ((len = returnStream.read(characters, 0, 512)) != -1) {
                sw.write(characters, 0, len);
            }
            returnStream.close();
            response = sw.toString();
            sw.close();
        }
        catch (Exception e) {
            Log.debug(1, "Fatal error sending data to Metacat.");
        }
        return response;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.passWord;
    }

    public static boolean isConnected() {
        return connected;
    }

    public boolean getSslStatus() {
        return this.sslStatus;
    }

    public boolean getNetworkStatus() {
        return this.networkStatus;
    }

    public static ConfigXML getConfiguration() {
        if (config == null) {
            try {
                Morpho.initializeConfiguration();
            }
            catch (FileNotFoundException fnfe) {
                Log.debug(5, "Configuration file not found!");
                fnfe.printStackTrace();
            }
        }
        return config;
    }

    public ConfigXML getProfile() {
        return this.profile;
    }

    public static String getCurrentProfileName() {
        return profileConfig.get("current_profile", 0);
    }

    public Vector getTaxonSynonyms(String taxonName) {
        Vector<String> synonymList;
        block6: {
            if (this.itis == null) {
                this.itis = new Itis();
            }
            synonymList = new Vector<String>();
            Log.debug(20, "Searching ITIS for synonyms of: " + taxonName);
            try {
                long newTsn = this.itis.findTaxonTsn(taxonName);
                if (newTsn <= 0L) break block6;
                try {
                    Vector synonyms = this.itis.getSynonymTsnList(newTsn);
                    for (int i = 0; i < synonyms.size(); ++i) {
                        long synonymTsn = (Long)synonyms.elementAt(i);
                        Taxon synonymTaxon = this.itis.getTaxon(synonymTsn);
                        synonymList.addElement(synonymTaxon.getScientificName());
                    }
                }
                catch (ItisException ie) {
                    Log.debug(20, "Problem with ITIS lookup for: " + taxonName);
                }
            }
            catch (ItisException iesearch) {
                Log.debug(20, "Taxon not found in ITIS: " + taxonName);
            }
        }
        return synonymList;
    }

    public boolean getJavaVersionFlag() {
        return this.versionFlag;
    }

    public void exitApplication() {
        try {
            UIController controller = UIController.getInstance();
            Vector dirty = controller.removeCleanWindows();
            if (dirty.size() < 1) {
                this.logOutExit();
                config.save();
                System.exit(0);
            } else {
                for (int i = 0; i < dirty.size(); ++i) {
                    MorphoFrame frame = (MorphoFrame)dirty.elementAt(i);
                    frame.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public InputStream sendDataFile(String id, File file) {
        String retmsg = "";
        InputStream returnStream = null;
        if (!connected) {
            this.establishConnection();
        }
        try {
            Log.debug(20, "Sending data to: |" + this.metacatURL + "|");
            URL url = new URL(this.metacatURL.trim());
            HttpMessage msg = new HttpMessage(url);
            Properties args = new Properties();
            args.put("action", "upload");
            args.put("docid", id);
            Properties dataStreams = new Properties();
            String filename = file.getAbsolutePath();
            Log.debug(20, "Sending data file: " + filename);
            dataStreams.put("datafile", filename);
            try {
                returnStream = msg.sendPostData(args, dataStreams);
            }
            catch (Exception ee) {
                try {
                    returnStream = msg.sendPostData(args, dataStreams);
                }
                catch (Exception eee) {
                    try {
                        returnStream = msg.sendPostData(args, dataStreams);
                    }
                    catch (Exception eeee) {
                        throw new Exception(eeee.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            Log.debug(1, "Fatal error sending binary data to Metacat: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        return returnStream;
    }

    public boolean logIn() {
        Properties prop = new Properties();
        prop.put("action", "login");
        prop.put("qformat", "xml");
        Log.debug(20, "Logging in using uid: " + this.userName);
        prop.put("username", this.userName);
        prop.put("password", this.passWord);
        String response = this.getMetacatString(prop);
        boolean wasConnected = connected;
        if (response.indexOf("<login>") != -1) {
            connected = true;
        } else {
            HttpMessage.setCookie(null);
            connected = false;
        }
        if (wasConnected != connected) {
            UIController controller = UIController.getInstance();
            if (controller != null) {
                controller.updateAllStatusBars();
            }
            this.fireConnectionChangedEvent();
        }
        return connected;
    }

    public void logOut() {
        if (connected) {
            this.passWord = "none";
            Properties prop = new Properties();
            prop.put("action", "logout");
            prop.put("qformat", "xml");
            String response = this.getMetacatString(prop);
            this.doLogoutCleanup();
        }
    }

    public void logOutExit() {
        if (connected) {
            this.passWord = "none";
            Properties prop = new Properties();
            prop.put("action", "logout");
            prop.put("qformat", "xml");
            String response = this.getMetacatString(prop);
            HttpMessage.setCookie(null);
            connected = false;
        }
    }

    public void addConnectionListener(ConnectionListener listener) {
        if (!this.connectionRegistry.contains(listener)) {
            Log.debug(20, "Adding listener: " + listener.toString());
            this.connectionRegistry.addElement(listener);
        }
    }

    public void checkJavaVersion() {
        String ver = System.getProperty("java.version");
        int pos1 = ver.indexOf(".");
        int pos2 = ver.indexOf(".", pos1 + 1);
        String ver0 = ver.substring(0, pos1);
        String ver1 = ver.substring(pos1 + 1, pos2);
        int iver0 = new Integer(ver0);
        int iver1 = new Integer(ver1);
        if (iver1 < 4) {
            this.versionFlag = false;
            JOptionPane.showMessageDialog(null, "Version " + ver + " of the Java Virtual Machine(JVM) " + "is currently in use.\n" + "Although most of Morpho will operate using early " + "versions of the JVM,\n" + "Version 1.4 or greater is recommended for all " + "functions to work properly!");
        } else if (System.getProperty("os.name").equalsIgnoreCase("Linux") && ver.compareTo("1.4") < 0) {
            JOptionPane.showMessageDialog(null, "You are currently using version " + ver + " of the Java " + "Virtual Machine(JVM) on a Linux system.\n\n" + "Unfortunately, Morpho's initial \"Welcome\" screen may " + "not display correctly with this configuration. \n\n" + "Please note that all other parts of Morpho will still " + "operate correctly, and you can access all the \n" + "welcome screen functions (change profile, login, " + "new/open/search packages) from Morpho's menus.\n\n" + "If possible, we recommend installing JVM version 1.4 or " + "later, which is available with the Morpho distribution");
        }
    }

    public static void main(String[] args) {
        try {
            Morpho morpho;
            SplashFrame sf = new SplashFrame(true);
            sf.setVisible(true);
            URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

                public URLStreamHandler createURLStreamHandler(String protocol) {
                    if ("http".equals(protocol)) {
                        try {
                            Handler urlsh = new Handler();
                            return urlsh;
                        }
                        catch (Exception e) {
                            System.out.println("Error setting URL StreamHandler!");
                            return null;
                        }
                    }
                    return null;
                }
            });
            System.setProperty("javax.net.ssl.trustStore", "./lib/morphocacerts");
            Security.addProvider((java.security.Provider)new Provider());
            if (args.length > 0) {
                String dir = args[0];
                ConfigXML.setConfigDirectory(dir);
            }
            Morpho.initializeConfiguration();
            Morpho.initializeLogging(config);
            thisStaticInstance = morpho = new Morpho(config);
            Morpho.setLookAndFeel(config.get("lookAndFeel", 0));
            morpho.loadProfile(morpho);
            ServiceController services = ServiceController.getInstance();
            UIController controller = UIController.initialize(morpho);
            morpho.initializeActions();
            morpho.loadPlugins();
            Morpho.makeWelcomeWindow();
            sf.dispose();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    public static void createMorphoInstance() {
        try {
            Morpho.initializeConfiguration();
            Morpho morpho = new Morpho(config);
            morpho.loadProfile(morpho);
            thisStaticInstance = morpho;
        }
        catch (Exception e) {
            Log.debug(10, "error creating Morpho Instance");
        }
    }

    public static XMLReader createSaxParser(ContentHandler contentHandler, ErrorHandler errorHandler) {
        XMLReader parser = null;
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            SAXParser saxp = spfactory.newSAXParser();
            parser = saxp.getXMLReader();
            if (parser != null) {
                parser.setFeature("http://xml.org/sax/features/namespaces", true);
                Log.debug(30, "Parser created is: " + parser.getClass().getName());
            } else {
                Log.debug(9, "Unable to create SAX parser!");
            }
            if (null != contentHandler) {
                parser.setContentHandler(contentHandler);
            } else {
                Log.debug(3, "No content handler for SAX parser!");
            }
            if (null != errorHandler) {
                parser.setErrorHandler(errorHandler);
            }
        }
        catch (Exception e) {
            Log.debug(1, "Failed to create SAX parser:\n" + e.toString());
        }
        return parser;
    }

    public static DocumentBuilder createDomParser() {
        DocumentBuilder parser = null;
        try {
            ClassLoader cl = Morpho.class.getClassLoader();
            Log.debug(30, "Current ClassLoader is: " + cl.getClass().getName());
            Thread t = Thread.currentThread();
            t.setContextClassLoader(cl);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            parser = factory.newDocumentBuilder();
            if (parser != null) {
                Log.debug(30, "Parser created is: " + parser.getClass().getName());
            } else {
                Log.debug(9, "Unable to create DOM parser!");
            }
        }
        catch (ParserConfigurationException pce) {
            Log.debug(9, "Exception while creating DOM parser!");
            Log.debug(10, pce.getMessage());
        }
        return parser;
    }

    private void setLastID(String scope) {
        String id;
        if (this.networkStatus && (id = this.getLastID(scope)) != null) {
            int num = new Integer(id);
            String curval = this.profile.get("lastId", 0);
            int curnum = new Integer(curval);
            if (curnum < num) {
                id = new Integer(++num).toString();
                this.profile.set("lastId", 0, id);
                this.profile.save();
            }
        }
    }

    private String getLastID(String scope) {
        String result = null;
        Properties lastIDProp = new Properties();
        lastIDProp.put("action", "getlastdocid");
        lastIDProp.put("scope", scope);
        String temp = this.getMetacatString(lastIDProp);
        if (temp != null) {
            int ind1 = temp.indexOf("<docid>");
            int ind2 = temp.indexOf("</docid>");
            if (ind1 > 0 && ind2 > 0) {
                result = temp.substring(ind1 + 7, ind2);
                if (!result.equals("null")) {
                    result = result.substring(0, result.lastIndexOf("."));
                    result = result.substring(result.indexOf(".") + 1, result.length());
                } else {
                    result = null;
                }
            }
        }
        return result;
    }

    private void loadPlugins() {
        Vector plugins = config.get("plugin");
        try {
            Enumeration q = plugins.elements();
            while (q.hasMoreElements()) {
                PluginInterface plugin = (PluginInterface)this.createObject((String)q.nextElement());
                plugin.initialize(this);
            }
            this.pluginsLoaded = true;
        }
        catch (ClassCastException cce) {
            Log.debug(5, "Error loading plugin: wrong class!");
        }
    }

    private void initializeActions() {
        UIController controller = UIController.getInstance();
        Command connectCommand = new Command(){

            public void execute(ActionEvent e) {
                Morpho.this.establishConnection();
            }
        };
        GUIAction connectItemAction = new GUIAction("Login/Logout", null, connectCommand);
        connectItemAction.setToolTipText("Login/Logout...");
        connectItemAction.setMenuItemPosition(9);
        connectItemAction.setSeparatorPosition(SEPARATOR_PRECEDING);
        connectItemAction.setMenu("File", 0);
        controller.addGuiAction(connectItemAction);
        CreateNewProfileCommand profileCommand = new CreateNewProfileCommand();
        GUIAction profileItemAction = new GUIAction("New profile...", null, profileCommand);
        profileItemAction.setToolTipText("New Profile...");
        profileItemAction.setMenuItemPosition(10);
        profileItemAction.setMenu("File", 0);
        controller.addGuiAction(profileItemAction);
        Command switchCommand = new Command(){

            public void execute(ActionEvent e) {
                Morpho.this.switchProfile();
            }
        };
        GUIAction switchItemAction = new GUIAction("Switch profile...", null, switchCommand);
        switchItemAction.setToolTipText("Switch Profile...");
        switchItemAction.setMenuItemPosition(11);
        switchItemAction.setSeparatorPosition(SEPARATOR_FOLLOWING);
        switchItemAction.setMenu("File", 0);
        controller.addGuiAction(switchItemAction);
        Command prefsCommand = new Command(){

            public void execute(ActionEvent e) {
                Morpho.this.setPreferences();
            }
        };
        GUIAction prefsItemAction = new GUIAction("Set preferences...", null, prefsCommand);
        prefsItemAction.setToolTipText("Set Preferences...");
        prefsItemAction.setMenuItemPosition(12);
        prefsItemAction.setSeparatorPosition(SEPARATOR_FOLLOWING);
        prefsItemAction.setMenu("File", 0);
        controller.addGuiAction(prefsItemAction);
        Command exitCommand = new Command(){

            public void execute(ActionEvent event) {
                Morpho.this.exitApplication();
            }
        };
        GUIAction exitItemAction = new GUIAction("Exit", null, exitCommand);
        exitItemAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control Q"));
        exitItemAction.setToolTipText("Exit Morpho");
        exitItemAction.setSeparatorPosition(SEPARATOR_PRECEDING);
        exitItemAction.putValue("menuPosition", new Integer(20));
        exitItemAction.setMenu("File", 0);
        controller.addGuiAction(exitItemAction);
        Command aboutCommand = new Command(){

            public void execute(ActionEvent event) {
                SplashFrame sf = new SplashFrame();
                sf.setVisible(true);
            }
        };
        GUIAction aboutItemAction = new GUIAction("About...", null, aboutCommand);
        aboutItemAction.putValue("ShortDescription", "About Morpho");
        aboutItemAction.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/About16.gif")));
        aboutItemAction.putValue("menuPosition", new Integer(1));
        aboutItemAction.setMenu("Help", 6);
        controller.addGuiAction(aboutItemAction);
        HelpCommand helpCommand = new HelpCommand();
        GUIAction helpItemAction = new GUIAction("Morpho User Guide...", null, helpCommand);
        helpItemAction.putValue("ShortDescription", "Morpho User Guide");
        helpItemAction.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Help16.gif")));
        helpItemAction.putValue("menuPosition", new Integer(2));
        helpItemAction.setMenu("Help", 6);
        controller.addGuiAction(helpItemAction);
        HelpCommand mdIntroCommand = new HelpCommand("metadata");
        GUIAction mdIntroItemAction = new GUIAction("Intro to Metadata...", null, mdIntroCommand);
        mdIntroItemAction.putValue("ShortDescription", "Intro to Metadata");
        mdIntroItemAction.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Help16.gif")));
        mdIntroItemAction.putValue("menuPosition", new Integer(3));
        mdIntroItemAction.setMenu("Help", 6);
        controller.addGuiAction(mdIntroItemAction);
        HelpCommand mdEMLSpecCommand = new HelpCommand("eml_index");
        GUIAction mdEMLSpecItemAction = new GUIAction("EML Specifications...", null, mdEMLSpecCommand);
        mdEMLSpecItemAction.putValue("ShortDescription", "EML Specifications");
        mdEMLSpecItemAction.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Help16.gif")));
        mdEMLSpecItemAction.putValue("menuPosition", new Integer(4));
        mdEMLSpecItemAction.setMenu("Help", 6);
        controller.addGuiAction(mdEMLSpecItemAction);
    }

    private void establishConnection() {
        if (this.networkStatus) {
            ConnectionFrame cf = new ConnectionFrame(this);
            cf.setVisible(true);
        } else {
            this.profile.set("searchmetacat", 0, "false");
            Log.debug(6, "No network connection available - can't log in");
        }
    }

    private static void createNewProfile() {
        String previousProfileName = Morpho.getCurrentProfileName();
        ProfileDialog dialog = new ProfileDialog(thisStaticInstance);
        dialog.setVisible(true);
        if (previousProfileName != Morpho.getCurrentProfileName()) {
            Morpho.fireProfileAdded();
        }
    }

    private void switchProfile() {
        this.logOut();
        String currentProfile = Morpho.getCurrentProfileName();
        Object[] profilesList = this.getProfilesList();
        int selection = 0;
        for (selection = 0; selection < profilesList.length && !currentProfile.equals(profilesList[selection]); ++selection) {
        }
        String newProfile = (String)JOptionPane.showInputDialog(null, "Select from existing profiles:", "Input", 1, null, profilesList, profilesList[selection]);
        if (null != newProfile) {
            if (currentProfile.equals(newProfile)) {
                Log.debug(9, "No change in profile.");
            } else {
                this.setProfile(newProfile);
                this.cleanUpFrames();
                Log.debug(9, "New profile is: " + newProfile);
            }
        }
    }

    private void setPreferences() {
        MorphoFrame mf = UIController.getInstance().getCurrentActiveWindow();
        MorphoPrefsDialog MorphoPrefsDialog1 = new MorphoPrefsDialog((Frame)mf, this);
        MorphoPrefsDialog1.setModal(true);
        MorphoPrefsDialog1.setVisible(true);
    }

    public String[] getProfilesList() {
        String profileDirName = config.getConfigDirectory() + File.separator + config.get("profile_directory", 0);
        File profileDir = new File(profileDirName);
        Object profilesList = null;
        if (profileDir.isDirectory()) {
            return profileDir.list();
        }
        Log.debug(3, "Error: Can not switch profiles.\n profile_directory is not a directory.");
        return null;
    }

    private void cleanUpFrames() {
        UIController controller = UIController.getInstance();
        controller.removeAllWindows();
        Morpho.makeWelcomeWindow();
    }

    private static void makeWelcomeWindow() {
        UIController controller = UIController.getInstance();
        initialFrame = controller.addWindow(INITIALFRAMENAME);
        initialFrame.setMainContentPane(new InitialScreen(thisStaticInstance, initialFrame));
        initialFrame.setSize((int)UISettings.DEFAULT_WINDOW_WIDTH, (int)UISettings.DEFAULT_WINDOW_HEIGHT);
        initialFrame.setVisible(true);
    }

    private Object createObject(String className) {
        Object object = null;
        try {
            Class<?> classDefinition = Class.forName(className);
            object = classDefinition.newInstance();
        }
        catch (InstantiationException e) {
            Log.debug(1, e.toString());
        }
        catch (IllegalAccessException e) {
            Log.debug(1, e.toString());
        }
        catch (ClassNotFoundException e) {
            Log.debug(1, e.toString());
        }
        return object;
    }

    private void doLogoutCleanup() {
        HttpMessage.setCookie(null);
        connected = false;
        UIController.getInstance().updateAllStatusBars();
        this.fireConnectionChangedEvent();
    }

    private void fireConnectionChangedEvent() {
        for (int i = 0; i < this.connectionRegistry.size(); ++i) {
            ConnectionListener listener = (ConnectionListener)this.connectionRegistry.elementAt(i);
            if (listener == null) continue;
            listener.connectionChanged(Morpho.isConnected());
        }
    }

    private void fireUsernameChangedEvent() {
        for (int i = 0; i < this.connectionRegistry.size(); ++i) {
            ConnectionListener listener = (ConnectionListener)this.connectionRegistry.elementAt(i);
            if (listener == null) continue;
            listener.usernameChanged(this.getUserName());
        }
    }

    private static void fireProfileAdded() {
        for (ProfileAddedListener listener : profileAddedListenerList) {
            if (listener == null) continue;
            listener.profileAdded(Morpho.getCurrentProfileName());
        }
    }

    public void addProfileAddedListener(ProfileAddedListener listener) {
        if (listener != null) {
            profileAddedListenerList.add(listener);
        }
    }

    private void loadConfigurationParameters() {
        this.metacatURL = config.get("metacat_url", 0);
        String temp_uname = config.get("username", 0);
        this.userName = temp_uname != null ? temp_uname : "public";
    }

    public void setMetacatURLString(String mURL) {
        this.metacatURL = mURL;
    }

    public String getMetacatURLString() {
        return this.metacatURL;
    }

    private Vector sortValues(Hashtable hash) {
        Vector sorted = new Vector();
        for (int i = 0; i < 20; ++i) {
            Integer iii = new Integer(i);
            Enumeration www = hash.keys();
            while (www.hasMoreElements()) {
                Object thiskey = www.nextElement();
                if (!iii.equals(thiskey)) continue;
                sorted.addElement(hash.get(thiskey));
            }
        }
        return sorted;
    }

    private void doPing() {
        this.doPing(false);
    }

    private void doPing(final boolean isStartUp) {
        if (!connectionBusy) {
            SwingWorker sbUpdater = new SwingWorker(){

                public Object construct() {
                    Morpho.this.startPing();
                    return null;
                }

                public void finished() {
                    Morpho.this.finishPing(isStartUp);
                }
            };
            sbUpdater.start();
        }
    }

    private void startPing() {
        block4: {
            this.origNetworkStatus = this.networkStatus;
            try {
                Log.debug(55, "Determining net status ...");
                this.urlConn = this.metacatPingURL.openConnection();
                this.urlConn.connect();
                this.networkStatus = this.urlConn.getDate() > 0L;
                Log.debug(55, "... which is: " + this.networkStatus);
            }
            catch (IOException ioe) {
                Log.debug(55, " - unable to open network connection to Metacat");
                this.networkStatus = false;
                if (this.profile != null) {
                    this.profile.set("searchmetacat", 0, "false");
                }
            }
            catch (NullPointerException npe) {
                Log.debug(55, " - unable to open network connection to Metacat");
                this.networkStatus = false;
                if (this.profile == null) break block4;
                this.profile.set("searchmetacat", 0, "false");
            }
        }
    }

    private void finishPing(boolean isStartUp) {
        Log.debug(55, "doPing() called - network available?? - " + this.networkStatus);
        if (this.origNetworkStatus != this.networkStatus) {
            if (!this.networkStatus) {
                this.profile.set("searchmetacat", 0, "false");
                this.doLogoutCleanup();
            } else if (!isStartUp) {
                // empty if block
            }
            if (!isStartUp) {
                UIController.getInstance().updateAllStatusBars();
            }
        }
    }

    public static void setLookAndFeel(String lnf) {
        block12: {
            try {
                if (lnf != null) {
                    if (lnf.equalsIgnoreCase("kunststoff")) {
                        Log.debug(19, "kunststoff - loading");
                        try {
                            Class<?> classDefinition = Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
                            LookAndFeel test = (LookAndFeel)classDefinition.newInstance();
                            UIManager.setLookAndFeel(test);
                            break block12;
                        }
                        catch (ClassNotFoundException www) {
                            Log.debug(19, "Couldn't set L&F to kunststoff. Using Java default");
                            return;
                        }
                    }
                    if (lnf.equalsIgnoreCase("metal")) {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    } else if (lnf.equalsIgnoreCase("windows")) {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                        Morpho.maybeSetMSWindowsJSplitPaneDividerThickness();
                    } else if (lnf.equalsIgnoreCase("motif")) {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                    } else {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        Morpho.maybeSetMSWindowsJSplitPaneDividerThickness();
                    }
                    break block12;
                }
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                Morpho.maybeSetMSWindowsJSplitPaneDividerThickness();
            }
            catch (Exception e) {
                Log.debug(19, "couldn't set L&F to native - using Java default");
            }
        }
    }

    private static void maybeSetMSWindowsJSplitPaneDividerThickness() {
        if (UIManager.getSystemLookAndFeelClassName().indexOf("WindowsLookAndFeel") < 0) {
            return;
        }
        UIManager.getLookAndFeelDefaults().put("SplitPane.dividerSize", DIVIDER_THICKNESS_FOR_MSWINDOWS);
    }

    private static Socket getSocket(String host, int port) {
        Socket s = null;
        try {
            s = new Socket(host, port);
            return s;
        }
        catch (UnknownHostException u) {
            System.out.println("unknown host in DataFileUploadInterface.getSocket");
        }
        catch (IOException i) {
            return s;
        }
        return s;
    }

    private static void initializeConfiguration() throws FileNotFoundException {
        File configurationFile = null;
        File configDir = new File(ConfigXML.getConfigDirectory());
        if (!configDir.exists() && !configDir.mkdir()) {
            Log.debug(1, "Failed to create config directory");
            System.exit(0);
        }
        boolean copyConfig = false;
        boolean saveOldVersion = false;
        String configVersion = null;
        try {
            configurationFile = new File(configDir, configFile);
            if (configurationFile.createNewFile() || configurationFile.length() == 0L) {
                copyConfig = true;
            } else {
                saveOldVersion = true;
                config = new ConfigXML(configurationFile.getAbsolutePath());
                configVersion = config.get("version", 0);
                if (!configVersion.equals(VERSION)) {
                    copyConfig = true;
                }
            }
            if (copyConfig) {
                if (saveOldVersion) {
                    String extension = ".saved";
                    if (configVersion != null) {
                        extension = "." + configVersion;
                    }
                    File savedConfigFile = new File(configurationFile.getAbsolutePath() + extension);
                    configurationFile.renameTo(savedConfigFile);
                }
                configurationFile.createNewFile();
                FileOutputStream out = new FileOutputStream(configurationFile);
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                InputStream configInput = cl.getResourceAsStream(configFile);
                if (configInput == null) {
                    Log.debug(1, "Could not find default configuration file.");
                    System.exit(0);
                }
                byte[] buf = new byte[4096];
                int len = 0;
                while ((len = configInput.read(buf, 0, 4096)) != -1) {
                    out.write(buf, 0, len);
                }
                configInput.close();
                out.close();
                config = new ConfigXML(configurationFile.getAbsolutePath());
            }
        }
        catch (IOException ioe) {
            Log.debug(1, "Error copying config: " + ioe.getMessage());
            Log.debug(1, ioe.getClass().getName());
            System.exit(1);
        }
    }

    public static void initializeLogging(ConfigXML config) {
        Log log = Log.getLog();
        debug_level = new Integer(config.get("debug_level", 0));
        Log.setDebugLevel(debug_level);
        String log_file_setting = config.get("log_file", 0);
        if (log_file_setting != null) {
            log_file = log_file_setting.equalsIgnoreCase("true");
        }
        if (log_file) {
            try {
                FileOutputStream err = new FileOutputStream("stderr.log");
                PrintStream errPrintStream = new PrintStream(err);
                System.setErr(errPrintStream);
                System.setOut(errPrintStream);
            }
            catch (FileNotFoundException fnfe) {
                Log.debug(10, "Warning: Failure to redirect log to a file.");
            }
        }
    }

    private void loadProfile(Morpho morpho) throws FileNotFoundException {
        File configDir = new File(ConfigXML.getConfigDirectory());
        File profileFile = null;
        try {
            profileFile = new File(configDir, profileFileName);
            if (profileFile.createNewFile() || profileFile.length() == 0L) {
                FileWriter out = new FileWriter(profileFile);
                out.write("<current_profile></current_profile>\n");
                out.close();
            }
        }
        catch (IOException ioe) {
            Log.debug(1, "Error creating profile marker: " + ioe.getMessage());
            Log.debug(1, ioe.getClass().getName());
            System.exit(1);
        }
        profileConfig = new ConfigXML(profileFile.getAbsolutePath());
        String profileDir = ConfigXML.getConfigDirectory() + File.separator + config.get("profile_directory", 0);
        String currentProfile = Morpho.getCurrentProfileName();
        if (currentProfile == null) {
            ProfileDialog dialog = new ProfileDialog(morpho);
            dialog.setVisible(true);
            if (this.getProfile() == null) {
                JOptionPane.showMessageDialog(null, "You must create a profile in order to configure Morpho  \ncorrectly.  Please restart Morpho and try again.");
                this.exitApplication();
            }
        } else {
            String profileName = profileDir + File.separator + currentProfile + File.separator + currentProfile + ".xml";
            ConfigXML profile = new ConfigXML(profileName);
            profile.set("searchmetacat", 0, "false");
            this.setProfileDontLogin(profile);
        }
    }

    static {
        connected = false;
        profileAddedListenerList = new ArrayList();
        configFile = "config.xml";
        profileFileName = "currentprofile.xml";
        debug = true;
        debug_level = 9;
        connectionBusy = false;
    }

    public static class CreateNewProfileCommand
    implements Command {
        public void execute(ActionEvent e) {
            Morpho.createNewProfile();
        }
    }
}

