/*
 * Decompiled with CFR 0.152.
 */
package edu.tesc.scidb.databank.sms.tdm;

import edu.tesc.scidb.databank.sms.tdm.Database;
import edu.tesc.scidb.databank.sms.tdm.Insert;
import edu.tesc.scidb.databank.sms.tdm.Relationship;
import edu.tesc.scidb.databank.sms.tdm.Table;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class DatabaseImpl
implements Database {
    private String name;
    private Map tables;
    private Map relationships;
    private List inserts;
    private Map props;

    public void setProperty(String name, Object value) {
        this.props.put(name, value);
    }

    public Object getProperty(String name) {
        return this.props.get(name);
    }

    public DatabaseImpl(String name) {
        this.name = name;
        this.tables = new TreeMap();
        this.inserts = new LinkedList();
        this.relationships = new TreeMap();
        this.props = new TreeMap();
        this.setProperty("vizModules", new LinkedList());
        this.setProperty("accessForms", new LinkedList());
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTargetDBMS() {
    }

    public String getName() {
        return this.name;
    }

    public Collection getTables() {
        return this.tables.values();
    }

    public Table getTable(String name) {
        return (Table)this.tables.get(name);
    }

    public String getTargetDBMS() {
        return null;
    }

    public Collection getRelationships() {
        return this.relationships.values();
    }

    public void addTable(Table table) {
        this.tables.put(table.getName(), table);
    }

    public void addRelationship(Relationship rel) {
        this.relationships.put(rel.getName(), rel);
    }

    public Collection getInserts() {
        return this.inserts;
    }

    public void addInsert(Insert insert) {
        this.inserts.add(insert);
        System.err.println("adding insert to db");
    }

    public String toString() {
        return "DatabaseImpl name=" + this.name + "\n" + this.tables + "\n" + this.relationships + "\n";
    }

    public String getAsEML() {
        DocumentFactory docfac = new DocumentFactory();
        Element emlElement = docfac.createElement("eml");
        Document emlDocument = docfac.createDocument();
        List vizModules = (List)this.getProperty("vizModules");
        if (vizModules != null) {
            for (String moduleName : vizModules) {
                emlDocument.addProcessingInstruction("CanopyView", "visualizationModule=\"" + moduleName + "\"");
            }
        }
        emlElement.addAttribute("packageId", "eml.1.1");
        emlElement.addAttribute("system", "knb");
        Namespace nameSpace1 = docfac.createNamespace("eml", "eml://ecoinformatics.org/eml-2.0.0");
        emlElement.add(nameSpace1);
        Namespace nameSpace2 = docfac.createNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        emlElement.add(nameSpace2);
        Namespace nameSpace3 = docfac.createNamespace("ds", "eml://ecoinformatics.org/dataset-2.0.0");
        emlElement.add(nameSpace3);
        QName qName = docfac.createQName("eml", nameSpace1);
        emlElement.setQName(qName);
        Element element = this.getAsEML(emlElement);
        emlDocument.add(emlElement);
        OutputFormat format = OutputFormat.createPrettyPrint();
        StringWriter sw = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)sw, format);
        try {
            writer.write(emlDocument);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sw.toString();
    }

    public Element getAsEML(Element parent) {
        Element dataset = parent.addElement("dataset");
        Element title = dataset.addElement("title");
        title.setText("A Canopy DataBank Generated Dataset");
        Element creator = dataset.addElement("creator");
        creator.addAttribute("id", "18481");
        Element individualName = creator.addElement("individualName");
        Element surName = individualName.addElement("surName");
        surName.setText("Smith");
        Element contact = dataset.addElement("contact");
        Element references = contact.addElement("references");
        references.setText("18481");
        Collection tables = this.getTables();
        for (Table table : tables) {
            table.getAsEML(dataset);
        }
        return dataset;
    }
}

