/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.dtd;

import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class DTDAttlist
implements DTDOutput {
    public String name;
    public Vector attributes;

    public DTDAttlist() {
        this.attributes = new Vector();
    }

    public DTDAttlist(String aName) {
        this.name = aName;
        this.attributes = new Vector();
    }

    public void write(PrintWriter out) throws IOException {
        out.print("<!ATTLIST ");
        out.println(this.name);
        int len = this.attributes.size();
        for (int i = 0; i < len; ++i) {
            out.print("           ");
            DTDAttribute attr = (DTDAttribute)this.attributes.elementAt(i);
            attr.write(out);
            if (i < len - 1) {
                out.println();
                continue;
            }
            out.println(">");
        }
    }

    public boolean equals(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof DTDAttlist)) {
            return false;
        }
        DTDAttlist other = (DTDAttlist)ob;
        if (this.name == null && other.name != null) {
            return false;
        }
        if (this.name != null && !this.name.equals(other.name)) {
            return false;
        }
        return this.attributes.equals(other.attributes);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public DTDAttribute[] getAttribute() {
        Object[] attrs = new DTDAttribute[this.attributes.size()];
        this.attributes.copyInto(attrs);
        return attrs;
    }

    public void setAttribute(DTDAttribute[] attrs) {
        this.attributes = new Vector(attrs.length);
        for (int i = 0; i < attrs.length; ++i) {
            this.attributes.addElement(attrs[i]);
        }
    }

    public DTDAttribute getAttribute(int i) {
        return (DTDAttribute)this.attributes.elementAt(i);
    }

    public void setAttribute(DTDAttribute attr, int i) {
        this.attributes.setElementAt(attr, i);
    }
}

